/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import java.nio.file.FileSystems;
import java.util.Set;
import org.eclipse.core.internal.filesystem.local.LocalFileHandler;
import org.eclipse.core.internal.filesystem.local.LocalFileNatives;
import org.eclipse.core.internal.filesystem.local.NativeHandler;
import org.eclipse.core.internal.filesystem.local.nio.DefaultHandler;
import org.eclipse.core.internal.filesystem.local.nio.DosHandler;
import org.eclipse.core.internal.filesystem.local.nio.PosixHandler;
import org.eclipse.core.internal.filesystem.local.unix.UnixFileHandler;
import org.eclipse.core.internal.filesystem.local.unix.UnixFileNatives;

public class LocalFileNativesManager {
    private static NativeHandler HANDLER;
    private static boolean USING_NATIVES;

    static {
        boolean nativesAllowed = Boolean.parseBoolean(System.getProperty("eclipse.filesystem.useNatives", "true"));
        if (nativesAllowed && UnixFileNatives.isUsingNatives()) {
            HANDLER = new UnixFileHandler();
            USING_NATIVES = true;
        } else if (nativesAllowed && LocalFileNatives.isUsingNatives()) {
            HANDLER = new LocalFileHandler();
            USING_NATIVES = true;
        } else {
            Set<String> views = FileSystems.getDefault().supportedFileAttributeViews();
            HANDLER = views.contains("posix") ? new PosixHandler() : (views.contains("dos") ? new DosHandler() : new DefaultHandler());
        }
    }

    public static int getSupportedAttributes() {
        return HANDLER.getSupportedAttributes();
    }
}

