/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.mixin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraftforge.srg2source.extract.ExtractUtil;
import net.minecraftforge.srg2source.extract.MixinProcessor;
import net.minecraftforge.srg2source.mixin.AnnotationBase;
import net.minecraftforge.srg2source.mixin.MixinAnnotation;
import net.minecraftforge.srg2source.mixin.MixinInfo;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeLiteral;

public class Mixin
extends AnnotationBase {
    public Mixin(MixinProcessor processor) {
        super(processor, MixinAnnotation.MIXIN);
    }

    @Override
    public boolean process(NormalAnnotation node) {
        ASTNode parent = node.getParent();
        if (!(parent instanceof AbstractTypeDeclaration)) {
            return this.error(node, "Found @Mixin annotation on non-type declaration: " + node.toString());
        }
        ITypeBinding owner = ((AbstractTypeDeclaration)parent).resolveBinding();
        HashSet<String> targets = new HashSet<String>();
        HashMap<String, ITypeBinding> types = new HashMap<String, ITypeBinding>();
        block11: for (MemberValuePair mvp : node.values()) {
            switch (mvp.getName().toString()) {
                case "priority": 
                case "remap": {
                    break;
                }
                case "value": {
                    targets.addAll(this.readClassReferences(mvp.getValue(), types));
                    break;
                }
                case "targets": {
                    if (mvp.getValue().getNodeType() == 45) {
                        StringLiteral literal = (StringLiteral)mvp.getValue();
                        String target = literal.getLiteralValue().replace('.', '/');
                        this.getBuilder().addClassLiteral(literal.getStartPosition(), literal.getLength(), literal.getEscapedValue(), target);
                        targets.add(target);
                        break;
                    }
                    if (mvp.getValue().getNodeType() == 4) {
                        ArrayInitializer init = (ArrayInitializer)mvp.getValue();
                        for (Expression exp : init.expressions()) {
                            if (exp.getNodeType() == 45) {
                                StringLiteral literal = (StringLiteral)exp;
                                String target = literal.getLiteralValue().replace('.', '/');
                                this.getBuilder().addClassLiteral(literal.getStartPosition(), literal.getLength(), literal.getEscapedValue(), target);
                                targets.add(target);
                                continue;
                            }
                            return this.error(node, "Unknown @Mixin member: " + node.toString());
                        }
                        continue block11;
                    }
                    return this.error(node, "Unknown @Mixin member: " + node.toString());
                }
                default: {
                    return this.error(node, "Unknown @Mixin member: " + node.toString());
                }
            }
        }
        MixinInfo info = this.processor.getOrCreateInfo(owner);
        types.forEach(info::addTarget);
        targets.forEach(info::addTarget);
        return true;
    }

    @Override
    public boolean process(SingleMemberAnnotation node) {
        ASTNode parent = node.getParent();
        if (!(parent instanceof AbstractTypeDeclaration)) {
            return this.error(node, "Found @Mixin annotation on non-type declaration: " + node.toString());
        }
        ITypeBinding owner = ((AbstractTypeDeclaration)parent).resolveBinding();
        HashMap<String, ITypeBinding> types = new HashMap<String, ITypeBinding>();
        Collection<String> targets = this.readClassReferences(node.getValue(), types);
        MixinInfo info = this.processor.getOrCreateInfo(owner);
        types.forEach(info::addTarget);
        targets.forEach(info::addTarget);
        return true;
    }

    private Collection<String> readClassReferences(Expression node, Map<String, ITypeBinding> types) {
        if (node.getNodeType() == 57) {
            TypeLiteral literal = (TypeLiteral)node;
            ITypeBinding bind = literal.getType().resolveBinding();
            String name = ExtractUtil.getInternalName(this.getFilename(), bind, literal.getType());
            types.put(name, bind);
            return Arrays.asList(name);
        }
        if (node.getNodeType() == 4) {
            ArrayInitializer init = (ArrayInitializer)node;
            HashSet<String> ret = new HashSet<String>();
            for (Expression exp : init.expressions()) {
                if (exp.getNodeType() == 57) {
                    TypeLiteral literal = (TypeLiteral)exp;
                    ITypeBinding bind = literal.getType().resolveBinding();
                    String name = ExtractUtil.getInternalName(this.getFilename(), bind, literal.getType());
                    types.put(name, bind);
                    ret.add(name);
                    continue;
                }
                this.error(node, "Unknown @Mixin member: " + node.toString());
                return Collections.emptySet();
            }
            return ret;
        }
        this.error(node, "Unknown @Mixin member: " + node.toString());
        return Collections.emptySet();
    }
}

