/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.extract;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.srg2source.api.InputSupplier;
import net.minecraftforge.srg2source.api.SourceVersion;
import net.minecraftforge.srg2source.extract.SymbolReferenceWalker;
import net.minecraftforge.srg2source.range.RangeMap;
import net.minecraftforge.srg2source.range.RangeMapBuilder;
import net.minecraftforge.srg2source.util.Util;
import net.minecraftforge.srg2source.util.io.ConfLogger;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class RangeExtractor
extends ConfLogger<RangeExtractor> {
    private static RangeExtractor INSTANCE = null;
    private PrintWriter output;
    private String sourceVersion;
    private boolean enableBatchedASTs = true;
    private final Set<File> libs = new LinkedHashSet<File>();
    private String[] libArray = null;
    private InputSupplier input;
    private Map<String, RangeMap> file_cache = new HashMap<String, RangeMap>();
    private int cache_hits = 0;
    private boolean enableMixins = false;
    private boolean fatalMixins = false;
    private boolean logWarnings = false;
    private boolean enablePreview = false;

    public void setOutput(PrintWriter value) {
        this.output = value;
    }

    public void setSourceCompatibility(SourceVersion value) {
        this.sourceVersion = value.getSpec();
    }

    public void setBatchASTs(boolean value) {
        this.enableBatchedASTs = value;
    }

    public void enableMixins() {
        this.enableMixins = true;
    }

    public void fatalMixins() {
        this.fatalMixins = true;
    }

    public boolean areMixinsFatal() {
        return this.fatalMixins;
    }

    public void logWarnings() {
        this.logWarnings = true;
    }

    public void enablePreview() {
        this.enablePreview = true;
    }

    public void addLibrary(File value) {
        String fileName = value.getPath().toLowerCase(Locale.ENGLISH);
        if (!value.exists()) {
            this.error("Missing Library: " + value.getAbsolutePath());
        } else if (value.isDirectory()) {
            this.libArray = null;
            this.libs.add(value);
        } else if (fileName.endsWith(".jar") || fileName.endsWith(".jar")) {
            this.libArray = null;
            this.libs.add(value);
        } else {
            this.log("Unsupposrted library path: " + value.getAbsolutePath());
        }
    }

    public void setInput(InputSupplier supplier) {
        this.input = supplier;
    }

    public void loadCache(InputStream stream) throws IOException {
        this.file_cache = RangeMap.readAll(stream);
    }

    @Override
    public void log(String message) {
        super.log("# " + message);
    }

    public boolean run() {
        this.log("Symbol range map extraction starting");
        String[] files = (String[])this.input.gatherAll(".java").stream().map(f -> f.replaceAll("\\\\", "/")).sorted().toArray(String[]::new);
        this.log("Processing " + files.length + " files");
        if (files.length == 0) {
            this.cleanup();
            return true;
        }
        if (this.canBatchASTs()) {
            return this.batchGenerate(files);
        }
        return this.legacyGenerate(files);
    }

    private boolean legacyGenerate(String[] files) {
        try {
            for (String path : files) {
                Charset encoding = this.input.getEncoding(path);
                if (encoding == null) {
                    encoding = StandardCharsets.UTF_8;
                }
                try (InputStream stream = this.input.getInput(path);){
                    String data = new String(Util.readStream(stream), encoding);
                    String md5 = Util.md5(data, encoding);
                    RangeMapBuilder builder = new RangeMapBuilder(this, path, md5);
                    this.log("startProcessing \"" + path + "\" md5: " + md5);
                    RangeMap cache = this.file_cache.get(path);
                    if (builder.loadCache(cache)) {
                        this.log("Cache Hit!");
                        ++this.cache_hits;
                    } else {
                        ASTParser parser = this.createParser(this.input.getRoot(path));
                        parser.setUnitName(path);
                        parser.setSource(data.toCharArray());
                        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
                        if (cu.getProblems() != null && cu.getProblems().length > 0) {
                            Arrays.stream(cu.getProblems()).filter(p -> !p.isWarning()).forEach(p -> this.log("   Compile Error! " + p.toString()));
                        }
                        SymbolReferenceWalker walker = new SymbolReferenceWalker(this, builder, this.enableMixins);
                        walker.safeWalk(cu);
                    }
                    RangeMap range = builder.build();
                    if (this.output != null) {
                        range.write(this.output, true);
                    }
                    this.log("endProcessing \"" + path + "\"");
                    this.log("");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.getErrorLogger());
        }
        this.cleanup();
        return true;
    }

    private boolean batchGenerate(String[] files) {
        if (INSTANCE != null) {
            throw new IllegalStateException("Can not do batched processing while another is running!");
        }
        INSTANCE = this;
        ASTParser parser = this.createParser(null);
        FileASTRequestor requestor = new FileASTRequestor(){

            @Override
            public void acceptAST(String path, CompilationUnit cu) {
                Charset encoding = RangeExtractor.this.input.getEncoding(path = path.replace(File.separatorChar, '/'));
                if (encoding == null) {
                    encoding = StandardCharsets.UTF_8;
                }
                try (InputStream stream = RangeExtractor.this.input.getInput(path);){
                    String data = new String(Util.readStream(stream), encoding);
                    String md5 = Util.md5(data, encoding);
                    RangeMapBuilder builder = new RangeMapBuilder(RangeExtractor.this, path, md5);
                    RangeExtractor.this.log("startProcessing \"" + path + "\" md5: " + md5);
                    RangeMap cache = RangeExtractor.this.file_cache.get(path);
                    if (builder.loadCache(cache)) {
                        RangeExtractor.this.log("Cache Hit!");
                        ++RangeExtractor.this.cache_hits;
                    } else {
                        if (cu.getProblems() != null && cu.getProblems().length > 0) {
                            Arrays.stream(cu.getProblems()).filter(p -> RangeExtractor.this.logWarnings || !p.isWarning()).forEach(p -> RangeExtractor.this.log("   Compile Error! " + p.toString()));
                        }
                        SymbolReferenceWalker walker = new SymbolReferenceWalker(RangeExtractor.this, builder, RangeExtractor.this.enableMixins);
                        walker.safeWalk(cu);
                    }
                    RangeMap range = builder.build();
                    if (RangeExtractor.this.output != null) {
                        range.write(RangeExtractor.this.output, true);
                    }
                    RangeExtractor.this.log("endProcessing \"" + path + "\"");
                    RangeExtractor.this.log("");
                }
                catch (IOException e) {
                    e.printStackTrace(RangeExtractor.this.getErrorLogger());
                }
            }
        };
        NullProgressMonitor monitor = new NullProgressMonitor();
        parser.createASTs(files, null, new String[0], requestor, monitor);
        this.cleanup();
        INSTANCE = null;
        return true;
    }

    private void cleanup() {
        try {
            this.input.close();
        }
        catch (IOException e) {
            e.printStackTrace(this.getErrorLogger());
        }
        if (this.output != null) {
            this.output.flush();
            this.output.close();
            this.output = null;
        }
    }

    private String[] getLibArray() {
        if (this.libArray == null) {
            this.libArray = (String[])this.libs.stream().map(File::getAbsolutePath).toArray(String[]::new);
        }
        return this.libArray;
    }

    public int getCacheHits() {
        return this.cache_hits;
    }

    public boolean canBatchASTs() {
        return RangeExtractor.hasBeenASMPatched() && this.enableBatchedASTs;
    }

    private ASTParser createParser(String srcRoot) {
        String[] stringArray;
        ASTParser parser = ASTParser.newParser(16);
        String[] stringArray2 = this.getLibArray();
        if (srcRoot == null) {
            stringArray = null;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = srcRoot;
        }
        parser.setEnvironment(stringArray2, stringArray, null, true);
        return this.setOptions(parser);
    }

    private ASTParser setOptions(ASTParser parser) {
        parser.setKind(8);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        Hashtable<String, String> options = JavaCore.getDefaultOptions();
        JavaCore.setComplianceOptions(this.sourceVersion, options);
        if (this.enablePreview) {
            options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        }
        parser.setCompilerOptions(options);
        return parser;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static char[] getFileCharContent(String path, String encoding) {
        RangeExtractor range = INSTANCE;
        Charset charset = range.input.getEncoding(path);
        encoding = charset == null ? StandardCharsets.UTF_8.name() : charset.name();
        try (InputStream input = RangeExtractor.INSTANCE.input.getInput(path);){
            char[] cArray;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, encoding));){
                int len;
                CharArrayWriter writer = new CharArrayWriter();
                char[] buf = new char[1024];
                while ((len = reader.read(buf, 0, 1024)) > 0) {
                    writer.write(buf, 0, len);
                }
                cArray = writer.toCharArray();
            }
            return cArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasBeenASMPatched() {
        return true;
    }
}

