/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraftforge.srg2source.api.RangeExtractorBuilder;
import net.minecraftforge.srg2source.api.SourceVersion;

public class RangeExtractMain {
    private static final ValueConverter<Path> PATH_CONVERTER = new PathConverter(new PathProperties[0]);

    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> libArg = parser.acceptsAll(Arrays.asList("e", "lib")).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<Path> inputArg = parser.acceptsAll(Arrays.asList("in", "input")).withRequiredArg().withValuesConvertedBy(PATH_CONVERTER).required();
        ArgumentAcceptingOptionSpec<Path> outputArg = parser.acceptsAll(Arrays.asList("out", "output")).withRequiredArg().withValuesConvertedBy(PATH_CONVERTER).required();
        ArgumentAcceptingOptionSpec<Boolean> batch = parser.accepts("batch").withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> mixins = parser.accepts("mixins").withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> mixins_fatal = parser.accepts("fatalmixins").withOptionalArg().ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<SourceVersion> jversionArg = parser.acceptsAll(Arrays.asList("sc", "source-compatibility")).withRequiredArg().ofType(SourceVersion.class).defaultsTo(SourceVersion.JAVA_1_8, (SourceVersion[])new SourceVersion[0]).withValuesConvertedBy(new ValueConverter<SourceVersion>(){

            @Override
            public SourceVersion convert(String value) {
                return SourceVersion.parse(value);
            }

            @Override
            public Class<? extends SourceVersion> valueType() {
                return SourceVersion.class;
            }

            @Override
            public String valuePattern() {
                ArrayList<String> ret = new ArrayList<String>();
                for (SourceVersion v : SourceVersion.values()) {
                    ret.add(v.name());
                    ret.add(v.getSpec());
                }
                return ret.stream().collect(Collectors.joining(","));
            }
        });
        try {
            OptionSet options = parser.parse(args);
            boolean enableMixins = options.has(mixins) && options.valueOf(mixins) != false;
            boolean fatalMixins = enableMixins && options.has(mixins_fatal) && options.valueOf(mixins_fatal) != false;
            System.out.println("Compat: " + (Object)((Object)options.valueOf(jversionArg)));
            System.out.println("Output: " + options.valueOf(outputArg));
            System.out.println("Batch:  " + options.valueOf(batch));
            System.out.println("Mixins: " + enableMixins);
            System.out.println("Fatal:  " + fatalMixins);
            RangeExtractorBuilder builder = new RangeExtractorBuilder().sourceCompatibility(options.valueOf(jversionArg)).output(options.valueOf(outputArg)).batch(options.valueOf(batch));
            if (options.has(libArg)) {
                options.valuesOf(libArg).forEach(v -> {
                    System.out.println("Lib:    " + v);
                    builder.library((File)v);
                });
            }
            options.valuesOf(inputArg).forEach(v -> {
                System.out.println("Input:  " + v);
                builder.input((Path)v);
            });
            if (enableMixins) {
                builder.enableMixins();
            }
            if (fatalMixins) {
                builder.fatalMixins();
            }
            builder.build().run();
        }
        catch (OptionException e) {
            parser.printHelpOn(System.out);
            e.printStackTrace();
        }
    }
}

