/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher.api;

import java.util.function.Function;

public class LamdbaExceptionUtils {
    public static <T, R, E extends Exception> Function<T, R> rethrowFunction(Function_WithExceptions<T, R, E> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                LamdbaExceptionUtils.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <R, E extends Exception> R uncheck(Supplier_WithExceptions<R, E> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            LamdbaExceptionUtils.throwAsUnchecked(exception);
            return null;
        }
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    public static interface Supplier_WithExceptions<T, E extends Exception> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface Function_WithExceptions<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

