/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.api.ITransformingClassLoaderBuilder;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.Manifest;

class TransformingClassLoaderBuilder
implements ITransformingClassLoaderBuilder {
    private final List<Path> transformationPaths = new ArrayList<Path>();
    private Function<String, Enumeration<URL>> resourcesLocator;
    private Function<URLConnection, Optional<Manifest>> manifestLocator;

    TransformingClassLoaderBuilder() {
    }

    URL[] getSpecialJarsAsURLs() {
        return (URL[])this.transformationPaths.stream().map(LamdbaExceptionUtils.rethrowFunction(path -> path.toUri().toURL())).toArray(URL[]::new);
    }

    Function<URLConnection, Optional<Manifest>> getManifestLocator() {
        return this.manifestLocator;
    }

    public void addTransformationPath(Path path) {
        this.transformationPaths.add(path);
    }

    public void setResourceEnumeratorLocator(Function<String, Enumeration<URL>> resourceEnumeratorLocator) {
        this.resourcesLocator = resourceEnumeratorLocator;
    }

    Function<String, Enumeration<URL>> getResourceEnumeratorLocator() {
        return this.resourcesLocator != null ? this.resourcesLocator : input -> Collections.emptyEnumeration();
    }
}

