/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.log;

import java.util.regex.Pattern;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.internal.log.ExtendedLogServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.admin.LoggerContext;

public class LoggerImpl
implements Logger {
    static final String THIS_PACKAGE_NAME = LoggerImpl.class.getName().substring(0, LoggerImpl.class.getName().length() - LoggerImpl.class.getSimpleName().length());
    static final Object[] EMPTY = new Object[0];
    protected final ExtendedLogServiceImpl logServiceImpl;
    protected final String name;
    private LogLevel enabledLevel = LogLevel.TRACE;
    private static final Pattern pattern = Pattern.compile("(\\\\?)(\\\\?)(\\{\\})");

    public LoggerImpl(ExtendedLogServiceImpl logServiceImpl, String name, LoggerContext loggerContext) {
        this.logServiceImpl = logServiceImpl;
        this.name = name;
        this.applyLoggerContext(loggerContext);
    }

    @Override
    public void log(Object context, int level, String message, Throwable exception) {
        this.log(context, null, level, message, null, exception);
    }

    private void log(Object context, LogLevel logLevelEnum, int level, String message, ServiceReference<?> ref, Throwable exception) {
        this.log(this.logServiceImpl.getBundle(), context, logLevelEnum, level, message, ref, exception);
    }

    void log(Bundle entryBundle, Object context, LogLevel logLevelEnum, int level, String message, ServiceReference<?> ref, Throwable exception) {
        if (logLevelEnum == null) {
            logLevelEnum = this.getLogLevel(level);
        }
        if (this.enabledLevel.implies(logLevelEnum)) {
            this.logServiceImpl.getFactory().log(entryBundle, this.name, this.getLocation(), context, logLevelEnum, level, message, ref, exception);
        }
    }

    private LogLevel getLogLevel(int level) {
        switch (level) {
            case 4: {
                return LogLevel.DEBUG;
            }
            case 1: {
                return LogLevel.ERROR;
            }
            case 3: {
                return LogLevel.INFO;
            }
            case 2: {
                return LogLevel.WARN;
            }
        }
        return LogLevel.TRACE;
    }

    private StackTraceElement getLocation() {
        if (!this.logServiceImpl.getFactory().captureLogEntryLocation()) {
            return null;
        }
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements.length == 0) {
            return null;
        }
        int i = 1;
        while (i < elements.length) {
            if (!elements[i].getClassName().startsWith(THIS_PACKAGE_NAME)) {
                return elements[i];
            }
            ++i;
        }
        return elements[1];
    }

    void applyLoggerContext(LoggerContext loggerContext) {
        this.enabledLevel = loggerContext == null ? LogLevel.WARN : loggerContext.getEffectiveLogLevel(this.name);
    }
}

