/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.db;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.core.nd.AbstractTypeFactory;
import org.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.db.Chunk;
import org.eclipse.jdt.internal.core.nd.db.Database;
import org.eclipse.jdt.internal.core.nd.db.IBTreeComparator;
import org.eclipse.jdt.internal.core.nd.db.IBTreeVisitor;
import org.eclipse.jdt.internal.core.nd.db.IndexException;

public class BTree {
    private final Nd nd;
    protected final Database db;
    protected final long rootPointer;
    protected final int degree;
    protected final int maxRecords;
    protected final int maxChildren;
    protected final int minRecords;
    protected final int offsetChildren;
    protected final int medianRecord;
    protected final IBTreeComparator cmp;

    public BTree(Nd nd, long rootPointer, int degree, IBTreeComparator cmp) {
        this.nd = nd;
        if (degree < 2) {
            throw new IllegalArgumentException("Illegal degree " + degree + " in tree");
        }
        this.db = nd.getDB();
        this.rootPointer = rootPointer;
        this.cmp = cmp;
        this.degree = degree;
        this.minRecords = this.degree - 1;
        this.maxRecords = 2 * this.degree - 1;
        this.maxChildren = 2 * this.degree;
        this.offsetChildren = this.maxRecords * 4;
        this.medianRecord = this.degree - 1;
    }

    public static ITypeFactory<BTree> getFactory(IBTreeComparator cmp) {
        return BTree.getFactory(8, cmp);
    }

    public static ITypeFactory<BTree> getFactory(final int degree, final IBTreeComparator cmp) {
        return new AbstractTypeFactory<BTree>(){

            @Override
            public BTree create(Nd dom, long address) {
                return new BTree(dom, address, degree, cmp);
            }

            @Override
            public int getRecordSize() {
                return 4;
            }

            @Override
            public Class<?> getElementClass() {
                return BTree.class;
            }

            @Override
            public void destruct(Nd dom, long address) {
                this.destructFields(dom, address);
            }

            @Override
            public void destructFields(Nd dom, long address) {
                this.create(dom, address).destruct();
            }
        };
    }

    protected long getRoot() throws IndexException {
        return this.db.getRecPtr(this.rootPointer);
    }

    protected final void putRecord(Chunk chunk, long node, int index, long record) {
        chunk.putRecPtr(node + (long)(index * 4), record);
    }

    protected final long getRecord(Chunk chunk, long node, int index) {
        return chunk.getRecPtr(node + (long)(index * 4));
    }

    protected final void putChild(Chunk chunk, long node, int index, long child) {
        chunk.putRecPtr(node + (long)this.offsetChildren + (long)(index * 4), child);
    }

    protected final long getChild(Chunk chunk, long node, int index) {
        return chunk.getRecPtr(node + (long)this.offsetChildren + (long)(index * 4));
    }

    public void destruct() {
        long root = this.getRoot();
        if (root == 0L) {
            return;
        }
        this.deallocateChildren(root);
    }

    private void deallocateChildren(long record) {
        Chunk chunk = this.db.getChunk(record);
        long[] children = new long[this.maxRecords + 1];
        int idx = 0;
        while (idx < children.length) {
            children[idx] = this.getChild(chunk, record, idx);
            ++idx;
        }
        this.db.free(record, (short)1);
        chunk = null;
        long[] lArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            long nextChild = lArray[n2];
            if (nextChild != 0L) {
                this.deallocateChildren(nextChild);
            }
            ++n2;
        }
    }

    public long insert(long record) throws IndexException {
        long root = this.getRoot();
        if (root == 0L) {
            this.firstInsert(record);
            return record;
        }
        return this.insert(null, 0L, 0, root, record);
    }

    private long insert(Chunk pChunk, long parent, int iParent, long node, long record) throws IndexException {
        int i;
        long r;
        Chunk chunk = this.db.getChunk(node);
        if (this.getRecord(chunk, node, this.maxRecords - 1) != 0L) {
            long median = this.getRecord(chunk, node, this.medianRecord);
            if (median == record) {
                return median;
            }
            chunk.makeDirty();
            long newnode = this.allocateNode();
            Chunk newchunk = this.db.getChunk(newnode);
            int i2 = 0;
            while (i2 < this.medianRecord) {
                this.putRecord(newchunk, newnode, i2, this.getRecord(chunk, node, this.medianRecord + 1 + i2));
                this.putRecord(chunk, node, this.medianRecord + 1 + i2, 0L);
                this.putChild(newchunk, newnode, i2, this.getChild(chunk, node, this.medianRecord + 1 + i2));
                this.putChild(chunk, node, this.medianRecord + 1 + i2, 0L);
                ++i2;
            }
            this.putChild(newchunk, newnode, this.medianRecord, this.getChild(chunk, node, this.maxRecords));
            this.putChild(chunk, node, this.maxRecords, 0L);
            if (parent == 0L) {
                parent = this.allocateNode();
                pChunk = this.db.getChunk(parent);
                this.db.putRecPtr(this.rootPointer, parent);
                this.putChild(pChunk, parent, 0, node);
            } else {
                i2 = this.maxRecords - 2;
                while (i2 >= iParent) {
                    r = this.getRecord(pChunk, parent, i2);
                    if (r != 0L) {
                        pChunk = pChunk.getWritableChunk();
                        this.putRecord(pChunk, parent, i2 + 1, r);
                        this.putChild(pChunk, parent, i2 + 2, this.getChild(pChunk, parent, i2 + 1));
                    }
                    --i2;
                }
            }
            pChunk = pChunk.getWritableChunk();
            this.putRecord(pChunk, parent, iParent, median);
            this.putChild(pChunk, parent, iParent + 1, newnode);
            this.putRecord(chunk, node, this.medianRecord, 0L);
            if (this.cmp.compare(this.nd, record, median) > 0) {
                node = newnode;
                chunk = newchunk;
            }
        }
        int lower = 0;
        int upper = this.maxRecords - 1;
        while (lower < upper && this.getRecord(chunk, node, upper - 1) == 0L) {
            --upper;
        }
        while (lower < upper) {
            int middle = (lower + upper) / 2;
            long checkRec = this.getRecord(chunk, node, middle);
            if (checkRec == 0L) {
                upper = middle;
                continue;
            }
            int compare = this.cmp.compare(this.nd, checkRec, record);
            if (compare > 0) {
                upper = middle;
                continue;
            }
            if (compare < 0) {
                lower = middle + 1;
                continue;
            }
            return checkRec;
        }
        chunk = this.db.getChunk(node);
        long child = this.getChild(chunk, node, i = lower);
        if (child != 0L) {
            return this.insert(chunk, node, i, child, record);
        }
        int j = this.maxRecords - 2;
        while (j >= i) {
            r = this.getRecord(chunk, node, j);
            if (r != 0L) {
                this.putRecord(chunk, node, j + 1, r);
            }
            --j;
        }
        this.putRecord(chunk, node, i, record);
        return record;
    }

    private void firstInsert(long record) throws IndexException {
        long root = this.allocateNode();
        this.db.putRecPtr(this.rootPointer, root);
        this.putRecord(this.db.getChunk(root), root, 0, record);
    }

    private long allocateNode() throws IndexException {
        return this.db.malloc((2 * this.maxRecords + 1) * 4, (short)1);
    }

    public void delete(long record) throws IndexException {
        try {
            this.deleteImp(record, this.getRoot(), 0);
        }
        catch (BTreeKeyNotFoundException bTreeKeyNotFoundException) {}
    }

    private long deleteImp(long key, long nodeRecord, int mode) throws IndexException, BTreeKeyNotFoundException {
        int subtreeIndex;
        BTNode node = new BTNode(nodeRecord);
        int keyIndexInNode = -1;
        if (mode == 0) {
            int i = 0;
            while (i < node.keyCount) {
                if (this.getRecord(node.chunk, node.node, i) == key) {
                    keyIndexInNode = i;
                    break;
                }
                ++i;
            }
        }
        if (this.getChild(node.chunk, node.node, 0) == 0L) {
            if (keyIndexInNode != -1) {
                this.nodeContentDelete(node, keyIndexInNode, 1);
                return key;
            }
            if (mode == 1) {
                long subst = this.getRecord(node.chunk, node.node, 0);
                this.nodeContentDelete(node, 0, 1);
                return subst;
            }
            if (mode == 2) {
                long subst = this.getRecord(node.chunk, node.node, node.keyCount - 1);
                this.nodeContentDelete(node, node.keyCount - 1, 1);
                return subst;
            }
            throw new BTreeKeyNotFoundException("Deletion on absent key " + key + ", mode = " + mode);
        }
        if (keyIndexInNode != -1) {
            BTNode succ = node.getChild(keyIndexInNode + 1);
            if (succ != null && succ.keyCount > this.minRecords) {
                node.makeWritable();
                long subst = this.deleteImp(-1L, succ.node, 1);
                this.putRecord(node.chunk, node.node, keyIndexInNode, subst);
                return key;
            }
            BTNode pred = node.getChild(keyIndexInNode);
            if (pred != null && pred.keyCount > this.minRecords) {
                node.makeWritable();
                long subst = this.deleteImp(-1L, pred.node, 2);
                this.putRecord(node.chunk, node.node, keyIndexInNode, subst);
                return key;
            }
            if (pred != null) {
                succ.makeWritable();
                node.makeWritable();
                pred.makeWritable();
                this.mergeNodes(succ, node, keyIndexInNode, pred);
                return this.deleteImp(key, pred.node, mode);
            }
            return key;
        }
        block0 : switch (mode) {
            case 0: {
                subtreeIndex = node.keyCount;
                int i = 0;
                while (i < node.keyCount) {
                    if (this.cmp.compare(this.nd, this.getRecord(node.chunk, node.node, i), key) > 0) {
                        subtreeIndex = i;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                subtreeIndex = 0;
                break;
            }
            case 2: {
                subtreeIndex = node.keyCount;
                break;
            }
            default: {
                throw new IndexException(new Status(4, "org.eclipse.jdt.core", 0, "Unknown delete mode " + mode, null));
            }
        }
        BTNode child = node.getChild(subtreeIndex);
        if (child == null) {
            throw new IndexException(new Status(4, "org.eclipse.jdt.core", 0, "BTree integrity error (null child found)", null));
        }
        if (child.keyCount > this.minRecords) {
            return this.deleteImp(key, child.node, mode);
        }
        child.makeWritable();
        node.makeWritable();
        BTNode sibR = node.getChild(subtreeIndex + 1);
        if (sibR != null && sibR.keyCount > this.minRecords) {
            sibR.makeWritable();
            long rightKey = this.getRecord(node.chunk, node.node, subtreeIndex);
            long leftmostRightSiblingKey = this.getRecord(sibR.chunk, sibR.node, 0);
            this.append(child, rightKey, this.getChild(sibR.chunk, sibR.node, 0));
            this.nodeContentDelete(sibR, 0, 1);
            this.putRecord(node.chunk, node.node, subtreeIndex, leftmostRightSiblingKey);
            return this.deleteImp(key, child.node, mode);
        }
        BTNode sibL = node.getChild(subtreeIndex - 1);
        if (sibL != null && sibL.keyCount > this.minRecords) {
            sibL.makeWritable();
            long leftKey = this.getRecord(node.chunk, node.node, subtreeIndex - 1);
            this.prepend(child, leftKey, this.getChild(sibL.chunk, sibL.node, sibL.keyCount));
            long rightmostLeftSiblingKey = this.getRecord(sibL.chunk, sibL.node, sibL.keyCount - 1);
            this.putRecord(sibL.chunk, sibL.node, sibL.keyCount - 1, 0L);
            this.putChild(sibL.chunk, sibL.node, sibL.keyCount, 0L);
            this.putRecord(node.chunk, node.node, subtreeIndex - 1, rightmostLeftSiblingKey);
            return this.deleteImp(key, child.node, mode);
        }
        if (sibL != null) {
            this.mergeNodes(child, node, subtreeIndex - 1, sibL);
            return this.deleteImp(key, sibL.node, mode);
        }
        if (sibR != null) {
            this.mergeNodes(sibR, node, subtreeIndex, child);
            return this.deleteImp(key, child.node, mode);
        }
        throw new BTreeKeyNotFoundException(MessageFormat.format("Deletion of key not in btree: {0} mode={1}", new Long(key), new Integer(mode)));
    }

    public void mergeNodes(BTNode src, BTNode keyProvider, int kIndex, BTNode dst) throws IndexException {
        long rootNode;
        this.nodeContentCopy(src, 0, dst, dst.keyCount + 1, src.keyCount + 1);
        long midKey = this.getRecord(keyProvider.chunk, keyProvider.node, kIndex);
        this.putRecord(dst.chunk, dst.node, dst.keyCount, midKey);
        long keySucc = kIndex + 1 == this.maxRecords ? 0L : this.getRecord(keyProvider.chunk, keyProvider.node, kIndex + 1);
        this.db.free(this.getChild(keyProvider.chunk, keyProvider.node, kIndex + 1), (short)1);
        this.nodeContentDelete(keyProvider, kIndex + 1, 1);
        this.putRecord(keyProvider.chunk, keyProvider.node, kIndex, keySucc);
        if (kIndex == 0 && keySucc == 0L && (rootNode = this.getRoot()) == keyProvider.node) {
            this.db.putRecPtr(this.rootPointer, dst.node);
            this.db.free(rootNode, (short)1);
        }
    }

    private void prepend(BTNode node, long key, long child) {
        this.nodeContentCopy(node, 0, node, 1, node.keyCount + 1);
        this.putRecord(node.chunk, node.node, 0, key);
        this.putChild(node.chunk, node.node, 0, child);
    }

    private void append(BTNode node, long key, long child) {
        this.putRecord(node.chunk, node.node, node.keyCount, key);
        this.putChild(node.chunk, node.node, node.keyCount + 1, child);
    }

    private void nodeContentCopy(BTNode src, int srcPos, BTNode dst, int dstPos, int length) {
        int i = length - 1;
        while (i >= 0) {
            int srcIndex = srcPos + i;
            int dstIndex = dstPos + i;
            if (srcIndex < src.keyCount + 1) {
                long srcChild = this.getChild(src.chunk, src.node, srcIndex);
                this.putChild(dst.chunk, dst.node, dstIndex, srcChild);
                if (srcIndex < src.keyCount) {
                    long srcKey = this.getRecord(src.chunk, src.node, srcIndex);
                    this.putRecord(dst.chunk, dst.node, dstIndex, srcKey);
                }
            }
            --i;
        }
    }

    private void nodeContentDelete(BTNode node, int i, int length) {
        int index = i;
        while (index <= this.maxRecords) {
            long newChild;
            long newKey = index + length < node.keyCount ? this.getRecord(node.chunk, node.node, index + length) : 0L;
            long l = newChild = index + length < node.keyCount + 1 ? this.getChild(node.chunk, node.node, index + length) : 0L;
            if (index < this.maxRecords) {
                this.putRecord(node.chunk, node.node, index, newKey);
            }
            if (index < this.maxChildren) {
                this.putChild(node.chunk, node.node, index, newChild);
            }
            ++index;
        }
    }

    public boolean accept(IBTreeVisitor visitor) throws IndexException {
        return this.accept(this.db.getRecPtr(this.rootPointer), visitor);
    }

    private boolean accept(long node, IBTreeVisitor visitor) throws IndexException {
        if (node == 0L) {
            return true;
        }
        if (visitor instanceof IBTreeVisitor2) {
            ((IBTreeVisitor2)visitor).preNode(node);
        }
        try {
            int compare;
            Chunk chunk = this.db.getChunk(node);
            int lower = 0;
            int upper = this.maxRecords - 1;
            while (lower < upper && this.getRecord(chunk, node, upper - 1) == 0L) {
                --upper;
            }
            while (lower < upper) {
                int middle = (lower + upper) / 2;
                long checkRec = this.getRecord(chunk, node, middle);
                if (checkRec == 0L) {
                    upper = middle;
                    continue;
                }
                compare = visitor.compare(checkRec);
                if (compare >= 0) {
                    upper = middle;
                    continue;
                }
                lower = middle + 1;
            }
            int i = lower;
            while (i < this.maxRecords) {
                long record = this.getRecord(chunk, node, i);
                if (record == 0L) break;
                compare = visitor.compare(record);
                if (compare > 0) {
                    boolean bl = this.accept(this.getChild(chunk, node, i), visitor);
                    return bl;
                }
                if (compare == 0) {
                    if (!this.accept(this.getChild(chunk, node, i), visitor)) {
                        return false;
                    }
                    if (!visitor.visit(record)) {
                        return false;
                    }
                }
                ++i;
            }
            boolean bl = this.accept(this.getChild(chunk, node, i), visitor);
            return bl;
        }
        finally {
            if (visitor instanceof IBTreeVisitor2) {
                ((IBTreeVisitor2)visitor).postNode(node);
            }
        }
    }

    private class BTNode {
        final long node;
        final int keyCount;
        Chunk chunk;

        BTNode(long node) throws IndexException {
            this.node = node;
            this.chunk = BTree.this.db.getChunk(node);
            int i = 0;
            while (i < BTree.this.maxRecords && BTree.this.getRecord(this.chunk, node, i) != 0L) {
                ++i;
            }
            this.keyCount = i;
        }

        BTNode getChild(int index) throws IndexException {
            long child;
            if (index >= 0 && index < BTree.this.maxChildren && (child = BTree.this.getChild(this.chunk, this.node, index)) != 0L) {
                return new BTNode(child);
            }
            return null;
        }

        public void makeWritable() {
            this.chunk = this.chunk.getWritableChunk();
        }
    }

    private class BTreeKeyNotFoundException
    extends Exception {
        public BTreeKeyNotFoundException(String msg) {
            super(msg);
        }
    }

    private static interface IBTreeVisitor2
    extends IBTreeVisitor {
        public void preNode(long var1) throws IndexException;

        public void postNode(long var1) throws IndexException;
    }
}

