/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DeltaProcessor;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.util.Messages;

public abstract class JavaModelOperation
implements IWorkspaceRunnable,
IProgressMonitor {
    protected static boolean POST_ACTION_VERBOSE;
    protected IPostAction[] actions;
    protected int actionsStart = 0;
    protected int actionsEnd = -1;
    protected HashMap attributes;
    protected IJavaElement[] elementsToProcess;
    protected static final IJavaElement[] NO_ELEMENTS;
    protected IJavaElement[] resultElements = NO_ELEMENTS;
    public SubMonitor progressMonitor = SubMonitor.convert(null);
    protected boolean isNested = false;
    protected boolean force = false;
    protected static final ThreadLocal OPERATION_STACKS;

    static {
        NO_ELEMENTS = new IJavaElement[0];
        OPERATION_STACKS = new ThreadLocal();
    }

    protected JavaModelOperation() {
    }

    protected JavaModelOperation(IJavaElement[] elements) {
        this.elementsToProcess = elements;
    }

    protected JavaModelOperation(IJavaElement element) {
        this.elementsToProcess = new IJavaElement[]{element};
    }

    protected void addDelta(IJavaElementDelta delta) {
        JavaModelManager.getJavaModelManager().getDeltaProcessor().registerJavaModelDelta(delta);
    }

    protected void addReconcileDelta(ICompilationUnit workingCopy, IJavaElementDelta delta) {
        Map<ICompilationUnit, IJavaElementDelta> reconcileDeltas = JavaModelManager.getJavaModelManager().getDeltaProcessor().reconcileDeltas;
        JavaElementDelta previousDelta = (JavaElementDelta)reconcileDeltas.get(workingCopy);
        if (previousDelta != null) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                JavaElementDelta child = (JavaElementDelta)children[i];
                previousDelta.insertDeltaTree(child.getElement(), child);
                ++i;
            }
            if ((delta.getFlags() & 0x80000) != 0) {
                previousDelta.changedAST(delta.getCompilationUnitAST());
            }
        } else {
            reconcileDeltas.put(workingCopy, delta);
        }
    }

    @Override
    public void beginTask(String name, int totalWork) {
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask(name, totalWork);
        }
    }

    protected boolean canModifyRoots() {
        return false;
    }

    protected void checkCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException(Messages.operation_cancelled);
        }
    }

    protected IJavaModelStatus commonVerify() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return new JavaModelStatus(968);
        }
        int i = 0;
        while (i < this.elementsToProcess.length) {
            if (this.elementsToProcess[i] == null) {
                return new JavaModelStatus(968);
            }
            ++i;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    @Override
    public void done() {
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
    }

    protected abstract void executeOperation() throws JavaModelException;

    protected static Object getAttribute(Object key) {
        ArrayList stack = JavaModelOperation.getCurrentOperationStack();
        if (stack.size() == 0) {
            return null;
        }
        JavaModelOperation topLevelOp = (JavaModelOperation)stack.get(0);
        if (topLevelOp.attributes == null) {
            return null;
        }
        return topLevelOp.attributes.get(key);
    }

    protected static ArrayList getCurrentOperationStack() {
        ArrayList stack = (ArrayList)OPERATION_STACKS.get();
        if (stack == null) {
            stack = new ArrayList();
            OPERATION_STACKS.set(stack);
        }
        return stack;
    }

    protected IJavaElement getElementToProcess() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return null;
        }
        return this.elementsToProcess[0];
    }

    public IJavaModel getJavaModel() {
        return JavaModelManager.getJavaModelManager().getJavaModel();
    }

    protected ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean hasModifiedResource() {
        return !this.isReadOnly() && JavaModelOperation.getAttribute("hasModifiedResource") == "true";
    }

    @Override
    public void internalWorked(double work) {
        if (this.progressMonitor != null) {
            this.progressMonitor.internalWorked(work);
        }
    }

    @Override
    public boolean isCanceled() {
        if (this.progressMonitor != null) {
            return this.progressMonitor.isCanceled();
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean isTopLevelOperation() {
        ArrayList stack = JavaModelOperation.getCurrentOperationStack();
        return stack.size() > 0 && stack.get(0) == this;
    }

    protected JavaModelOperation popOperation() {
        ArrayList stack = JavaModelOperation.getCurrentOperationStack();
        int size = stack.size();
        if (size > 0) {
            if (size == 1) {
                OPERATION_STACKS.set(null);
            }
            return (JavaModelOperation)stack.remove(size - 1);
        }
        return null;
    }

    protected void pushOperation(JavaModelOperation operation) {
        JavaModelOperation.getCurrentOperationStack().add(operation);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        block27: {
            SubMonitor oldMonitor = this.progressMonitor;
            try {
                JavaModelManager manager = JavaModelManager.getJavaModelManager();
                DeltaProcessor deltaProcessor = manager.getDeltaProcessor();
                int previousDeltaCount = deltaProcessor.javaModelDeltas.size();
                try {
                    this.progressMonitor = SubMonitor.convert(monitor);
                    this.pushOperation(this);
                    try {
                        if (this.canModifyRoots()) {
                            JavaModelManager.getDeltaState().initializeRoots(false);
                        }
                        this.executeOperation();
                    }
                    catch (Throwable throwable) {
                        if (this.isTopLevelOperation()) {
                            this.runPostActions();
                        }
                        throw throwable;
                    }
                    if (this.isTopLevelOperation()) {
                        this.runPostActions();
                    }
                }
                finally {
                    try {
                        deltaProcessor = manager.getDeltaProcessor();
                        int i = previousDeltaCount;
                        int size = deltaProcessor.javaModelDeltas.size();
                        while (i < size) {
                            deltaProcessor.updateJavaModel(deltaProcessor.javaModelDeltas.get(i));
                            ++i;
                        }
                        i = 0;
                        int length = this.resultElements.length;
                        while (i < length) {
                            IJavaElement element = this.resultElements[i];
                            Openable openable = (Openable)element.getOpenable();
                            if (!(openable instanceof CompilationUnit) || !((CompilationUnit)openable).isWorkingCopy()) {
                                ((JavaElement)openable.getParent()).close();
                            }
                            switch (element.getElementType()) {
                                case 3: 
                                case 4: {
                                    deltaProcessor.projectCachesToReset.add(element.getJavaProject());
                                }
                            }
                            ++i;
                        }
                        deltaProcessor.resetProjectCaches();
                        if (!(!this.isTopLevelOperation() || deltaProcessor.javaModelDeltas.size() <= previousDeltaCount && deltaProcessor.reconcileDeltas.isEmpty() || this.hasModifiedResource())) {
                            deltaProcessor.fire(null, 0);
                        }
                        break block27;
                    }
                    finally {
                        this.popOperation();
                    }
                }
                {
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
                this.progressMonitor = oldMonitor;
            }
        }
    }

    public void runOperation(IProgressMonitor monitor) throws JavaModelException {
        IJavaModelStatus status = this.verify();
        if (!status.isOK()) {
            throw new JavaModelException(status);
        }
        try {
            if (this.isReadOnly()) {
                this.run(monitor);
            } else {
                ResourcesPlugin.getWorkspace().run(this, this.getSchedulingRule(), 1, monitor);
            }
        }
        catch (CoreException ce) {
            Throwable e;
            if (ce instanceof JavaModelException) {
                throw (JavaModelException)ce;
            }
            if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(ce);
        }
    }

    protected void runPostActions() throws JavaModelException {
        while (this.actionsStart <= this.actionsEnd) {
            IPostAction postAction = this.actions[this.actionsStart++];
            if (POST_ACTION_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JavaModelOperation.runPostActions()] Running action " + postAction.getID());
            }
            postAction.run();
        }
    }

    protected static void setAttribute(Object key, Object attribute) {
        ArrayList operationStack = JavaModelOperation.getCurrentOperationStack();
        if (operationStack.size() == 0) {
            return;
        }
        JavaModelOperation topLevelOp = (JavaModelOperation)operationStack.get(0);
        if (topLevelOp.attributes == null) {
            topLevelOp.attributes = new HashMap();
        }
        topLevelOp.attributes.put(key, attribute);
    }

    @Override
    public void setCanceled(boolean b) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setCanceled(b);
        }
    }

    @Override
    public void setTaskName(String name) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setTaskName(name);
        }
    }

    @Override
    public void subTask(String name) {
        if (this.progressMonitor != null) {
            this.progressMonitor.subTask(name);
        }
    }

    protected IJavaModelStatus verify() {
        return this.commonVerify();
    }

    @Override
    public void worked(int work) {
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(work);
            this.checkCanceled();
        }
    }

    protected static interface IPostAction {
        public String getID();

        public void run() throws JavaModelException;
    }
}

