/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;

class VariableBinding
implements IVariableBinding {
    private org.eclipse.jdt.internal.compiler.lookup.VariableBinding binding;
    private ITypeBinding declaringClass;
    private String key;
    private String name;
    private BindingResolver resolver;
    private ITypeBinding type;

    VariableBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.VariableBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    @Override
    public ITypeBinding getDeclaringClass() {
        if (this.isField()) {
            if (this.declaringClass == null) {
                FieldBinding fieldBinding = (FieldBinding)this.binding;
                this.declaringClass = this.resolver.getTypeBinding(fieldBinding.declaringClass);
            }
            return this.declaringClass;
        }
        return null;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    @Override
    public int getKind() {
        return 3;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = new String(this.binding.name);
        }
        return this.name;
    }

    @Override
    public ITypeBinding getType() {
        if (this.type == null) {
            this.type = this.resolver.getTypeBinding(this.binding.type);
        }
        return this.type;
    }

    @Override
    public int getVariableId() {
        return this.binding.id;
    }

    @Override
    public boolean isParameter() {
        return (this.binding.tagBits & 0x400L) != 0L;
    }

    @Override
    public boolean isField() {
        return this.binding instanceof FieldBinding;
    }

    @Override
    public boolean isRecovered() {
        return false;
    }

    public String toString() {
        return this.binding.toString();
    }
}

