/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.IBranding;
import org.osgi.framework.Bundle;

public class ProductExtensionBranding
implements IBranding {
    String application = null;
    String name = null;
    String id = null;
    String description = null;
    HashMap<String, String> properties;
    Bundle definingBundle = null;

    public ProductExtensionBranding(String id, IConfigurationElement element) {
        this.id = id;
        if (element == null) {
            return;
        }
        this.application = element.getAttribute("application");
        this.name = element.getAttribute("name");
        this.description = element.getAttribute("description");
        this.loadProperties(element);
    }

    private void loadProperties(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren();
        this.properties = new HashMap(children.length);
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String key = child.getAttribute("name");
            String value = child.getAttribute("value");
            if (key != null && value != null) {
                this.properties.put(key, value);
            }
            ++n2;
        }
        this.definingBundle = Activator.getBundle(element.getContributor());
    }

    @Override
    public Bundle getDefiningBundle() {
        return this.definingBundle;
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Object getProduct() {
        return null;
    }
}

