/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.range.entries;

import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraftforge.srg2source.range.IRange;
import net.minecraftforge.srg2source.range.entries.ClassLiteral;
import net.minecraftforge.srg2source.range.entries.ClassReference;
import net.minecraftforge.srg2source.range.entries.FieldLiteral;
import net.minecraftforge.srg2source.range.entries.FieldReference;
import net.minecraftforge.srg2source.range.entries.LocalVariableReference;
import net.minecraftforge.srg2source.range.entries.MethodLiteral;
import net.minecraftforge.srg2source.range.entries.MethodReference;
import net.minecraftforge.srg2source.range.entries.PackageReference;
import net.minecraftforge.srg2source.range.entries.ParameterReference;
import net.minecraftforge.srg2source.util.Util;

public abstract class RangeEntry
implements IRange {
    private final Type type;
    private final int start;
    private final int length;
    private final String text;
    private String toString = null;

    public static RangeEntry read(int spec, String type, String data) {
        Type ret = null;
        try {
            ret = Type.valueOf(type.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown Structure Type: " + type.toUpperCase(Locale.ENGLISH));
        }
        return ret.read(spec, data);
    }

    protected RangeEntry(Type type, int start, int length, String text) {
        this.type = type;
        this.start = start;
        this.length = length;
        this.text = text;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        if (this.toString == null) {
            String extra = this.getExtraFields();
            this.toString = this.getClass().getSimpleName() + '[' + this.start + ':' + this.length + ", \"" + this.text + "\"" + (extra == null ? "" : ", " + extra) + "]";
        }
        return this.toString;
    }

    protected String getExtraFields() {
        return null;
    }

    public final void write(Consumer<String> out) {
        this.writeInternal(l -> out.accept(this.type.name().toLowerCase(Locale.ENGLISH) + ' ' + this.getStart() + ' ' + this.getLength() + ' ' + Util.quote(this.getText()) + (l == null ? "" : ' ' + l)));
    }

    protected abstract void writeInternal(Consumer<String> var1);

    @FunctionalInterface
    static interface Factory<T extends RangeEntry> {
        public T create(int var1, int var2, int var3, String var4, String var5);
    }

    public static enum Type {
        PACKAGE(PackageReference::read),
        CLASS(ClassReference::read),
        CLASS_LITERAL(ClassLiteral::read),
        FIELD(FieldReference::read),
        FIELD_LITERAL(FieldLiteral::read),
        METHOD(MethodReference::read),
        METHOD_LITERAL(MethodLiteral::read),
        PARAMETER(ParameterReference::read),
        LOCAL_VARIABLE(LocalVariableReference::read);

        private Factory<?> factory;

        private Type(Factory<?> factory) {
            this.factory = factory;
        }

        private RangeEntry read(int spec, String data) {
            List<String> pts = Util.unquote(data, 3);
            if (pts.size() < 3) {
                throw new IllegalArgumentException("Invalid line, must contain atleast 3 parts: " + data);
            }
            return this.factory.create(spec, Integer.parseInt(pts.get(0)), Integer.parseInt(pts.get(1)), pts.get(2), pts.size() == 4 ? pts.get(3) : "");
        }
    }
}

