/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.range;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.srg2source.range.IRange;
import net.minecraftforge.srg2source.range.RangeMap;
import net.minecraftforge.srg2source.range.entries.ClassLiteral;
import net.minecraftforge.srg2source.range.entries.ClassReference;
import net.minecraftforge.srg2source.range.entries.FieldLiteral;
import net.minecraftforge.srg2source.range.entries.FieldReference;
import net.minecraftforge.srg2source.range.entries.LocalVariableReference;
import net.minecraftforge.srg2source.range.entries.MetaEntry;
import net.minecraftforge.srg2source.range.entries.MethodLiteral;
import net.minecraftforge.srg2source.range.entries.MethodReference;
import net.minecraftforge.srg2source.range.entries.MixinAccessorMeta;
import net.minecraftforge.srg2source.range.entries.PackageReference;
import net.minecraftforge.srg2source.range.entries.ParameterReference;
import net.minecraftforge.srg2source.range.entries.RangeEntry;
import net.minecraftforge.srg2source.range.entries.StructuralEntry;
import net.minecraftforge.srg2source.util.io.ConfLogger;

public class RangeMapBuilder
extends ConfLogger<RangeMapBuilder> {
    private final List<RangeEntry> entries = new ArrayList<RangeEntry>();
    private final List<StructuralEntry> structures = new ArrayList<StructuralEntry>();
    private final List<MetaEntry> meta = new ArrayList<MetaEntry>();
    private final ConfLogger<?> logger;
    private final String filename;
    private final String hash;

    public RangeMapBuilder(ConfLogger<?> logger, String filename, String hash) {
        this.logger = logger;
        this.filename = filename;
        this.hash = hash;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean loadCache(RangeMap cache) {
        if (cache == null || !this.filename.equals(cache.getFilename()) || !this.hash.equals(cache.getHash())) {
            return false;
        }
        return false;
    }

    public RangeMap build() {
        Collections.sort(this.entries, (a, b) -> a.getStart() - b.getStart());
        Collections.sort(this.structures, (a, b) -> a.getStart() - b.getStart());
        this.checkOverlaps(this.entries);
        return new RangeMap(this.filename, this.hash, this.entries, this.structures, this.meta);
    }

    private void checkOverlaps(List<? extends IRange> lst) {
        if (lst.isEmpty()) {
            return;
        }
        IRange last = lst.get(0);
        for (int x = 1; x < lst.size(); ++x) {
            IRange next = lst.get(x);
            if (last.getStart() + last.getLength() >= next.getStart()) {
                this.logger.error("Overlap: " + last);
                this.logger.error("         " + next);
            }
            last = next;
        }
    }

    private void addStructure(StructuralEntry entry) {
        this.structures.add(entry);
    }

    public void addAnnotationDeclaration(int start, int length, String name) {
        this.addStructure(StructuralEntry.createAnnotation(start, length, name));
    }

    public void addClassDeclaration(int start, int length, String name) {
        this.addStructure(StructuralEntry.createClass(start, length, name));
    }

    public void addEnumDeclaration(int start, int length, String name) {
        this.addStructure(StructuralEntry.createEnum(start, length, name));
    }

    public void addMethodDeclaration(int start, int length, String name, String desc) {
        this.addStructure(StructuralEntry.createMethod(start, length, name, desc));
    }

    public void addInterfaceDeclaration(int start, int length, String name) {
        this.addStructure(StructuralEntry.createInterface(start, length, name));
    }

    private void addCode(RangeEntry entry) {
        this.entries.add(entry);
    }

    public void addPackageReference(int start, int length, String name) {
        this.addCode(PackageReference.create(start, length, name));
    }

    public void addClassReference(int start, int length, String text, String internal, boolean qualified) {
        this.addCode(ClassReference.create(start, length, text, internal, qualified));
    }

    public void addClassLiteral(int start, int length, String text, String internal) {
        this.addCode(ClassLiteral.create(start, length, text, internal));
    }

    public void addFieldReference(int start, int length, String text, String owner) {
        this.addCode(FieldReference.create(start, length, text, owner));
    }

    public void addFieldLiteral(int start, int length, String text, String owner, String name) {
        this.addCode(FieldLiteral.create(start, length, text, owner, name));
    }

    public void addMethodReference(int start, int length, String text, String owner, String name, String desc) {
        this.addCode(MethodReference.create(start, length, text, owner, name, desc));
    }

    public void addMethodLiteral(int start, int length, String text, String owner, String name, String desc) {
        this.addCode(MethodLiteral.create(start, length, text, owner, name, desc));
    }

    public void addParameterReference(int start, int length, String text, String owner, String name, String desc, int index) {
        this.addCode(ParameterReference.create(start, length, text, owner, name, desc, index));
    }

    public void addLocalVariableReference(int start, int length, String text, String owner, String name, String desc, int index, String type) {
        this.addCode(LocalVariableReference.create(start, length, text, owner, name, desc, index, type));
    }

    private void addMeta(MetaEntry entry) {
        this.meta.add(entry);
    }

    public void addMixinAccessor(String owner, String name, String desc, String targetOwner, String targetName, String targetDesc, String prefix) {
        this.addMeta(MixinAccessorMeta.create(owner, name, desc, targetOwner, targetName, targetDesc, prefix));
    }
}

