/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.extract;

import java.util.HashMap;
import java.util.List;
import net.minecraftforge.srg2source.extract.ExtractUtil;
import net.minecraftforge.srg2source.extract.MixinProcessor;
import net.minecraftforge.srg2source.extract.RangeExtractor;
import net.minecraftforge.srg2source.range.RangeMapBuilder;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleModifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;

public class SymbolReferenceWalker {
    private static final int JLS2 = 2;
    private static final int JLS3 = 3;
    private static final int JLS8 = 8;
    private final RangeMapBuilder builder;
    private final String className;
    private final String methodName;
    private final String methodDesc;
    private final RangeExtractor extractor;
    private final SymbolReferenceWalker parent;
    private final MixinProcessor mixins;
    private HashMap<String, ParamInfo> parameterInfo = new HashMap();
    private HashMap<String, LocalInfo> localVarInfo = new HashMap();
    private int anonCount = 0;
    private ASTVisitor visitor = new ASTVisitor(){

        @Override
        public boolean visit(AnnotationTypeDeclaration node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(AnnotationTypeMemberDeclaration node) {
            return true;
        }

        @Override
        public boolean visit(AnonymousClassDeclaration node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(ArrayAccess node) {
            return true;
        }

        @Override
        public boolean visit(ArrayCreation node) {
            return true;
        }

        @Override
        public boolean visit(ArrayInitializer node) {
            return true;
        }

        @Override
        public boolean visit(ArrayType node) {
            return true;
        }

        @Override
        public boolean visit(AssertStatement node) {
            return true;
        }

        @Override
        public boolean visit(Assignment node) {
            return true;
        }

        @Override
        public boolean visit(Block node) {
            return true;
        }

        @Override
        public boolean visit(BlockComment node) {
            return true;
        }

        @Override
        public boolean visit(BooleanLiteral node) {
            return true;
        }

        @Override
        public boolean visit(BreakStatement node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(CastExpression node) {
            return true;
        }

        @Override
        public boolean visit(CatchClause node) {
            return true;
        }

        @Override
        public boolean visit(CharacterLiteral node) {
            return true;
        }

        @Override
        public boolean visit(ClassInstanceCreation node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(ConditionalExpression node) {
            return true;
        }

        @Override
        public boolean visit(ConstructorInvocation node) {
            return true;
        }

        @Override
        public boolean visit(ContinueStatement node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(CompilationUnit node) {
            return true;
        }

        @Override
        public boolean visit(CreationReference node) {
            return true;
        }

        @Override
        public boolean visit(Dimension node) {
            return true;
        }

        @Override
        public boolean visit(DoStatement node) {
            return true;
        }

        @Override
        public boolean visit(EmptyStatement node) {
            return true;
        }

        @Override
        public boolean visit(EnhancedForStatement node) {
            return true;
        }

        @Override
        public boolean visit(EnumConstantDeclaration node) {
            return true;
        }

        @Override
        public boolean visit(EnumDeclaration node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(ExportsDirective node) {
            return true;
        }

        @Override
        public boolean visit(ExpressionMethodReference node) {
            return true;
        }

        @Override
        public boolean visit(ExpressionStatement node) {
            return true;
        }

        @Override
        public boolean visit(FieldAccess node) {
            return true;
        }

        @Override
        public boolean visit(FieldDeclaration node) {
            return true;
        }

        @Override
        public boolean visit(ForStatement node) {
            return true;
        }

        @Override
        public boolean visit(IfStatement node) {
            return true;
        }

        @Override
        public boolean visit(ImportDeclaration node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(InfixExpression node) {
            return true;
        }

        @Override
        public boolean visit(Initializer node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(InstanceofExpression node) {
            return true;
        }

        @Override
        public boolean visit(IntersectionType node) {
            return true;
        }

        @Override
        public boolean visit(Javadoc node) {
            return true;
        }

        @Override
        public boolean visit(LabeledStatement node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(LambdaExpression node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(LineComment node) {
            return true;
        }

        @Override
        public boolean visit(MarkerAnnotation node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(MethodDeclaration node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(MethodInvocation node) {
            return true;
        }

        @Override
        public boolean visit(MemberRef node) {
            return true;
        }

        @Override
        public boolean visit(MemberValuePair node) {
            return true;
        }

        @Override
        public boolean visit(MethodRef node) {
            return true;
        }

        @Override
        public boolean visit(MethodRefParameter node) {
            return true;
        }

        @Override
        public boolean visit(Modifier node) {
            return true;
        }

        @Override
        public boolean visit(ModuleDeclaration node) {
            return true;
        }

        @Override
        public boolean visit(ModuleModifier node) {
            return true;
        }

        @Override
        public boolean visit(NameQualifiedType node) {
            return true;
        }

        @Override
        public boolean visit(NormalAnnotation node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(NullLiteral node) {
            return true;
        }

        @Override
        public boolean visit(NumberLiteral node) {
            return true;
        }

        @Override
        public boolean visit(OpensDirective node) {
            return true;
        }

        @Override
        public boolean visit(PackageDeclaration node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(ParameterizedType node) {
            return true;
        }

        @Override
        public boolean visit(ParenthesizedExpression node) {
            return true;
        }

        @Override
        public boolean visit(PostfixExpression node) {
            return true;
        }

        @Override
        public boolean visit(PrefixExpression node) {
            return true;
        }

        @Override
        public boolean visit(PrimitiveType node) {
            return true;
        }

        @Override
        public boolean visit(ProvidesDirective node) {
            return true;
        }

        @Override
        public boolean visit(QualifiedName node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(QualifiedType node) {
            return true;
        }

        @Override
        public boolean visit(RequiresDirective node) {
            return true;
        }

        @Override
        public boolean visit(ReturnStatement node) {
            return true;
        }

        @Override
        public boolean visit(SimpleName node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(SimpleType node) {
            return true;
        }

        @Override
        public boolean visit(SingleMemberAnnotation node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(SingleVariableDeclaration node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(StringLiteral node) {
            return true;
        }

        @Override
        public boolean visit(SuperConstructorInvocation node) {
            return true;
        }

        @Override
        public boolean visit(SuperFieldAccess node) {
            return true;
        }

        @Override
        public boolean visit(SuperMethodInvocation node) {
            return true;
        }

        @Override
        public boolean visit(SuperMethodReference node) {
            return true;
        }

        @Override
        public boolean visit(SwitchCase node) {
            return true;
        }

        @Override
        public boolean visit(SwitchStatement node) {
            return true;
        }

        @Override
        public boolean visit(SynchronizedStatement node) {
            return true;
        }

        @Override
        public boolean visit(TagElement node) {
            return true;
        }

        @Override
        public boolean visit(TextElement node) {
            return true;
        }

        @Override
        public boolean visit(ThisExpression node) {
            return true;
        }

        @Override
        public boolean visit(ThrowStatement node) {
            return true;
        }

        @Override
        public boolean visit(TryStatement node) {
            return true;
        }

        @Override
        public boolean visit(TypeDeclaration node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(TypeDeclarationStatement node) {
            return true;
        }

        @Override
        public boolean visit(TypeLiteral node) {
            return true;
        }

        @Override
        public boolean visit(TypeMethodReference node) {
            return true;
        }

        @Override
        public boolean visit(TypeParameter node) {
            return true;
        }

        @Override
        public boolean visit(VariableDeclarationExpression node) {
            return true;
        }

        @Override
        public boolean visit(VariableDeclarationFragment node) {
            return SymbolReferenceWalker.this.process(node);
        }

        @Override
        public boolean visit(VariableDeclarationStatement node) {
            return true;
        }

        @Override
        public boolean visit(UnionType node) {
            return true;
        }

        @Override
        public boolean visit(UsesDirective node) {
            return true;
        }

        @Override
        public boolean visit(WhileStatement node) {
            return true;
        }

        @Override
        public boolean visit(WildcardType node) {
            return true;
        }
    };

    public SymbolReferenceWalker(RangeExtractor extractor, RangeMapBuilder builder, boolean enableMixins) {
        this.extractor = extractor;
        this.builder = builder;
        this.className = null;
        this.parent = null;
        this.mixins = enableMixins ? new MixinProcessor(this) : null;
        this.methodName = null;
        this.methodDesc = null;
    }

    private SymbolReferenceWalker(SymbolReferenceWalker parent, String className, String methodName, String methodDesc) {
        this.extractor = parent.extractor;
        this.builder = parent.builder;
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.parent = parent;
        this.mixins = parent.mixins;
    }

    public Exception safeWalk(ASTNode node) {
        if (node == null) {
            return null;
        }
        try {
            node.accept(this.getVisitor());
            return null;
        }
        catch (Exception e) {
            e.printStackTrace(this.extractor.getErrorLogger());
            return e;
        }
    }

    private void acceptChild(ASTNode child) {
        if (child == null) {
            return;
        }
        child.accept(this.getVisitor());
    }

    private void acceptChildren(List children) {
        if (children == null) {
            return;
        }
        for (ASTNode child : children) {
            this.acceptChild(child);
        }
    }

    private String getInternalName(ITypeBinding binding, ASTNode node) {
        return ExtractUtil.getInternalName(this.builder.getFilename(), binding, node);
    }

    private void trackLocalVariable(SimpleName name, IVariableBinding binding) {
        this.localVarInfo.put(name.resolveBinding().getKey(), new LocalInfo(this.className, this.methodName, this.methodDesc, binding.getVariableId(), ExtractUtil.getTypeSignature(binding.getType())));
    }

    private LocalInfo findLocal(String key) {
        LocalInfo ret = this.localVarInfo.get(key);
        if (ret != null) {
            return ret;
        }
        return this.parent == null ? null : this.parent.findLocal(key);
    }

    private void trackParameters(IMethodBinding mtd, List<VariableDeclaration> params, int synthetics) {
        int index = synthetics;
        for (int x = 0; x < params.size(); ++x) {
            String key = params.get(x).getName().resolveBinding().getKey();
            this.parameterInfo.put(key, new ParamInfo(this.className, this.methodName, this.methodDesc, index));
            ++index;
        }
    }

    private ParamInfo findParameter(String key) {
        ParamInfo ret = this.parameterInfo.get(key);
        if (ret != null) {
            return ret;
        }
        return this.parent == null ? null : this.parent.findParameter(key);
    }

    public void log(String message) {
        this.extractor.log("# " + message);
    }

    public void error(String message) {
        this.extractor.error("# " + message);
    }

    public void error(ASTNode node, String message) {
        String error = "ERROR: " + this.builder.getFilename() + " @ " + node.getStartPosition() + ": " + message;
        this.error(error);
        throw new IllegalStateException(error);
    }

    public RangeMapBuilder getBuilder() {
        return this.builder;
    }

    public RangeExtractor getExtractor() {
        return this.extractor;
    }

    private boolean process(AnnotationTypeDeclaration node) {
        this.builder.addAnnotationDeclaration(node.getStartPosition(), node.getLength(), node.getName().getIdentifier());
        return true;
    }

    private int getAnonIndex() {
        if (this.methodName != null) {
            return this.parent.getAnonIndex();
        }
        return ++this.anonCount;
    }

    private boolean process(AnonymousClassDeclaration node) {
        String name = this.className + "$" + this.getAnonIndex();
        SymbolReferenceWalker walker = new SymbolReferenceWalker(this, name, null, null);
        this.builder.addClassDeclaration(node.getStartPosition(), node.getLength(), name);
        walker.acceptChildren(node.bodyDeclarations());
        return false;
    }

    private boolean process(BreakStatement node) {
        return false;
    }

    private boolean process(ContinueStatement node) {
        return false;
    }

    private boolean process(EnumDeclaration node) {
        String name = this.getInternalName(node.resolveBinding(), node);
        this.builder.addEnumDeclaration(node.getStartPosition(), node.getLength(), name);
        SymbolReferenceWalker walker = new SymbolReferenceWalker(this, name, null, null);
        walker.acceptChild(node.getJavadoc());
        walker.acceptChildren(node.modifiers());
        walker.acceptChild(node.getName());
        walker.acceptChildren(node.superInterfaceTypes());
        walker.acceptChildren(node.enumConstants());
        walker.acceptChildren(node.bodyDeclarations());
        return false;
    }

    private boolean process(LabeledStatement node) {
        this.acceptChild(node.getBody());
        return false;
    }

    private boolean process(LambdaExpression node) {
        SymbolReferenceWalker walker;
        IMethodBinding mtd = node.resolveMethodBinding();
        String name = mtd.isConstructor() ? "<init>" : mtd.getName();
        name = "lambda[" + name + ']';
        String desc = ExtractUtil.getDescriptor(mtd);
        List params = node.parameters();
        if (!params.isEmpty()) {
            String mtdKey = mtd.getKey();
            int idx = mtdKey.indexOf(";.");
            if (idx == -1) {
                throw new IllegalArgumentException("Unknown Lambda key format: " + this.builder.getFilename() + " @ " + node.getStartPosition() + " key " + mtdKey);
            }
            mtdKey = mtdKey.substring(idx + 2);
            idx = mtdKey.indexOf(40);
            name = mtdKey.substring(0, idx);
            desc = mtdKey.substring(0, ((mtdKey = mtdKey.substring(idx)).charAt((idx = mtdKey.indexOf(41)) + 1) == 'L' ? mtdKey.indexOf(59, idx) : idx) + 1);
            walker = new SymbolReferenceWalker(this, this.className, name, desc);
            ITypeBinding[] args = mtd.getParameterTypes();
            walker.trackParameters(mtd, params, args.length - params.size());
        } else {
            walker = new SymbolReferenceWalker(this, this.className, name, desc);
        }
        this.builder.addMethodDeclaration(node.getStartPosition(), node.getLength(), name, desc);
        walker.acceptChildren(params);
        walker.acceptChild(node.getBody());
        return false;
    }

    private boolean process(MethodDeclaration node) {
        IMethodBinding mtd = node.resolveBinding();
        String name = mtd.isConstructor() ? "<init>" : mtd.getName();
        String desc = ExtractUtil.getDescriptor(mtd);
        this.builder.addMethodDeclaration(node.getStartPosition(), node.getLength(), name, desc);
        SymbolReferenceWalker walker = new SymbolReferenceWalker(this, this.className, name, desc);
        List params = node.parameters();
        if (!params.isEmpty()) {
            int synthetic = 0;
            if (mtd.isConstructor()) {
                ITypeBinding type = mtd.getDeclaringClass();
                if (type.isEnum()) {
                    synthetic = 2;
                } else if (type.isNested() && type.isClass() && (type.getModifiers() & 8) == 0) {
                    synthetic = 1;
                }
            }
            walker.trackParameters(mtd, params, synthetic);
        }
        walker.acceptChild(node.getJavadoc());
        if (node.getAST().apiLevel() == 2) {
            walker.acceptChild(node.getReturnType());
        } else {
            walker.acceptChildren(node.modifiers());
            walker.acceptChildren(node.typeParameters());
            walker.acceptChild(node.getReturnType2());
        }
        walker.acceptChild(node.getName());
        if (node.getAST().apiLevel() >= 8) {
            walker.acceptChild(node.getReceiverType());
            walker.acceptChild(node.getReceiverQualifier());
        }
        walker.acceptChildren(node.parameters());
        if (node.getAST().apiLevel() >= 8) {
            walker.acceptChildren(node.extraDimensions());
            walker.acceptChildren(node.thrownExceptionTypes());
        } else {
            walker.acceptChildren(node.thrownExceptions());
        }
        walker.acceptChild(node.getBody());
        return false;
    }

    private boolean process(Initializer node) {
        this.builder.addMethodDeclaration(node.getStartPosition(), node.getLength(), "<clinit>", "()V");
        SymbolReferenceWalker walker = new SymbolReferenceWalker(this, this.className, "<clinit>", "()V");
        walker.acceptChild(node.getJavadoc());
        if (node.getAST().apiLevel() >= 3) {
            walker.acceptChildren(node.modifiers());
        }
        walker.acceptChild(node.getBody());
        return false;
    }

    private boolean process(SimpleName node) {
        IBinding bind = node.resolveBinding();
        if (bind == null) {
            this.error(node, "Null IBinding: " + node.toString());
            return false;
        }
        switch (bind.getKind()) {
            case 2: {
                ITypeBinding type = (ITypeBinding)bind;
                if (type.isTypeVariable()) {
                    return false;
                }
                String clsName = this.getInternalName(type, node);
                this.builder.addClassReference(node.getStartPosition(), node.getLength(), node.toString(), clsName, false);
                return true;
            }
            case 3: {
                IVariableBinding var = (IVariableBinding)bind;
                if (var.isField()) {
                    if (var.getDeclaringClass() != null) {
                        String owner = this.getInternalName(var.getDeclaringClass(), node);
                        if (this.mixins != null) {
                            owner = this.mixins.getFieldOwner(owner, node.toString(), ExtractUtil.getTypeSignature(var.getType()));
                        }
                        this.builder.addFieldReference(node.getStartPosition(), node.getLength(), node.toString(), owner);
                    }
                } else if (var.isParameter()) {
                    ParamInfo info = this.findParameter(var.getKey());
                    if (info == null) {
                        this.error(node, "Illegal Argument: " + var.getKey());
                    } else {
                        this.builder.addParameterReference(node.getStartPosition(), node.getLength(), node.toString(), info.owner, info.name, info.desc, info.index);
                    }
                } else {
                    LocalInfo info = this.findLocal(var.getKey());
                    if (info == null) {
                        this.error(node, "Illegal Local Variable: " + var.getKey());
                    } else {
                        this.builder.addLocalVariableReference(node.getStartPosition(), node.getLength(), node.toString(), info.getOwner(), info.getMethodName(), info.getMethodDesc(), info.getIndex(), info.getType());
                    }
                }
                return true;
            }
            case 4: {
                IMethodBinding mtd = ExtractUtil.findRoot((IMethodBinding)bind);
                String owner = this.getInternalName(mtd.getDeclaringClass(), node);
                String name = mtd.isConstructor() ? "<init>" : mtd.getName();
                String desc = ExtractUtil.getDescriptor(mtd.getMethodDeclaration());
                if (this.mixins == null || !this.mixins.processMethodReference(node, mtd, owner, name, desc)) {
                    this.builder.addMethodReference(node.getStartPosition(), node.getLength(), node.toString(), owner, name, desc);
                }
                return true;
            }
        }
        this.error("Unknown IBinding Kind: " + bind.getKind() + " Text: " + node.toString());
        return true;
    }

    private boolean process(QualifiedName node) {
        IBinding bind = node.resolveBinding();
        if (bind == null) {
            this.error(node, "Null IBinding: " + node.toString());
            return false;
        }
        switch (bind.getKind()) {
            case 2: {
                ITypeBinding type = (ITypeBinding)bind;
                if (type.isTypeVariable()) {
                    this.error(node, "Qualified generic type variable?: " + node.toString());
                } else {
                    IBinding qualifier = node.getQualifier().resolveBinding();
                    Name name = node.getName();
                    if (qualifier.getKind() == 1) {
                        name = node;
                    } else {
                        this.acceptChild(node.getQualifier());
                    }
                    String clsName = this.getInternalName(type, node);
                    this.builder.addClassReference(name.getStartPosition(), name.getLength(), name.toString(), clsName, true);
                }
                return false;
            }
            case 3: {
                return true;
            }
            case 1: {
                this.error(node, "Unknown IBinding PACKAGE case: " + node.toString());
                return false;
            }
        }
        this.error(node, "Unknown IBinding Kind: " + bind.getKind() + " Text: " + node.toString());
        return false;
    }

    private boolean process(TypeDeclaration node) {
        String name = this.getInternalName((ITypeBinding)node.getName().resolveBinding(), node.getName());
        if (node.isInterface()) {
            this.builder.addInterfaceDeclaration(node.getStartPosition(), node.getLength(), name);
        } else {
            this.builder.addClassDeclaration(node.getStartPosition(), node.getLength(), name);
        }
        SymbolReferenceWalker walker = new SymbolReferenceWalker(this, name, null, null);
        if (node.getAST().apiLevel() == 2) {
            walker.acceptChild(node.getName());
            walker.acceptChild(node.getSuperclass());
            walker.acceptChildren(node.superInterfaceTypes());
            walker.acceptChildren(node.bodyDeclarations());
        }
        if (node.getAST().apiLevel() >= 3) {
            walker.acceptChildren(node.modifiers());
            walker.acceptChild(node.getName());
            walker.acceptChildren(node.typeParameters());
            walker.acceptChild(node.getSuperclassType());
            walker.acceptChildren(node.superInterfaceTypes());
            walker.acceptChildren(node.bodyDeclarations());
        }
        return false;
    }

    private boolean process(ImportDeclaration node) {
        return false;
    }

    private boolean process(PackageDeclaration node) {
        if (node.getAST().apiLevel() >= 3) {
            this.acceptChildren(node.annotations());
        }
        Name name = node.getName();
        this.builder.addPackageReference(name.getStartPosition(), name.getLength(), name.getFullyQualifiedName());
        return false;
    }

    private boolean process(ClassInstanceCreation node) {
        return true;
    }

    private boolean process(NormalAnnotation node) {
        if (this.mixins == null) {
            return true;
        }
        String name = this.getInternalName((ITypeBinding)node.getTypeName().resolveBinding(), node.getTypeName());
        return this.mixins.process(node, name);
    }

    private boolean process(SingleMemberAnnotation node) {
        if (this.mixins == null) {
            return true;
        }
        String name = this.getInternalName((ITypeBinding)node.getTypeName().resolveBinding(), node.getTypeName());
        return this.mixins.process(node, name);
    }

    private boolean process(SingleVariableDeclaration node) {
        this.trackLocalVariable(node.getName(), node.resolveBinding());
        return true;
    }

    private boolean process(VariableDeclarationFragment node) {
        this.trackLocalVariable(node.getName(), node.resolveBinding());
        return true;
    }

    private boolean process(MarkerAnnotation node) {
        if (this.mixins == null) {
            return true;
        }
        String name = this.getInternalName((ITypeBinding)node.getTypeName().resolveBinding(), node.getTypeName());
        return this.mixins.process(node, name);
    }

    public ASTVisitor getVisitor() {
        return this.visitor;
    }

    private static class LocalInfo
    extends ParamInfo {
        private final String type;

        private LocalInfo(String owner, String name, String desc, int index, String type) {
            super(owner, name, desc, index);
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    private static class ParamInfo {
        private final String owner;
        private final String name;
        private final String desc;
        private final int index;

        private ParamInfo(String owner, String name, String desc, int index) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
            this.index = index;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getMethodName() {
            return this.name;
        }

        public String getMethodDesc() {
            return this.desc;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

