/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.extract;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.srg2source.api.InputSupplier;
import net.minecraftforge.srg2source.api.SourceVersion;
import net.minecraftforge.srg2source.extract.SymbolReferenceWalker;
import net.minecraftforge.srg2source.range.RangeMap;
import net.minecraftforge.srg2source.range.RangeMapBuilder;
import net.minecraftforge.srg2source.util.Util;
import net.minecraftforge.srg2source.util.io.ConfLogger;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class RangeExtractor
extends ConfLogger<RangeExtractor> {
    private static RangeExtractor INSTANCE = null;
    private PrintWriter output;
    private String sourceVersion;
    private boolean enableBatchedASTs = true;
    private final Set<File> libs = new LinkedHashSet<File>();
    private String[] libArray = null;
    private InputSupplier input;
    private Map<String, RangeMap> file_cache = new HashMap<String, RangeMap>();
    private int cache_hits = 0;
    private boolean enableMixins = false;
    private boolean fatalMixins = false;

    public void setOutput(PrintWriter value) {
        this.output = value;
    }

    public void setSourceCompatibility(SourceVersion value) {
        this.sourceVersion = value.getSpec();
    }

    public void setBatchASTs(boolean value) {
        this.enableBatchedASTs = value;
    }

    public void enableMixins() {
        this.enableMixins = true;
    }

    public void fatalMixins() {
        this.fatalMixins = true;
    }

    public boolean areMixinsFatal() {
        return this.fatalMixins;
    }

    public void addLibrary(File value) {
        String fileName = value.getPath().toLowerCase(Locale.ENGLISH);
        if (!value.exists()) {
            this.error("Missing Library: " + value.getAbsolutePath());
        } else if (value.isDirectory()) {
            this.libArray = null;
            this.libs.add(value);
        } else if (fileName.endsWith(".jar") || fileName.endsWith(".jar")) {
            this.libArray = null;
            this.libs.add(value);
        } else {
            this.log("Unsupposrted library path: " + value.getAbsolutePath());
        }
    }

    public void setInput(InputSupplier supplier) {
        this.input = supplier;
    }

    public void loadCache(InputStream stream) throws IOException {
        this.file_cache = RangeMap.readAll(stream);
    }

    @Override
    public void log(String message) {
        super.log("# " + message);
    }

    public boolean run() {
        this.log("Symbol range map extraction starting");
        String[] files = (String[])this.input.gatherAll(".java").stream().map(f -> f.replaceAll("\\\\", "/")).sorted().toArray(String[]::new);
        this.log("Processing " + files.length + " files");
        if (files.length == 0) {
            this.cleanup();
            return true;
        }
        if (this.canBatchASTs()) {
            return this.batchGenerate(files);
        }
        return this.legacyGenerate(files);
    }

    private boolean legacyGenerate(String[] files) {
        try {
            for (String path : files) {
                Charset encoding = this.input.getEncoding(path);
                if (encoding == null) {
                    encoding = StandardCharsets.UTF_8;
                }
                try (InputStream stream = this.input.getInput(path);){
                    String data = new String(Util.readStream(stream), encoding);
                    String md5 = Util.md5(data, encoding);
                    RangeMapBuilder builder = new RangeMapBuilder(this, path, md5);
                    this.log("startProcessing \"" + path + "\" md5: " + md5);
                    RangeMap cache = this.file_cache.get(path);
                    if (builder.loadCache(cache)) {
                        this.log("Cache Hit!");
                        ++this.cache_hits;
                    } else {
                        ASTParser parser = this.createParser(this.input.getRoot(path));
                        parser.setUnitName(path);
                        parser.setSource(data.toCharArray());
                        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
                        if (cu.getProblems() != null && cu.getProblems().length > 0) {
                            Arrays.stream(cu.getProblems()).filter(p -> !p.isWarning()).forEach(p -> this.log("   Compile Error! " + p.toString()));
                        }
                        SymbolReferenceWalker walker = new SymbolReferenceWalker(this, builder, this.enableMixins);
                        walker.safeWalk(cu);
                    }
                    RangeMap range = builder.build();
                    if (this.output != null) {
                        range.write(this.output, true);
                    }
                    this.log("endProcessing \"" + path + "\"");
                    this.log("");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.getErrorLogger());
        }
        this.cleanup();
        return true;
    }

    private boolean batchGenerate(String[] files) {
        if (INSTANCE != null) {
            throw new IllegalStateException("Can not do batched processing while another is running!");
        }
        INSTANCE = this;
        ASTParser parser = this.createParser(null);
        FileASTRequestor requestor = new FileASTRequestor(){

            @Override
            public void acceptAST(String path, CompilationUnit cu) {
                path = path.replace(File.separatorChar, '/');
                Charset encoding = RangeExtractor.this.input.getEncoding(path);
                if (encoding == null) {
                    encoding = StandardCharsets.UTF_8;
                }
                try (InputStream stream = RangeExtractor.this.input.getInput(path);){
                    String data = new String(Util.readStream(stream), encoding);
                    String md5 = Util.md5(data, encoding);
                    RangeMapBuilder builder = new RangeMapBuilder(RangeExtractor.this, path, md5);
                    RangeExtractor.this.log("startProcessing \"" + path + "\" md5: " + md5);
                    RangeMap cache = (RangeMap)RangeExtractor.this.file_cache.get(path);
                    if (builder.loadCache(cache)) {
                        RangeExtractor.this.log("Cache Hit!");
                        RangeExtractor.this.cache_hits++;
                    } else {
                        if (cu.getProblems() != null && cu.getProblems().length > 0) {
                            Arrays.stream(cu.getProblems()).filter(p -> !p.isWarning()).forEach(p -> RangeExtractor.this.log("   Compile Error! " + p.toString()));
                        }
                        SymbolReferenceWalker walker = new SymbolReferenceWalker(RangeExtractor.this, builder, RangeExtractor.this.enableMixins);
                        walker.safeWalk(cu);
                    }
                    RangeMap range = builder.build();
                    if (RangeExtractor.this.output != null) {
                        range.write(RangeExtractor.this.output, true);
                    }
                    RangeExtractor.this.log("endProcessing \"" + path + "\"");
                    RangeExtractor.this.log("");
                }
                catch (IOException e) {
                    e.printStackTrace(RangeExtractor.this.getErrorLogger());
                }
            }
        };
        NullProgressMonitor monitor = new NullProgressMonitor();
        parser.createASTs(files, null, new String[0], requestor, monitor);
        this.cleanup();
        INSTANCE = null;
        return true;
    }

    private void cleanup() {
        try {
            this.input.close();
        }
        catch (IOException e) {
            e.printStackTrace(this.getErrorLogger());
        }
        if (this.output != null) {
            this.output.flush();
            this.output.close();
            this.output = null;
        }
    }

    private String[] getLibArray() {
        if (this.libArray == null) {
            this.libArray = (String[])this.libs.stream().map(File::getAbsolutePath).toArray(String[]::new);
        }
        return this.libArray;
    }

    public int getCacheHits() {
        return this.cache_hits;
    }

    public boolean canBatchASTs() {
        return RangeExtractor.hasBeenASMPatched() && this.enableBatchedASTs;
    }

    private ASTParser createParser(String srcRoot) {
        String[] stringArray;
        ASTParser parser = ASTParser.newParser(10);
        String[] stringArray2 = this.getLibArray();
        if (srcRoot == null) {
            stringArray = null;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = srcRoot;
        }
        parser.setEnvironment(stringArray2, stringArray, null, true);
        return this.setOptions(parser);
    }

    private ASTParser setOptions(ASTParser parser) {
        parser.setKind(8);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        Hashtable<String, String> options = JavaCore.getDefaultOptions();
        JavaCore.setComplianceOptions(this.sourceVersion, options);
        parser.setCompilerOptions(options);
        return parser;
    }

    /*
     * Exception decompiling
     */
    public static char[] getFileCharContent(String path, String encoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean hasBeenASMPatched() {
        return true;
    }
}

