/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.apply;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.srg2source.api.InputSupplier;
import net.minecraftforge.srg2source.api.OutputSupplier;
import net.minecraftforge.srg2source.apply.ClassMeta;
import net.minecraftforge.srg2source.apply.ExceptorClass;
import net.minecraftforge.srg2source.range.RangeMap;
import net.minecraftforge.srg2source.range.entries.ClassLiteral;
import net.minecraftforge.srg2source.range.entries.ClassReference;
import net.minecraftforge.srg2source.range.entries.FieldLiteral;
import net.minecraftforge.srg2source.range.entries.FieldReference;
import net.minecraftforge.srg2source.range.entries.LocalVariableReference;
import net.minecraftforge.srg2source.range.entries.MethodLiteral;
import net.minecraftforge.srg2source.range.entries.MethodReference;
import net.minecraftforge.srg2source.range.entries.ParameterReference;
import net.minecraftforge.srg2source.range.entries.RangeEntry;
import net.minecraftforge.srg2source.util.Util;
import net.minecraftforge.srg2source.util.io.ConfLogger;
import net.minecraftforge.srgutils.IMappingFile;

public class RangeApplier
extends ConfLogger<RangeApplier> {
    private static Pattern IMPORT = Pattern.compile("import\\s+((?<static>static)\\s+)?(?<class>[A-Za-z][A-Za-z0-9_\\.]*\\*?);.*");
    private List<IMappingFile> srgs = new ArrayList<IMappingFile>();
    private Map<String, String> clsSrc2Internal = new HashMap<String, String>();
    private Map<String, ExceptorClass> excs = Collections.emptyMap();
    private boolean keepImports = false;
    private InputSupplier input = null;
    private OutputSupplier output = null;
    private Map<String, RangeMap> range = new HashMap<String, RangeMap>();
    private ClassMeta meta = null;
    private Map<String, String> guessLambdas = null;
    private boolean guessLocals = false;
    private boolean sortImports = false;

    public void readSrg(Path srg) {
        try (InputStream in = Files.newInputStream(srg, new OpenOption[0]);){
            IMappingFile map = IMappingFile.load(in);
            this.srgs.add(map);
            map.getClasses().forEach(cls -> {
                this.clsSrc2Internal.put(cls.getOriginal().replace('/', '.').replace('$', '.'), cls.getOriginal());
                cls.getMethods().stream().flatMap(mtd -> mtd.getParameters().stream()).forEach(p -> this.guessLambdas.put(p.getOriginal(), p.getMapped()));
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read SRG: " + srg, e);
        }
    }

    public void readExc(Path value) {
        this.readExc(value, StandardCharsets.UTF_8);
    }

    public void readExc(Path value, Charset encoding) {
        try {
            this.excs = ExceptorClass.create(value, encoding, this.excs);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read EXC: " + value, e);
        }
    }

    public void setGuessLambdas(boolean value) {
        if (!value) {
            this.guessLambdas = null;
        } else {
            this.guessLambdas = new HashMap<String, String>();
            this.srgs.stream().flatMap(srg -> srg.getClasses().stream()).flatMap(cls -> cls.getMethods().stream()).flatMap(mtd -> mtd.getParameters().stream()).forEach(p -> this.guessLambdas.put(p.getOriginal(), p.getMapped()));
        }
    }

    public void setGuessLocals(boolean value) {
        this.guessLocals = value;
    }

    public void setSortImports(boolean value) {
        this.sortImports = value;
    }

    public void setInput(InputSupplier value) {
        this.input = value;
    }

    public void setOutput(OutputSupplier value) {
        this.output = value;
    }

    public void readRangeMap(File value) {
        try (InputStream in = Files.newInputStream(value.toPath(), new OpenOption[0]);){
            this.range.putAll(RangeMap.readAll(in));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid range map: " + value);
        }
    }

    public void readRangeMap(Path value) {
        try (InputStream in = Files.newInputStream(value, new OpenOption[0]);){
            this.range.putAll(RangeMap.readAll(in));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid range map: " + value);
        }
    }

    public void keepImports(boolean value) {
        this.keepImports = value;
    }

    public void run() throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("Missing Range Apply input");
        }
        if (this.output == null) {
            throw new IllegalStateException("Missing Range Apply output");
        }
        if (this.range == null) {
            throw new IllegalStateException("Missing Range Apply range");
        }
        this.meta = ClassMeta.create(this, this.range);
        ArrayList<String> paths = new ArrayList<String>(this.range.keySet());
        Collections.sort(paths);
        this.log("Processing " + paths.size() + " files");
        for (String filePath : paths) {
            this.log("Start Processing: " + filePath);
            InputStream stream = this.input.getInput(filePath);
            if (stream == null) {
                this.log("Data not found: " + filePath);
                continue;
            }
            Charset encoding = this.input.getEncoding(filePath);
            if (encoding == null) {
                encoding = StandardCharsets.UTF_8;
            }
            String data = new String(Util.readStream(stream), encoding);
            stream.close();
            List<String> out = this.processJavaSourceFile(filePath, data, this.range.get(filePath), this.meta);
            filePath = out.get(0);
            data = out.get(1);
            if (data != null) {
                OutputStream outStream = this.output.getOutput(filePath);
                if (outStream == null) {
                    throw new IllegalStateException("Could not get output stream form: " + filePath);
                }
                outStream.write(data.getBytes(encoding));
                outStream.close();
            }
            this.log("End  Processing: " + filePath);
            this.log("");
        }
        this.output.close();
    }

    private List<String> processJavaSourceFile(String fileName, String data, RangeMap rangeList, ClassMeta meta) throws IOException {
        StringBuilder outData = new StringBuilder();
        outData.append(data);
        TreeSet<String> importsToAdd = new TreeSet<String>();
        int shift = 0;
        String oldTopLevelClassFullName = Util.getTopLevelClassForFilename(fileName);
        int idx = oldTopLevelClassFullName.lastIndexOf(47);
        String oldTopLevelClassPackage = idx == -1 ? null : oldTopLevelClassFullName.substring(0, idx);
        String oldTopLevelClassName = idx == -1 ? oldTopLevelClassFullName : oldTopLevelClassFullName.substring(idx + 1);
        String newTopLevelClassFullName = this.mapClass(oldTopLevelClassFullName);
        idx = newTopLevelClassFullName.lastIndexOf(47);
        String newTopLevelClassPackage = idx == -1 ? null : newTopLevelClassFullName.substring(0, idx);
        String newTopLevelClassName = idx == -1 ? newTopLevelClassFullName : newTopLevelClassFullName.substring(idx + 1);
        for (RangeEntry info : rangeList.getEntries()) {
            int start = info.getStart();
            int end = start + info.getLength();
            String expectedOldText = info.getText();
            String oldName = outData.substring(start + shift, end + shift);
            if (!oldName.equals(expectedOldText)) {
                throw new RuntimeException("Rename sanity check failed: expected '" + expectedOldText + "' at [" + start + "," + end + "] (shifted " + shift + " [" + (start + shift) + "," + (end + shift) + "]) in " + fileName + ", but found '" + oldName + "'\nRegenerate symbol map on latest sources or start with fresh source and try again");
            }
            String newName = null;
            switch (info.getType()) {
                case PACKAGE: {
                    newName = newTopLevelClassPackage.replace('/', '.');
                    break;
                }
                case CLASS: {
                    RangeEntry ref = (ClassReference)info;
                    String fullname = this.mapClass(((ClassReference)ref).getClassName());
                    idx = fullname.lastIndexOf(47);
                    String packagename = idx == -1 ? null : fullname.substring(0, idx);
                    String simplename = fullname.substring(idx + 1);
                    idx = simplename.lastIndexOf(36);
                    if (idx != -1) {
                        if (oldName.indexOf(46) != -1) {
                            throw new IllegalStateException("Invalid Class mapping. Quialified inner class: Mapped: " + fullname + " " + info);
                        }
                        packagename = null;
                        simplename = simplename.substring(idx + 1);
                    }
                    if (((ClassReference)ref).isQualified() && oldName.indexOf(46) > 0) {
                        newName = fullname.replace('/', '.').replace('$', '.');
                        break;
                    }
                    newName = simplename;
                    if (((ClassReference)ref).isQualified()) break;
                    RangeApplier.trackImport(importsToAdd, newTopLevelClassFullName, newTopLevelClassFullName, fullname);
                    break;
                }
                case FIELD: {
                    RangeEntry ref = (FieldReference)info;
                    newName = this.mapField(((FieldReference)ref).getOwner(), ((FieldReference)ref).getName());
                    break;
                }
                case METHOD: {
                    RangeEntry ref = (MethodReference)info;
                    newName = this.mapMethod(((MethodReference)ref).getOwner(), ((MethodReference)ref).getName(), ((MethodReference)ref).getDescriptor());
                    break;
                }
                case PARAMETER: {
                    RangeEntry ref = (ParameterReference)info;
                    newName = this.mapParam(((ParameterReference)ref).getOwner(), ((ParameterReference)ref).getName(), ((ParameterReference)ref).getDescriptor(), ((ParameterReference)ref).getIndex(), oldName);
                    break;
                }
                case CLASS_LITERAL: {
                    RangeEntry ref = (ClassLiteral)info;
                    newName = '\"' + this.mapClass(((ClassLiteral)ref).getClassName()) + '\"';
                    if (ref.getText().indexOf(46) == -1) break;
                    newName = newName.replace('/', '.');
                    break;
                }
                case FIELD_LITERAL: {
                    RangeEntry ref = (FieldLiteral)info;
                    newName = '\"' + this.mapField(((FieldLiteral)ref).getOwner(), ((FieldLiteral)ref).getName()) + '\"';
                    break;
                }
                case METHOD_LITERAL: {
                    RangeEntry ref = (MethodLiteral)info;
                    newName = '\"' + this.mapMethod(((MethodLiteral)ref).getOwner(), ((MethodLiteral)ref).getName(), ((MethodLiteral)ref).getDescriptor()) + '\"';
                    break;
                }
                case LOCAL_VARIABLE: {
                    RangeEntry ref = (LocalVariableReference)info;
                    newName = this.mapLocal(((LocalVariableReference)ref).getOwner(), ((LocalVariableReference)ref).getName(), ((LocalVariableReference)ref).getDescriptor(), ((LocalVariableReference)ref).getIndex(), ((LocalVariableReference)ref).getVarType(), oldName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown RangeEntry type: " + info);
                }
            }
            if (oldName.equals(newName)) continue;
            this.log("Rename " + info + " Shift[" + shift + "] " + oldName + " -> " + newName);
            outData.replace(start + shift, end + shift, newName);
            shift += newName.length() - oldName.length();
        }
        String outString = this.updateImports(outData, importsToAdd);
        fileName = fileName.replace('\\', '/');
        String newFileName = newTopLevelClassFullName + ".java";
        if (newFileName.charAt(0) != '/' && fileName.charAt(0) == '/') {
            newFileName = '/' + newFileName;
        }
        if (!fileName.equals(newFileName)) {
            this.log("Rename file " + fileName + " -> " + newFileName);
            fileName = newFileName;
        }
        return Arrays.asList(fileName, outString);
    }

    private static void trackImport(Set<String> imports, String topLevel, String self, String reference) {
        String rpkg;
        if (reference.startsWith(topLevel)) {
            return;
        }
        int idx = topLevel.lastIndexOf(47);
        String tpkg = idx == -1 ? "" : topLevel.substring(0, idx);
        idx = reference.lastIndexOf(47);
        String string = rpkg = idx == -1 ? "" : reference.substring(0, idx);
        if (tpkg.equals(rpkg)) {
            return;
        }
        imports.add(reference.replace('/', '.').replace('$', '.'));
    }

    private String updateImports(StringBuilder data, Set<String> newImports) {
        String newline;
        int lastIndex = 0;
        int nextIndex = this.getNextIndex(data.indexOf("\n"), data.length(), lastIndex);
        boolean addedNewImports = false;
        boolean sawImports = false;
        int packageLine = -1;
        String string = newline = data.indexOf("\r\n") != -1 ? "\r\n" : "\n";
        while (nextIndex > -1) {
            String line = data.substring(lastIndex, nextIndex);
            if (line.endsWith("\r")) {
                line = line.substring(0, line.length() - 1);
            }
            int comment = line.indexOf("//");
            while ((comment == -1 ? line : line.substring(0, comment)).trim().isEmpty() && (nextIndex = this.getNextIndex(data.indexOf("\n", lastIndex += line.length() == 0 ? 1 : line.length()), data.length(), lastIndex)) != -1) {
                line = data.substring(lastIndex, nextIndex);
                if (line.endsWith("\r")) {
                    line = line.substring(0, line.length() - 1);
                }
                comment = line.indexOf("//");
            }
            if (nextIndex == -1) break;
            if (line.startsWith("package ")) {
                packageLine = nextIndex + 1;
            } else if (line.startsWith("import")) {
                sawImports = true;
                Matcher match = IMPORT.matcher(line);
                if (!match.matches()) {
                    this.error("Error: Invalid import line: " + line);
                    lastIndex = nextIndex + 1;
                    nextIndex = this.getNextIndex(data.indexOf("\n", nextIndex + 1), data.length(), nextIndex + 1);
                    continue;
                }
                boolean isStatic = match.group("static") != null;
                String old = match.group("class");
                int cStart = match.start("class");
                int cEnd = match.end("class");
                boolean wildMatch = false;
                if (isStatic) {
                    int idx = old.lastIndexOf(46);
                    cEnd -= old.length() - idx;
                    String name = old.substring(idx + 1);
                    old = old.substring(0, idx);
                    if (!"*".equals(name)) {
                        this.error("Warning: Static Method/Field Imports not supported: " + line);
                        lastIndex = nextIndex;
                        nextIndex = this.getNextIndex(data.indexOf("\n", nextIndex + 1), data.length(), nextIndex + 1);
                    }
                } else if (old.endsWith(".*")) {
                    HashSet<String> remove = new HashSet<String>();
                    String starter = old.substring(0, old.length() - 1);
                    for (String imp2 : newImports) {
                        String impStart = imp2.substring(0, imp2.lastIndexOf(46) + 1);
                        if (!impStart.equals(starter)) continue;
                        remove.add(imp2);
                        wildMatch = true;
                    }
                    newImports.removeAll(remove);
                    old = old.substring(0, old.length() - 2);
                    cEnd -= 2;
                }
                String newClass = this.mapClass(this.clsSrc2Internal.getOrDefault(old, old)).replace('/', '.').replace('$', '.');
                if (!(wildMatch || newImports.remove(newClass) || isStatic)) {
                    if (this.keepImports) {
                        lastIndex = nextIndex + 1;
                    } else {
                        data.delete(lastIndex, nextIndex + 1);
                        if (data.substring(lastIndex > 3 ? lastIndex - 3 : 0, lastIndex).endsWith('\n' + newline) && data.substring(lastIndex, lastIndex + newline.length()).equals(newline)) {
                            data.delete(lastIndex - newline.length(), lastIndex);
                            lastIndex -= newline.length();
                        }
                    }
                    nextIndex = this.getNextIndex(data.indexOf("\n", lastIndex), data.length(), lastIndex);
                    continue;
                }
                if (!old.equals(newClass)) {
                    data.replace(lastIndex + cStart, lastIndex + cEnd, newClass);
                    nextIndex -= old.length() - newClass.length();
                }
            } else if (sawImports && !addedNewImports) {
                this.filterImports(newImports);
                if (newImports.size() > 0) {
                    CharSequence sub = data.subSequence(lastIndex, data.length());
                    data.setLength(lastIndex);
                    newImports.stream().sorted().forEach(imp -> data.append("import ").append((String)imp).append(";\n"));
                    if (newImports.size() > 0) {
                        data.append(newline);
                    }
                    int change = data.length() - lastIndex;
                    lastIndex = data.length();
                    nextIndex += change;
                    data.append(sub);
                }
                addedNewImports = true;
                break;
            }
            lastIndex = nextIndex + 1;
            nextIndex = this.getNextIndex(data.indexOf("\n", lastIndex), data.length(), lastIndex);
        }
        if (!addedNewImports) {
            this.filterImports(newImports);
            if (newImports.size() > 0) {
                int index = packageLine == -1 ? 0 : packageLine;
                CharSequence sub = data.subSequence(index, data.length());
                data.setLength(index);
                newImports.stream().sorted().forEach(imp -> data.append(newline).append("import ").append((String)imp).append(";"));
                if (newImports.size() > 0) {
                    data.append('\n');
                }
                data.append(sub);
            }
        }
        if (this.sortImports && (!newImports.isEmpty() || sawImports)) {
            int endIndex;
            int startIndex = data.indexOf("import ");
            nextIndex = endIndex = data.indexOf("\n", startIndex);
            if (startIndex != -1) {
                String line = data.substring(startIndex, endIndex);
                while ((line = data.substring(endIndex + 1, nextIndex = data.indexOf("\n", endIndex + 1))).startsWith("import ") || line.replaceAll("\r?\n", "").trim().isEmpty()) {
                    endIndex = nextIndex;
                }
                while (data.charAt(endIndex - 1) == '\n' || data.charAt(endIndex - 1) == '\r') {
                    --endIndex;
                }
                String importData = data.substring(startIndex, endIndex);
                String imports = Stream.of(importData.split("\r?\n")).filter(i -> !i.trim().isEmpty()).map(i -> {
                    i = i.substring(7, i.length() - 1);
                    int idx = i.lastIndexOf(46);
                    return new String[]{i.substring(0, idx), i.substring(idx + 1)};
                }).sorted((o1, o2) -> o1[0].equals(o2[0]) ? o1[1].compareTo(o2[1]) : o1[0].compareTo(o2[0])).map(i -> "import " + i[0] + '.' + i[1] + ';').collect(Collectors.joining(newline));
                data.replace(startIndex, endIndex, imports);
            }
        }
        return data.toString();
    }

    private int getNextIndex(int newLine, int dataLength, int oldIndex) {
        if (newLine == -1 && dataLength > oldIndex) {
            return dataLength;
        }
        return newLine;
    }

    private void filterImports(Set<String> newImports) {
        Iterator<String> itr = newImports.iterator();
        while (itr.hasNext()) {
            if (!itr.next().startsWith("java.lang.")) continue;
            itr.remove();
        }
        if (newImports.size() > 0) {
            this.log("Adding " + newImports.size() + " imports");
            for (String imp : newImports) {
                this.log("        " + imp);
            }
        }
    }

    String mapClass(String name) {
        for (IMappingFile srg : this.srgs) {
            IMappingFile.IClass cls = srg.getClass(name);
            if (cls == null) continue;
            return cls.getMapped();
        }
        return name;
    }

    String mapField(String owner, String name) {
        for (IMappingFile srg : this.srgs) {
            String newName;
            IMappingFile.IClass cls = srg.getClass(owner);
            if (cls == null || (newName = cls.remapField(name)) == name) continue;
            return newName;
        }
        return name;
    }

    String mapMethod(String owner, String name, String desc) {
        if ("<init>".equals(name)) {
            String newName = this.mapClass(owner);
            int idx = newName.lastIndexOf(36);
            idx = idx != -1 ? idx : newName.lastIndexOf(47);
            return idx == -1 ? newName : newName.substring(idx + 1);
        }
        for (IMappingFile srg : this.srgs) {
            String newName;
            IMappingFile.IClass cls = srg.getClass(owner);
            if (cls == null || (newName = cls.remapMethod(name, desc)) == name) continue;
            return newName;
        }
        return this.meta == null ? name : this.meta.mapMethod(owner, name, desc);
    }

    private String mapParam(String owner, String name, String desc, int index, String old) {
        String ret;
        ExceptorClass exc = this.excs.get(owner);
        String string = ret = exc == null ? null : exc.mapParam(name, desc, index, old);
        if (ret == null) {
            for (IMappingFile srg : this.srgs) {
                String mapped;
                IMappingFile.IMethod mtd;
                IMappingFile.IClass cls = srg.getClass(owner);
                if (cls == null || (mtd = cls.getMethod(name, desc)) == null || (mapped = mtd.remapParameter(index, old)) == old) continue;
                ret = mapped;
                break;
            }
        }
        if (ret == null && this.guessLambdas != null && name.startsWith("lambda$")) {
            ret = this.guessLambdas.get(old);
        }
        return ret == null ? old : ret;
    }

    private String mapLocal(String owner, String name, String desc, int index, String type, String old) {
        if (!this.guessLocals || type.indexOf(59) == -1) {
            return old;
        }
        String prefix = "";
        if (type.charAt(0) == '[') {
            prefix = "a";
            type = type.substring(type.indexOf(76) + 1, type.length() - 1);
        } else {
            type = type.substring(1, type.length() - 1);
        }
        int idx = type.lastIndexOf(47);
        String expected = prefix + (idx == -1 ? type : type.substring(idx + 1)).toLowerCase(Locale.ENGLISH);
        String newClass = this.mapClass(type);
        if (newClass.equals(type)) {
            return old;
        }
        idx = newClass.lastIndexOf(47);
        if (idx != -1) {
            newClass = newClass.substring(idx + 1);
        }
        if (!old.startsWith(expected)) {
            idx = expected.lastIndexOf(36);
            int nidx = newClass.lastIndexOf(36);
            if (idx == -1 || nidx == -1) {
                return old;
            }
            String inner = prefix + expected.substring(idx + 1);
            String outer = expected.substring(0, idx);
            if (old.startsWith(inner)) {
                newClass = newClass.substring(nidx + 1);
                expected = inner;
            } else if (old.startsWith(outer)) {
                newClass = newClass.substring(0, nidx);
                expected = outer;
            } else {
                return old;
            }
        }
        return prefix + newClass.toLowerCase(Locale.ENGLISH) + old.substring(expected.length());
    }
}

