/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraftforge.srg2source.api.RangeApplierBuilder;

public class RangeApplyMain {
    private static final ValueConverter<Path> PATH_CONVERTER = new PathConverter(new PathProperties[0]);

    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec helpArg = parser.acceptsAll(RangeApplyMain.a("h", "help")).forHelp();
        ArgumentAcceptingOptionSpec<Path> inputArg = parser.acceptsAll(RangeApplyMain.a("in", "input", "srcRoot")).withRequiredArg().withValuesConvertedBy(PATH_CONVERTER).required();
        ArgumentAcceptingOptionSpec<Path> outArg = parser.acceptsAll(RangeApplyMain.a("out", "output", "outDir")).withRequiredArg().withValuesConvertedBy(PATH_CONVERTER).required();
        ArgumentAcceptingOptionSpec<Path> excArg = parser.acceptsAll(RangeApplyMain.a("exc", "excFiles")).withRequiredArg().withValuesConvertedBy(PATH_CONVERTER);
        ArgumentAcceptingOptionSpec<Path> mappingArg = parser.acceptsAll(RangeApplyMain.a("map", "srg", "srgFiles")).withRequiredArg().withValuesConvertedBy(PATH_CONVERTER).required();
        ArgumentAcceptingOptionSpec<File> rangeArg = parser.acceptsAll(RangeApplyMain.a("rm", "range", "srcRangeMap")).withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<Boolean> importArg = parser.acceptsAll(RangeApplyMain.a("keepImports")).withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]);
        OptionSpecBuilder sortImportArg = parser.acceptsAll(RangeApplyMain.a("sortImports"));
        OptionSpecBuilder guessLambdasArg = parser.acceptsAll(RangeApplyMain.a("guessLambdas"));
        OptionSpecBuilder guessLocalsArg = parser.acceptsAll(RangeApplyMain.a("guessLocals"));
        try {
            OptionSet options = parser.parse(args);
            if (options.has(helpArg)) {
                parser.printHelpOn(System.out);
                return;
            }
            File range = options.valueOf(rangeArg);
            Path output = options.valueOf(outArg);
            boolean keepImports = options.has(importArg) && options.valueOf(importArg) != false;
            System.out.println("Range:   " + range);
            System.out.println("Output:  " + output);
            System.out.println("Imports: " + keepImports);
            System.out.println("Sort:    " + options.has(sortImportArg));
            System.out.println("Lambdas: " + options.has(guessLambdasArg));
            System.out.println("Locals:  " + options.has(guessLocalsArg));
            RangeApplierBuilder builder = new RangeApplierBuilder().range(range).output(output).guessLambdas(options.has(guessLambdasArg)).guessLocals(options.has(guessLocalsArg)).sortImports(options.has(sortImportArg));
            if (options.has(mappingArg)) {
                options.valuesOf(mappingArg).forEach(v -> {
                    System.out.println("Map:     " + v);
                    builder.srg((Path)v);
                });
            }
            options.valuesOf(inputArg).forEach(v -> {
                System.out.println("Input:   " + v);
                builder.input((Path)v);
            });
            if (options.has(excArg)) {
                options.valuesOf(excArg).forEach(v -> {
                    System.out.println("Exc:     " + v);
                    builder.exc((Path)v);
                });
            }
            if (keepImports) {
                builder.keepImports();
            } else {
                builder.trimImports();
            }
            builder.build().run();
        }
        catch (OptionException e) {
            parser.printHelpOn(System.out);
            e.printStackTrace();
        }
    }

    private static List<String> a(String ... values) {
        return Arrays.asList(values);
    }
}

