/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.hooks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.eclipse.osgi.internal.loader.classpath.FragmentClasspath;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.ContentProvider;
import org.eclipse.osgi.storage.bundlefile.BundleFile;

public class DevClassLoadingHook
extends ClassLoaderHook
implements KeyedElement {
    public static final String KEY = DevClassLoadingHook.class.getName();
    public static final int HASHCODE = KEY.hashCode();
    private final EquinoxConfiguration configuration;

    public DevClassLoadingHook(EquinoxConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean addClassPathEntry(ArrayList<ClasspathEntry> cpEntries, String cp, ClasspathManager hostmanager, BundleInfo.Generation sourceGeneration) {
        String[] devClassPaths;
        if (sourceGeneration.getContentType() == ContentProvider.Type.CONNECT) {
            return false;
        }
        String[] stringArray = devClassPaths = !this.configuration.inDevelopmentMode() ? null : this.configuration.getDevClassPath(sourceGeneration.getRevision().getSymbolicName());
        if (devClassPaths == null || devClassPaths.length == 0) {
            return false;
        }
        if (cpEntries.size() > 0 && cpEntries.get(0).getUserObject(KEY) != null) {
            return false;
        }
        List<ModuleCapability> moduleDatas = sourceGeneration.getRevision().getModuleCapabilities("equinox.module.data");
        List<String> specifiedCP = Optional.ofNullable(moduleDatas.isEmpty() ? null : (List)moduleDatas.get(0).getAttributes().get("classpath")).orElse(Collections.singletonList("."));
        boolean result = false;
        String[] stringArray2 = devClassPaths;
        int n = devClassPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String devClassPath = stringArray2[n2];
            if (!specifiedCP.contains(devClassPath)) {
                if (hostmanager.addClassPathEntry(cpEntries, devClassPath, hostmanager, sourceGeneration)) {
                    result = true;
                } else {
                    ClasspathEntry entry;
                    String devCP = devClassPath;
                    boolean fromFragment = devCP.endsWith("@fragment@");
                    if (!fromFragment && devCP.indexOf("..") >= 0) {
                        File base = sourceGeneration.getBundleFile().getBaseFile();
                        if (base != null && base.isDirectory() && (entry = hostmanager.getExternalClassPath(new File(base, devCP).getAbsolutePath(), sourceGeneration)) != null) {
                            cpEntries.add(entry);
                            result = true;
                        }
                    } else {
                        BundleInfo.Generation fragSource;
                        if (fromFragment) {
                            devCP = devCP.substring(0, devCP.length() - "@fragment@".length());
                        }
                        if ((fragSource = this.findFragmentSource(sourceGeneration, devCP, hostmanager, fromFragment)) != null && (entry = hostmanager.getExternalClassPath(devCP, fragSource)) != null) {
                            cpEntries.add(entry);
                            result = true;
                        }
                    }
                }
            }
            ++n2;
        }
        if (result && cpEntries.size() > 0) {
            cpEntries.get(0).addUserObject(this);
        }
        return result;
    }

    private BundleInfo.Generation findFragmentSource(BundleInfo.Generation hostGeneration, String cp, ClasspathManager manager, boolean fromFragment) {
        FragmentClasspath[] fragCPs;
        if (hostGeneration != manager.getGeneration()) {
            return hostGeneration;
        }
        File file = new File(cp);
        if (!file.isAbsolute()) {
            return hostGeneration;
        }
        FragmentClasspath[] fragmentClasspathArray = fragCPs = manager.getFragmentClasspaths();
        int n = fragCPs.length;
        int n2 = 0;
        while (n2 < n) {
            FragmentClasspath fragCP = fragmentClasspathArray[n2];
            BundleFile fragBase = fragCP.getGeneration().getBundleFile();
            File fragFile = fragBase.getBaseFile();
            if (fragFile != null && file.getPath().startsWith(fragFile.getPath())) {
                return fragCP.getGeneration();
            }
            ++n2;
        }
        return fromFragment ? null : hostGeneration;
    }

    @Override
    public Object getKey() {
        return KEY;
    }

    @Override
    public boolean isProcessClassRecursionSupported() {
        return true;
    }
}

