/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ICodeAttribute;
import org.eclipse.jdt.core.util.IComponentInfo;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.IntersectionCastTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.core.Annotation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.MemberValuePair;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.util.Messages;

public class Util {
    private static char[][] JAVA_LIKE_EXTENSIONS;
    private static final char[] BOOLEAN;
    private static final char[] BYTE;
    private static final char[] CHAR;
    private static final char[] DOUBLE;
    private static final char[] FLOAT;
    private static final char[] INT;
    private static final char[] LONG;
    private static final char[] SHORT;
    private static final char[] VOID;
    private static final char[] INIT;
    private static List fgRepeatedMessages;

    static {
        BOOLEAN = "boolean".toCharArray();
        BYTE = "byte".toCharArray();
        CHAR = "char".toCharArray();
        DOUBLE = "double".toCharArray();
        FLOAT = "float".toCharArray();
        INT = "int".toCharArray();
        LONG = "long".toCharArray();
        SHORT = "short".toCharArray();
        VOID = "void".toCharArray();
        INIT = "<init>".toCharArray();
        fgRepeatedMessages = new ArrayList(5);
    }

    public static final String[] arrayConcat(String[] first, String second) {
        if (second == null) {
            return first;
        }
        if (first == null) {
            return new String[]{second};
        }
        int length = first.length;
        if (first.length == 0) {
            return new String[]{second};
        }
        String[] result = new String[length + 1];
        System.arraycopy(first, 0, result, 0, length);
        result[length] = second;
        return result;
    }

    public static int combineHashCodes(int hashCode1, int hashCode2) {
        return hashCode1 * 17 + hashCode2;
    }

    public static int compare(char[] str1, char[] str2) {
        int len1 = str1.length;
        int len2 = str2.length;
        int n = Math.min(len1, len2);
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = str1[i];
            if (c1 == (c2 = str2[i++])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static char[] concatCompoundNameToCharArray(String[] compoundName) {
        if (compoundName == null) {
            return null;
        }
        int length = compoundName.length;
        if (length == 0) {
            return new char[0];
        }
        int size = 0;
        int i = 0;
        while (i < length) {
            size += compoundName[i].length();
            ++i;
        }
        char[] compoundChars = new char[size + length - 1];
        int pos = 0;
        int i2 = 0;
        while (i2 < length) {
            String name = compoundName[i2];
            if (i2 > 0) {
                compoundChars[pos++] = 46;
            }
            int nameLength = name.length();
            name.getChars(0, nameLength, compoundChars, pos);
            pos += nameLength;
            ++i2;
        }
        return compoundChars;
    }

    public static final String concatWith(String[] array, char separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = array.length;
        while (i < length) {
            buffer.append(array[i]);
            if (i < length - 1) {
                buffer.append(separator);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static final String concatWith(String[] array, String name, char separator) {
        if (array == null || array.length == 0) {
            return name;
        }
        if (name == null || name.length() == 0) {
            return Util.concatWith(array, separator);
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = array.length;
        while (i < length) {
            buffer.append(array[i]);
            buffer.append(separator);
            ++i;
        }
        buffer.append(name);
        return buffer.toString();
    }

    public static String defaultJavaExtension() {
        return ".java";
    }

    public static boolean equalArrays(Object[] a, Object[] b, int len) {
        if (a == b) {
            return true;
        }
        if (a.length < len || b.length < len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] == null ? b[i] != null : !a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArraysOrNull(Object[] a, Object[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        int i = len - 1;
        while (i >= 0) {
            if (a[i] == null ? b[i] != null : !a[i].equals(b[i])) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean equalOrNull(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static IFile findFirstClassFile(IFolder folder) {
        try {
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource member = members[i];
                if (member.getType() == 2) {
                    return Util.findFirstClassFile((IFolder)member);
                }
                if (org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(member.getName())) {
                    return (IFile)member;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static String findLineSeparator(char[] text) {
        int length = text.length;
        if (length > 0) {
            int nextChar = text[0];
            int i = 0;
            while (i < length) {
                int currentChar = nextChar;
                nextChar = i < length - 1 ? text[i + 1] : 32;
                switch (currentChar) {
                    case 10: {
                        return "\n";
                    }
                    case 13: {
                        return nextChar == 10 ? "\r\n" : "\r";
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static IClassFileAttribute getAttribute(IClassFileReader classFileReader, char[] attributeName) {
        IClassFileAttribute[] attributes = classFileReader.getAttributes();
        int i = 0;
        int max = attributes.length;
        while (i < max) {
            if (CharOperation.equals(attributes[i].getAttributeName(), attributeName)) {
                return attributes[i];
            }
            ++i;
        }
        return null;
    }

    public static IClassFileAttribute getAttribute(ICodeAttribute codeAttribute, char[] attributeName) {
        IClassFileAttribute[] attributes = codeAttribute.getAttributes();
        int i = 0;
        int max = attributes.length;
        while (i < max) {
            if (CharOperation.equals(attributes[i].getAttributeName(), attributeName)) {
                return attributes[i];
            }
            ++i;
        }
        return null;
    }

    public static IClassFileAttribute getAttribute(IFieldInfo fieldInfo, char[] attributeName) {
        IClassFileAttribute[] attributes = fieldInfo.getAttributes();
        int i = 0;
        int max = attributes.length;
        while (i < max) {
            if (CharOperation.equals(attributes[i].getAttributeName(), attributeName)) {
                return attributes[i];
            }
            ++i;
        }
        return null;
    }

    public static IClassFileAttribute getAttribute(IComponentInfo componentInfo, char[] attributeName) {
        IClassFileAttribute[] attributes = componentInfo.getAttributes();
        int i = 0;
        int max = attributes.length;
        while (i < max) {
            if (CharOperation.equals(attributes[i].getAttributeName(), attributeName)) {
                return attributes[i];
            }
            ++i;
        }
        return null;
    }

    public static IClassFileAttribute getAttribute(IMethodInfo methodInfo, char[] attributeName) {
        IClassFileAttribute[] attributes = methodInfo.getAttributes();
        int i = 0;
        int max = attributes.length;
        while (i < max) {
            if (CharOperation.equals(attributes[i].getAttributeName(), attributeName)) {
                return attributes[i];
            }
            ++i;
        }
        return null;
    }

    public static char[][] getJavaLikeExtensions() {
        if (JAVA_LIKE_EXTENSIONS == null) {
            IContentType javaContentType = Platform.getContentTypeManager().getContentType("org.eclipse.jdt.core.javaSource");
            HashSet<String> fileExtensions = new HashSet<String>();
            IContentType[] contentTypes = Platform.getContentTypeManager().getAllContentTypes();
            int i = 0;
            int length = contentTypes.length;
            while (i < length) {
                if (contentTypes[i].isKindOf(javaContentType)) {
                    String[] fileExtension = contentTypes[i].getFileSpecs(8);
                    int j = 0;
                    int length2 = fileExtension.length;
                    while (j < length2) {
                        fileExtensions.add(fileExtension[j]);
                        ++j;
                    }
                }
                ++i;
            }
            int length2 = fileExtensions.size();
            char[][] extensions = new char[length2][];
            extensions[0] = "java".toCharArray();
            int index = 1;
            for (String fileExtension : fileExtensions) {
                if ("java".equals(fileExtension)) continue;
                extensions[index++] = fileExtension.toCharArray();
            }
            JAVA_LIKE_EXTENSIONS = extensions;
        }
        return JAVA_LIKE_EXTENSIONS;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getJdkLevel(Object targetLibrary) {
        try {
            ClassFileReader reader;
            block16: {
                reader = null;
                if (targetLibrary instanceof IFolder) {
                    IFile classFile = Util.findFirstClassFile((IFolder)targetLibrary);
                    if (classFile != null) {
                        reader = Util.newClassFileReader(classFile);
                    }
                } else {
                    ZipFile jar;
                    block15: {
                        IPath path;
                        jar = null;
                        try {
                            File f;
                            path = null;
                            if (targetLibrary instanceof IResource) {
                                path = ((IResource)targetLibrary).getFullPath();
                            } else if (targetLibrary instanceof File && !(f = (File)targetLibrary).isDirectory()) {
                                path = new Path(((File)targetLibrary).getPath());
                            }
                            if (path == null) break block15;
                            if (JavaModelManager.isJrt(path)) {
                                JavaModelManager.getJavaModelManager().closeZipFile(jar);
                                return 0x350000L;
                            }
                        }
                        catch (CoreException coreException) {
                            JavaModelManager.getJavaModelManager().closeZipFile(jar);
                            break block16;
                        }
                        catch (Throwable throwable) {
                            JavaModelManager.getJavaModelManager().closeZipFile(jar);
                            throw throwable;
                        }
                        {
                            jar = JavaModelManager.getJavaModelManager().getZipFile(path);
                            Enumeration<? extends ZipEntry> e = jar.entries();
                            while (e.hasMoreElements()) {
                                ZipEntry member = e.nextElement();
                                String entryName = member.getName();
                                if (!org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(entryName)) continue;
                                reader = ClassFileReader.read(jar, entryName);
                                break;
                            }
                        }
                    }
                    JavaModelManager.getJavaModelManager().closeZipFile(jar);
                }
            }
            if (reader == null) return 0L;
            return reader.getVersion();
        }
        catch (IOException | CoreException | ClassFormatException exception) {}
        return 0L;
    }

    public static String getNameWithoutJavaLikeExtension(String fileName) {
        int index = Util.indexOfJavaLikeExtension(fileName);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static String getLineSeparator(String text, IJavaProject project) {
        String lineSeparator = null;
        if (text != null && text.length() != 0 && (lineSeparator = Util.findLineSeparator(text.toCharArray())) != null) {
            return lineSeparator;
        }
        if (Platform.isRunning()) {
            IScopeContext[] scopeContext;
            if (project != null) {
                scopeContext = new IScopeContext[]{new ProjectScope(project.getProject())};
                lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
                if (lineSeparator != null) {
                    return lineSeparator;
                }
            }
            scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
            lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineSeparator != null) {
                return lineSeparator;
            }
        }
        return org.eclipse.jdt.internal.compiler.util.Util.LINE_SEPARATOR;
    }

    public static IPackageFragment getPackageFragment(char[] fileName, int pkgEnd, int jarSeparator) {
        if (jarSeparator != -1) {
            String jarMemento = new String(fileName, 0, jarSeparator);
            PackageFragmentRoot root = (PackageFragmentRoot)JavaCore.create(jarMemento);
            if (pkgEnd == jarSeparator) {
                return root.getPackageFragment(CharOperation.NO_STRINGS);
            }
            char[] pkgName = CharOperation.subarray(fileName, jarSeparator + 1, pkgEnd);
            char[][] compoundName = CharOperation.splitOn('/', pkgName);
            return root.getPackageFragment(CharOperation.toStrings(compoundName));
        }
        Path path = new Path(new String(fileName, 0, pkgEnd));
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IContainer folder = path.segmentCount() == 1 ? workspaceRoot.getProject(path.lastSegment()) : workspaceRoot.getFolder(path);
        IJavaElement element = JavaCore.create(folder);
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 4: {
                return (IPackageFragment)element;
            }
            case 3: {
                return ((PackageFragmentRoot)element).getPackageFragment(CharOperation.NO_STRINGS);
            }
            case 2: {
                PackageFragmentRoot root = (PackageFragmentRoot)((IJavaProject)element).getPackageFragmentRoot(folder);
                if (root == null) {
                    return null;
                }
                return root.getPackageFragment(CharOperation.NO_STRINGS);
            }
        }
        return null;
    }

    public static String getProblemArgumentsForMarker(String[] arguments) {
        StringBuffer args = new StringBuffer(10);
        args.append(arguments.length);
        args.append(':');
        int j = 0;
        while (j < arguments.length) {
            if (j != 0) {
                args.append('#');
            }
            if (arguments[j].length() == 0) {
                args.append("   ");
            } else {
                Util.encodeArgument(arguments[j], args);
            }
            ++j;
        }
        return args.toString();
    }

    private static void encodeArgument(String argument, StringBuffer buffer) {
        int i = 0;
        int max = argument.length();
        while (i < max) {
            char charAt = argument.charAt(i);
            switch (charAt) {
                case '#': {
                    buffer.append('#').append('#');
                    break;
                }
                default: {
                    buffer.append(charAt);
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResourceContentsAsByteArray(IFile file) throws JavaModelException {
        byte[] byArray;
        InputStream stream = null;
        try {
            stream = file.getContents(true);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        try {
            byArray = org.eclipse.jdt.internal.compiler.util.Util.getInputStreamAsByteArray(stream, -1);
        }
        catch (IOException e) {
            try {
                throw new JavaModelException(e, 985);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
    }

    public static char[] getResourceContentsAsCharArray(IFile file) throws JavaModelException {
        String encoding;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {
            encoding = null;
        }
        return Util.getResourceContentsAsCharArray(file, encoding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getResourceContentsAsCharArray(IFile file, String encoding) throws JavaModelException {
        char[] cArray;
        long length;
        IPath location = file.getLocation();
        if (location == null) {
            try {
                URI locationURI = file.getLocationURI();
                if (locationURI == null) {
                    throw new CoreException(new Status(4, "org.eclipse.jdt.core", Messages.bind(Messages.file_notFound, file.getFullPath().toString())));
                }
                length = EFS.getStore(locationURI).fetchInfo().getLength();
            }
            catch (CoreException e) {
                throw new JavaModelException(e, 969);
            }
        } else {
            length = location.toFile().length();
        }
        InputStream stream = null;
        try {
            stream = file.getContents(true);
        }
        catch (CoreException e) {
            throw new JavaModelException(e, 969);
        }
        try {
            cArray = org.eclipse.jdt.internal.compiler.util.Util.getInputStreamAsCharArray(stream, (int)length, encoding);
        }
        catch (IOException e) {
            try {
                throw new JavaModelException(e, 985);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return cArray;
        }
        catch (IOException iOException) {}
        return cArray;
    }

    public static String getSourceAttachmentProperty(IPath path) throws JavaModelException {
        Map<IPath, String> rootPathToAttachments = JavaModelManager.getJavaModelManager().rootPathToAttachments;
        String property = rootPathToAttachments.get(path);
        if (property == null) {
            block5: {
                try {
                    property = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(Util.getSourceAttachmentPropertyName(path));
                    if (property != null) break block5;
                    rootPathToAttachments.put(path, "");
                    return null;
                }
                catch (CoreException e) {
                    throw new JavaModelException(e);
                }
            }
            rootPathToAttachments.put(path, property);
            return property;
        }
        if (property.equals("")) {
            return null;
        }
        return property;
    }

    private static QualifiedName getSourceAttachmentPropertyName(IPath path) {
        return new QualifiedName("org.eclipse.jdt.core", "sourceattachment: " + path.toOSString());
    }

    public static String[] getTrimmedSimpleNames(String name) {
        String[] result = Signature.getSimpleNames(name);
        int i = 0;
        int length = result.length;
        while (i < length) {
            result[i] = result[i].trim();
            ++i;
        }
        return result;
    }

    public static int indexOfEnclosingPath(IPath checkedPath, IPath[] paths, int pathCount) {
        int bestMatch = -1;
        int bestLength = -1;
        int i = 0;
        while (i < pathCount) {
            int currentLength;
            if (!paths[i].equals(checkedPath) && paths[i].isPrefixOf(checkedPath) && (currentLength = paths[i].segmentCount()) > bestLength) {
                bestLength = currentLength;
                bestMatch = i;
            }
            ++i;
        }
        return bestMatch;
    }

    public static int indexOfJavaLikeExtension(String fileName) {
        int fileNameLength = fileName.length();
        char[][] javaLikeExtensions = Util.getJavaLikeExtensions();
        int i = 0;
        int length = javaLikeExtensions.length;
        while (i < length) {
            block4: {
                char[] extension = javaLikeExtensions[i];
                int extensionLength = extension.length;
                int extensionStart = fileNameLength - extensionLength;
                int dotIndex = extensionStart - 1;
                if (dotIndex >= 0 && fileName.charAt(dotIndex) == '.') {
                    int j = 0;
                    while (j < extensionLength) {
                        if (fileName.charAt(extensionStart + j) == extension[j]) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return dotIndex;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfMatchingPath(IPath checkedPath, IPath[] paths, int pathCount) {
        int i = 0;
        while (i < pathCount) {
            if (paths[i].equals(checkedPath)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static boolean isAttributeSupported(int attribute) {
        return (EFS.getLocalFileSystem().attributes() & attribute) != 0;
    }

    public static boolean isReadOnlySupported() {
        return Util.isAttributeSupported(2);
    }

    public static final boolean isExcluded(IJavaElement element) {
        int elementType = element.getElementType();
        switch (elementType) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                PackageFragmentRoot root = (PackageFragmentRoot)element.getAncestor(3);
                IResource resource = ((PackageFragment)element).resource();
                return resource != null && Util.isExcluded(resource, root.fullInclusionPatternChars(), root.fullExclusionPatternChars());
            }
            case 5: {
                PackageFragmentRoot root = (PackageFragmentRoot)element.getAncestor(3);
                IResource resource = element.getResource();
                if (resource == null) {
                    return false;
                }
                if (Util.isExcluded(resource, root.fullInclusionPatternChars(), root.fullExclusionPatternChars())) {
                    return true;
                }
                return Util.isExcluded(element.getParent());
            }
        }
        IJavaElement cu = element.getAncestor(5);
        return cu != null && Util.isExcluded(cu);
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean isFolderPath) {
        if (inclusionPatterns == null && exclusionPatterns == null) {
            return false;
        }
        return org.eclipse.jdt.internal.compiler.util.Util.isExcluded(resourcePath.toString().toCharArray(), inclusionPatterns, exclusionPatterns, isFolderPath);
    }

    public static final boolean isExcluded(IResource resource, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IPath path = resource.getFullPath();
        int resourceType = resource.getType();
        return Util.isExcluded(path, inclusionPatterns, exclusionPatterns, resourceType == 2 || resourceType == 4);
    }

    public static boolean isValidClassFileName(String name, String sourceLevel, String complianceLevel) {
        return JavaConventions.validateClassFileName(name, sourceLevel, complianceLevel).getSeverity() != 4;
    }

    public static boolean isValidCompilationUnitName(String name, String sourceLevel, String complianceLevel) {
        return JavaConventions.validateCompilationUnitName(name, sourceLevel, complianceLevel).getSeverity() != 4;
    }

    public static boolean isValidFolderNameForPackage(String folderName, String sourceLevel, String complianceLevel) {
        return JavaConventions.validateIdentifier(folderName, sourceLevel, complianceLevel).getSeverity() != 4;
    }

    public static String localTypeName(String binaryTypeName, int lastDollar, int end) {
        if (lastDollar > 0 && binaryTypeName.charAt(lastDollar - 1) == '$') {
            return binaryTypeName;
        }
        int nameStart = lastDollar + 1;
        while (nameStart < end && Character.isDigit(binaryTypeName.charAt(nameStart))) {
            ++nameStart;
        }
        return binaryTypeName.substring(nameStart, end);
    }

    public static void log(Throwable e, String message) {
        Throwable nestedException;
        if (e instanceof JavaModelException && (nestedException = ((JavaModelException)e).getException()) != null) {
            e = nestedException;
        }
        Util.log(new Status(4, "org.eclipse.jdt.core", 4, message, e));
    }

    public static void logRepeatedMessage(String key, int statusErrorID, String message) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (fgRepeatedMessages.contains(key)) {
            return;
        }
        fgRepeatedMessages.add(key);
        Util.log(statusErrorID, message);
    }

    public static void log(int statusErrorID, String message) {
        Util.log(new Status(statusErrorID, "org.eclipse.jdt.core", message));
    }

    public static void log(IStatus status) {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin == null) {
            System.err.println(status.toString());
        } else {
            plugin.getLog().log(status);
        }
    }

    public static void log(Throwable e) {
        Util.log(new Status(4, "org.eclipse.jdt.core", Messages.internal_error, e));
    }

    public static ClassFileReader newClassFileReader(IResource resource) throws CoreException, ClassFormatException, IOException {
        try (InputStream in = null;){
            in = ((IFile)resource).getContents(true);
            ClassFileReader classFileReader = ClassFileReader.read(in, resource.getFullPath().toString());
            return classFileReader;
        }
    }

    public static String packageName(IPath pkgPath, String sourceLevel, String complianceLevel) {
        StringBuffer pkgName = new StringBuffer("");
        int j = 0;
        int max = pkgPath.segmentCount();
        while (j < max) {
            String segment = pkgPath.segment(j);
            if (!Util.isValidFolderNameForPackage(segment, sourceLevel, complianceLevel)) {
                return null;
            }
            pkgName.append(segment);
            if (j < pkgPath.segmentCount() - 1) {
                pkgName.append(".");
            }
            ++j;
        }
        return pkgName.toString();
    }

    private static void quickSort(char[][] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        char[] mid = list[left + (right - left) / 2];
        while (true) {
            if (Util.compare(list[left], mid) < 0) {
                ++left;
                continue;
            }
            while (Util.compare(mid, list[right]) < 0) {
                --right;
            }
            if (left <= right) {
                char[] tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(int[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        int mid = list[left + (right - left) / 2];
        while (true) {
            if (list[left] < mid) {
                ++left;
                continue;
            }
            while (mid < list[right]) {
                --right;
            }
            if (left <= right) {
                int tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(Object[] sortedCollection, int left, int right, Comparer comparer) {
        int original_left = left;
        int original_right = right;
        Object mid = sortedCollection[left + (right - left) / 2];
        while (true) {
            if (comparer.compare(sortedCollection[left], mid) < 0) {
                ++left;
                continue;
            }
            while (comparer.compare(mid, sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                Object tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right, comparer);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right, comparer);
        }
    }

    private static void quickSort(String[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = sortedCollection[left + (right - left) / 2];
        while (true) {
            if (sortedCollection[left].compareTo(mid) < 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                String tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right);
        }
    }

    public static String relativePath(IPath fullPath, int skipSegmentCount) {
        boolean hasTrailingSeparator = fullPath.hasTrailingSeparator();
        String[] segments = fullPath.segments();
        int length = 0;
        int max = segments.length;
        if (max > skipSegmentCount) {
            int i1 = skipSegmentCount;
            while (i1 < max) {
                length += segments[i1].length();
                ++i1;
            }
            length += max - skipSegmentCount - 1;
        }
        if (hasTrailingSeparator) {
            ++length;
        }
        char[] result = new char[length];
        int offset = 0;
        int len = segments.length - 1;
        if (len >= skipSegmentCount) {
            int i = skipSegmentCount;
            while (i < len) {
                int size = segments[i].length();
                segments[i].getChars(0, size, result, offset);
                offset += size;
                result[offset++] = 47;
                ++i;
            }
            int size = segments[len].length();
            segments[len].getChars(0, size, result, offset);
            offset += size;
        }
        if (hasTrailingSeparator) {
            result[offset++] = 47;
        }
        return new String(result);
    }

    public static final String[] splitOn(char divider, String string, int start, int end) {
        int length;
        int n = length = string == null ? 0 : string.length();
        if (length == 0 || start > end) {
            return CharOperation.NO_STRINGS;
        }
        int wordCount = 1;
        int i = start;
        while (i < end) {
            if (string.charAt(i) == divider) {
                ++wordCount;
            }
            ++i;
        }
        String[] split = new String[wordCount];
        int last = start;
        int currentWord = 0;
        int i2 = start;
        while (i2 < end) {
            if (string.charAt(i2) == divider) {
                split[currentWord++] = string.substring(last, i2);
                last = i2 + 1;
            }
            ++i2;
        }
        split[currentWord] = string.substring(last, end);
        return split;
    }

    public static void setReadOnly(IResource resource, boolean readOnly) {
        if (Util.isReadOnlySupported()) {
            ResourceAttributes resourceAttributes = resource.getResourceAttributes();
            if (resourceAttributes == null) {
                return;
            }
            resourceAttributes.setReadOnly(readOnly);
            try {
                resource.setResourceAttributes(resourceAttributes);
            }
            catch (CoreException coreException) {}
        }
    }

    public static void sort(char[][] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(int[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(Object[] objects, Comparer comparer) {
        if (objects.length > 1) {
            Util.quickSort(objects, 0, objects.length - 1, comparer);
        }
    }

    public static void sort(String[] strings) {
        if (strings.length > 1) {
            Util.quickSort(strings, 0, strings.length - 1);
        }
    }

    public static IJavaElement[] sortCopy(IJavaElement[] elements) {
        int len = elements.length;
        Object[] copy = new IJavaElement[len];
        System.arraycopy(elements, 0, copy, 0, len);
        Util.sort(copy, new Comparer(){

            @Override
            public int compare(Object a, Object b) {
                return ((JavaElement)a).toStringWithAncestors().compareTo(((JavaElement)b).toStringWithAncestors());
            }
        });
        return copy;
    }

    public static boolean startsWithIgnoreCase(String[] compoundName, String[] prefix, boolean partialMatch) {
        int prefixLength = prefix.length;
        int nameLength = compoundName.length;
        if (prefixLength > nameLength) {
            return false;
        }
        int i = 0;
        while (i < prefixLength - 1) {
            if (!compoundName[i].equalsIgnoreCase(prefix[i])) {
                return false;
            }
            ++i;
        }
        return (partialMatch || prefixLength == nameLength) && compoundName[prefixLength - 1].toLowerCase().startsWith(prefix[prefixLength - 1].toLowerCase());
    }

    public static char[][] toCharArrays(String[] a) {
        int len = a.length;
        if (len == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        char[][] result = new char[len][];
        int i = 0;
        while (i < len) {
            result[i] = a[i].toCharArray();
            ++i;
        }
        return result;
    }

    public static File toLocalFile(URI uri, IProgressMonitor monitor) throws CoreException {
        IFileStore fileStore = EFS.getStore(uri);
        File localFile = fileStore.toLocalFile(0, monitor);
        if (localFile == null) {
            localFile = fileStore.toLocalFile(4096, monitor);
        }
        return localFile;
    }

    public static String[] toStrings(char[][] a) {
        int len = a.length;
        String[] result = new String[len];
        int i = 0;
        while (i < len) {
            result[i] = new String(a[i]);
            ++i;
        }
        return result;
    }

    private static void appendArrayTypeSignature(char[] string, int start, StringBuffer buffer, boolean compact) {
        int length = string.length;
        if (start >= length - 1) {
            throw Util.newIllegalArgumentException(string, start);
        }
        char c = string[start];
        if (c != '[') {
            throw Util.newUnexpectedCharacterException(string, start, c);
        }
        int index = start;
        c = string[++index];
        while (c == '[') {
            if (index >= length - 1) {
                throw Util.newIllegalArgumentException(string, start);
            }
            c = string[++index];
        }
        Util.appendTypeSignature(string, index, buffer, compact);
        int i = 0;
        int dims = index - start;
        while (i < dims) {
            buffer.append('[').append(']');
            ++i;
        }
    }

    private static void appendClassTypeSignature(char[] string, int start, StringBuffer buffer, boolean compact) {
        char c = string[start];
        if (c != 'L') {
            return;
        }
        int p = start + 1;
        int checkpoint = buffer.length();
        while (true) {
            c = string[p];
            switch (c) {
                case ';': {
                    return;
                }
                case '.': 
                case '/': {
                    if (compact) {
                        buffer.setLength(checkpoint);
                        break;
                    }
                    buffer.append('.');
                    break;
                }
                case '$': {
                    buffer.append('.');
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++p;
        }
    }

    static void appendTypeSignature(char[] string, int start, StringBuffer buffer, boolean compact) {
        char c = string[start];
        switch (c) {
            case '[': {
                Util.appendArrayTypeSignature(string, start, buffer, compact);
                break;
            }
            case 'L': {
                Util.appendClassTypeSignature(string, start, buffer, compact);
                break;
            }
            case 'T': {
                int e = org.eclipse.jdt.internal.compiler.util.Util.scanTypeVariableSignature(string, start);
                buffer.append(string, start + 1, e - start - 1);
                break;
            }
            case 'Z': {
                buffer.append(BOOLEAN);
                break;
            }
            case 'B': {
                buffer.append(BYTE);
                break;
            }
            case 'C': {
                buffer.append(CHAR);
                break;
            }
            case 'D': {
                buffer.append(DOUBLE);
                break;
            }
            case 'F': {
                buffer.append(FLOAT);
                break;
            }
            case 'I': {
                buffer.append(INT);
                break;
            }
            case 'J': {
                buffer.append(LONG);
                break;
            }
            case 'S': {
                buffer.append(SHORT);
                break;
            }
            case 'V': {
                buffer.append(VOID);
            }
        }
    }

    public static String toString(char[] declaringClass, char[] methodName, char[] methodSignature, boolean includeReturnType, boolean compact) {
        boolean isConstructor = CharOperation.equals(methodName, INIT);
        int firstParen = CharOperation.indexOf('(', methodSignature);
        if (firstParen == -1) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(methodSignature.length + 10);
        if (declaringClass != null && declaringClass.length > 0) {
            char[] declaringClassSignature = null;
            if (declaringClass[0] == '[') {
                CharOperation.replace(declaringClass, '/', '.');
                declaringClassSignature = Signature.toCharArray(declaringClass);
            } else {
                CharOperation.replace(declaringClass, '/', '.');
                declaringClassSignature = declaringClass;
            }
            int lastIndexOfSlash = CharOperation.lastIndexOf('.', declaringClassSignature);
            if (compact && lastIndexOfSlash != -1) {
                buffer.append(declaringClassSignature, lastIndexOfSlash + 1, declaringClassSignature.length - lastIndexOfSlash - 1);
            } else {
                buffer.append(declaringClassSignature);
            }
            if (!isConstructor) {
                buffer.append('.');
            }
        }
        if (!isConstructor && methodName != null) {
            buffer.append(methodName);
        }
        buffer.append('(');
        char[][] pts = Signature.getParameterTypes(methodSignature);
        int i = 0;
        int max = pts.length;
        while (i < max) {
            Util.appendTypeSignature(pts[i], 0, buffer, compact);
            if (i != pts.length - 1) {
                buffer.append(',');
                buffer.append(' ');
            }
            ++i;
        }
        buffer.append(')');
        if (!isConstructor) {
            buffer.append(" : ");
            if (includeReturnType) {
                char[] rts = Signature.getReturnType(methodSignature);
                Util.appendTypeSignature(rts, 0, buffer, compact);
            }
        }
        return String.valueOf(buffer);
    }

    public static String[] typeParameterSignatures(AbstractMethodDeclaration method) {
        Argument[] args = method.arguments;
        if (args != null) {
            int length = args.length;
            String[] signatures = new String[length];
            int i = 0;
            while (i < args.length) {
                Argument arg = args[i];
                signatures[i] = Util.typeSignature(arg.type);
                ++i;
            }
            return signatures;
        }
        return CharOperation.NO_STRINGS;
    }

    public static String typeSignature(TypeReference type) {
        String signature = null;
        if ((type.bits & 0x20000000) != 0) {
            UnionTypeReference unionTypeReference = (UnionTypeReference)type;
            TypeReference[] typeReferences = unionTypeReference.typeReferences;
            String[] typeSignatures = Util.typeSignatures(typeReferences);
            signature = Signature.createIntersectionTypeSignature(typeSignatures);
        } else if (type instanceof IntersectionCastTypeReference) {
            IntersectionCastTypeReference intersection = (IntersectionCastTypeReference)type;
            TypeReference[] typeReferences = intersection.typeReferences;
            String[] typeSignatures = Util.typeSignatures(typeReferences);
            signature = Signature.createUnionTypeSignature(typeSignatures);
        } else {
            char[][] compoundName = type.getParameterizedTypeName();
            char[] typeName = CharOperation.concatWith(compoundName, '.');
            signature = Signature.createTypeSignature(typeName, false);
        }
        return signature;
    }

    private static String[] typeSignatures(TypeReference[] types) {
        int length = types.length;
        String[] typeSignatures = new String[length];
        int i = 0;
        while (i < length) {
            char[][] compoundName = types[i].getParameterizedTypeName();
            char[] typeName = CharOperation.concatWith(compoundName, '.');
            typeSignatures[i] = Signature.createTypeSignature(typeName, false);
            ++i;
        }
        return typeSignatures;
    }

    public static void verbose(String log) {
        Util.verbose(log, System.out);
    }

    public static synchronized void verbose(String log, PrintStream printStream) {
        int end;
        int start = 0;
        do {
            end = log.indexOf(10, start);
            printStream.print(Thread.currentThread());
            printStream.print(" ");
            printStream.print(log.substring(start, end == -1 ? log.length() : end + 1));
        } while ((start = end + 1) != 0);
        printStream.println();
    }

    public static final boolean isJavaLikeFileName(String name) {
        if (name == null) {
            return false;
        }
        return Util.indexOfJavaLikeExtension(name) != -1;
    }

    public static IAnnotation getAnnotation(JavaElement parent, IBinaryAnnotation binaryAnnotation, String memberValuePairName) {
        char[] typeName = Signature.toCharArray(CharOperation.replaceOnCopy(binaryAnnotation.getTypeName(), '/', '.'));
        return new Annotation(parent, new String(typeName), memberValuePairName);
    }

    public static Object getAnnotationMemberValue(MemberValuePair memberValuePair, Constant constant) {
        if (constant == null) {
            memberValuePair.valueKind = 14;
            return null;
        }
        switch (constant.typeID()) {
            case 10: {
                memberValuePair.valueKind = 1;
                return constant.intValue();
            }
            case 3: {
                memberValuePair.valueKind = 2;
                return constant.byteValue();
            }
            case 4: {
                memberValuePair.valueKind = 3;
                return constant.shortValue();
            }
            case 2: {
                memberValuePair.valueKind = 4;
                return Character.valueOf(constant.charValue());
            }
            case 9: {
                memberValuePair.valueKind = 5;
                return new Float(constant.floatValue());
            }
            case 8: {
                memberValuePair.valueKind = 6;
                return new Double(constant.doubleValue());
            }
            case 5: {
                memberValuePair.valueKind = 8;
                return constant.booleanValue();
            }
            case 7: {
                memberValuePair.valueKind = 7;
                return constant.longValue();
            }
            case 11: {
                memberValuePair.valueKind = 9;
                return constant.stringValue();
            }
        }
        memberValuePair.valueKind = 14;
        return null;
    }

    public static Object getNegativeAnnotationMemberValue(MemberValuePair memberValuePair, Constant constant) {
        if (constant == null) {
            memberValuePair.valueKind = 14;
            return null;
        }
        switch (constant.typeID()) {
            case 10: {
                memberValuePair.valueKind = 1;
                return constant.intValue() * -1;
            }
            case 9: {
                memberValuePair.valueKind = 5;
                return new Float(constant.floatValue() * -1.0f);
            }
            case 8: {
                memberValuePair.valueKind = 6;
                return new Double(constant.doubleValue() * -1.0);
            }
            case 7: {
                memberValuePair.valueKind = 7;
                return constant.longValue() * -1L;
            }
        }
        memberValuePair.valueKind = 14;
        return null;
    }

    private static IllegalArgumentException newIllegalArgumentException(char[] string, int index) {
        return new IllegalArgumentException("\"" + String.valueOf(string) + "\" at " + index);
    }

    private static IllegalArgumentException newUnexpectedCharacterException(char[] string, int start, char unexpected) {
        return new IllegalArgumentException("Unexpected '" + unexpected + "' in \"" + String.valueOf(string) + "\" starting at " + start);
    }

    public static void fixTaskTags(Map defaultOptionsMap) {
        Object taskTagsValue = defaultOptionsMap.get("org.eclipse.jdt.core.compiler.taskTags");
        Object taskTags = null;
        if (taskTagsValue instanceof String) {
            taskTags = CharOperation.splitAndTrimOn(',', ((String)taskTagsValue).toCharArray());
        }
        Object taskPrioritiesValue = defaultOptionsMap.get("org.eclipse.jdt.core.compiler.taskPriorities");
        Object taskPriorities = null;
        if (taskPrioritiesValue instanceof String) {
            taskPriorities = CharOperation.splitAndTrimOn(',', ((String)taskPrioritiesValue).toCharArray());
        }
        if (taskPriorities == null) {
            if (taskTags != null) {
                Util.logRepeatedMessage("TASK_PRIORITIES_PB", 4, "Inconsistent values for taskTags (not null) and task priorities (null)");
                defaultOptionsMap.remove("org.eclipse.jdt.core.compiler.taskTags");
            }
            return;
        }
        if (taskTags == null) {
            Util.logRepeatedMessage("TASK_PRIORITIES_PB", 4, "Inconsistent values for taskTags (null) and task priorities (not null)");
            defaultOptionsMap.remove("org.eclipse.jdt.core.compiler.taskPriorities");
            return;
        }
        int taskTagsLength = ((char[][])taskTags).length;
        int taskPrioritiesLength = ((char[][])taskPriorities).length;
        if (taskTagsLength != taskPrioritiesLength) {
            Util.logRepeatedMessage("TASK_PRIORITIES_PB", 4, "Inconsistent values for taskTags and task priorities : length is different");
            if (taskTagsLength > taskPrioritiesLength) {
                char[][] cArray = taskTags;
                char[][] cArrayArray = new char[taskPrioritiesLength][];
                taskTags = cArrayArray;
                System.arraycopy(cArray, 0, cArrayArray, 0, taskPrioritiesLength);
                defaultOptionsMap.put("org.eclipse.jdt.core.compiler.taskTags", new String(CharOperation.concatWith(taskTags, ',')));
            } else {
                char[][] cArray = taskPriorities;
                char[][] cArrayArray = new char[taskTagsLength][];
                taskPriorities = cArrayArray;
                System.arraycopy(cArray, 0, cArrayArray, 0, taskTagsLength);
                defaultOptionsMap.put("org.eclipse.jdt.core.compiler.taskPriorities", new String(CharOperation.concatWith(taskPriorities, ',')));
            }
        }
    }

    public static interface Comparer {
        public int compare(Object var1, Object var2);
    }
}

