/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.java;

import java.util.List;
import org.eclipse.jdt.internal.core.nd.NdStruct;
import org.eclipse.jdt.internal.core.nd.db.IString;
import org.eclipse.jdt.internal.core.nd.field.FieldByte;
import org.eclipse.jdt.internal.core.nd.field.FieldList;
import org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.eclipse.jdt.internal.core.nd.field.FieldString;
import org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.eclipse.jdt.internal.core.nd.java.NdAnnotation;
import org.eclipse.jdt.internal.core.nd.java.NdTypeSignature;
import org.eclipse.jdt.internal.core.util.CharArrayBuffer;

public class NdMethodParameter
extends NdStruct {
    public static final FieldManyToOne<NdTypeSignature> ARGUMENT_TYPE;
    public static final FieldString NAME;
    public static final FieldList<NdAnnotation> ANNOTATIONS;
    public static final FieldByte FLAGS;
    public static StructDef<NdMethodParameter> type;

    static {
        type = StructDef.create(NdMethodParameter.class);
        ARGUMENT_TYPE = FieldManyToOne.create(type, NdTypeSignature.USED_AS_METHOD_ARGUMENT);
        NAME = type.addString();
        ANNOTATIONS = FieldList.create(type, NdAnnotation.type);
        FLAGS = type.addByte();
        type.done();
    }

    public void setType(NdTypeSignature argumentType) {
        ARGUMENT_TYPE.put(this.getNd(), this.address, argumentType);
    }

    public NdTypeSignature getType() {
        return ARGUMENT_TYPE.get(this.getNd(), this.address);
    }

    public void setName(char[] name) {
        NAME.put(this.getNd(), this.address, name);
    }

    public IString getName() {
        return NAME.get(this.getNd(), this.address);
    }

    public List<NdAnnotation> getAnnotations() {
        return ANNOTATIONS.asList(this.getNd(), this.address);
    }

    private void setFlag(byte flagConstant, boolean value) {
        byte oldFlags = FLAGS.get(this.getNd(), this.address);
        int newFlags = oldFlags & ~flagConstant | (value ? flagConstant : (byte)0);
        FLAGS.put(this.getNd(), this.address, (byte)newFlags);
    }

    private boolean getFlag(byte flagConstant) {
        return (FLAGS.get(this.getNd(), this.address) & flagConstant) != 0;
    }

    public void setCompilerDefined(boolean isCompilerDefined) {
        this.setFlag((byte)1, isCompilerDefined);
    }

    public boolean isCompilerDefined() {
        return this.getFlag((byte)1);
    }

    public String toString() {
        try {
            CharArrayBuffer buf = new CharArrayBuffer();
            buf.append(this.getType().toString());
            buf.append(" ");
            buf.append(this.getName().toString());
            return buf.toString();
        }
        catch (RuntimeException runtimeException) {
            return super.toString();
        }
    }

    public NdAnnotation createAnnotation() {
        return ANNOTATIONS.append(this.getNd(), this.getAddress());
    }

    public void allocateAnnotations(int length) {
        ANNOTATIONS.allocate(this.getNd(), this.getAddress(), length);
    }
}

