/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.Region;
import org.eclipse.jdt.internal.core.TypeVector;
import org.eclipse.jdt.internal.core.hierarchy.ChangeCollector;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.IndexBasedHierarchyBuilder;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class TypeHierarchy
implements IElementChangedListener,
ITypeHierarchy {
    public static boolean DEBUG = false;
    static final byte[] NO_FLAGS = new byte[0];
    protected IJavaProject project;
    protected IType focusType;
    protected ICompilationUnit[] workingCopies;
    protected Map<IType, IType> classToSuperclass;
    protected Map<IType, IType[]> typeToSuperInterfaces;
    protected Map<IType, TypeVector> typeToSubtypes;
    protected Map<IType, Integer> typeFlags;
    protected TypeVector rootClasses = new TypeVector();
    protected ArrayList<IType> interfaces = new ArrayList(10);
    public ArrayList<String> missingTypes = new ArrayList(4);
    protected static final IType[] NO_TYPE = new IType[0];
    protected SubMonitor progressMonitor = SubMonitor.convert(null);
    protected ArrayList<ITypeHierarchyChangedListener> changeListeners = null;
    public Map<IOpenable, ArrayList<IType>> files = null;
    protected Region packageRegion = null;
    protected Region projectRegion = null;
    protected boolean computeSubtypes;
    IJavaSearchScope scope;
    public boolean needsRefresh = true;
    protected ChangeCollector changeCollector;

    public TypeHierarchy() {
    }

    public TypeHierarchy(IType type, ICompilationUnit[] workingCopies, IJavaProject project, boolean computeSubtypes) {
        this(type, workingCopies, SearchEngine.createJavaSearchScope(new IJavaElement[]{project}), computeSubtypes);
        this.project = project;
    }

    public TypeHierarchy(IType type, ICompilationUnit[] workingCopies, IJavaSearchScope scope, boolean computeSubtypes) {
        this.focusType = type == null ? null : (IType)((Object)((JavaElement)((Object)type)).unresolved());
        this.workingCopies = workingCopies;
        this.computeSubtypes = computeSubtypes;
        this.scope = scope;
    }

    protected void initializeRegions() {
        IType[] allTypes = this.getAllTypes();
        int i = 0;
        while (i < allTypes.length) {
            IType type = allTypes[i];
            Openable o = (Openable)((JavaElement)((Object)type)).getOpenableParent();
            if (o != null) {
                ArrayList<IType> types = this.files.get(o);
                if (types == null) {
                    types = new ArrayList();
                    this.files.put(o, types);
                }
                types.add(type);
            }
            IPackageFragment pkg = type.getPackageFragment();
            this.packageRegion.add(pkg);
            IJavaProject declaringProject = type.getJavaProject();
            if (declaringProject != null) {
                this.projectRegion.add(declaringProject);
            }
            this.checkCanceled();
            ++i;
        }
    }

    protected void addInterface(IType type) {
        this.interfaces.add(type);
    }

    protected void addRootClass(IType type) {
        if (this.rootClasses.contains(type)) {
            return;
        }
        this.rootClasses.add(type);
    }

    protected void addSubtype(IType type, IType subtype) {
        TypeVector subtypes = this.typeToSubtypes.get(type);
        if (subtypes == null) {
            subtypes = new TypeVector();
            this.typeToSubtypes.put(type, subtypes);
        }
        if (!subtypes.contains(subtype)) {
            subtypes.add(subtype);
        }
    }

    public void cacheFlags(IType type, int flags) {
        this.typeFlags.put(type, flags);
    }

    protected void cacheSuperclass(IType type, IType superclass) {
        if (superclass != null) {
            if (superclass.equals(type)) {
                Util.log(4, "Type " + type.getFullyQualifiedName() + " is it's own superclass");
                return;
            }
            this.classToSuperclass.put(type, superclass);
            this.addSubtype(superclass, type);
        }
    }

    protected void cacheSuperInterfaces(IType type, IType[] superinterfaces) {
        this.typeToSuperInterfaces.put(type, superinterfaces);
        int i = 0;
        while (i < superinterfaces.length) {
            IType superinterface = superinterfaces[i];
            if (superinterface != null) {
                this.addSubtype(superinterface, type);
            }
            ++i;
        }
    }

    protected void checkCanceled() {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void compute() throws JavaModelException, CoreException {
        if (this.focusType != null) {
            IndexBasedHierarchyBuilder builder = new IndexBasedHierarchyBuilder(this, this.scope);
            ((HierarchyBuilder)builder).build(this.computeSubtypes);
        }
    }

    public boolean contains(IType type) {
        if (this.classToSuperclass.get(type) != null) {
            return true;
        }
        if (this.rootClasses.contains(type)) {
            return true;
        }
        return this.interfaces.contains(type);
    }

    @Override
    public void elementChanged(ElementChangedEvent event) {
        if (this.needsRefresh) {
            return;
        }
        if (this.isAffected(event.getDelta(), event.getType())) {
            this.needsRefresh = true;
            this.fireChange();
        }
    }

    public boolean exists() {
        if (!this.needsRefresh) {
            return true;
        }
        return (this.focusType == null || this.focusType.exists()) && this.javaProject().exists();
    }

    public void fireChange() {
        ArrayList<ITypeHierarchyChangedListener> listeners = this.getClonedChangeListeners();
        if (listeners == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("FIRING hierarchy change [" + Thread.currentThread() + "]");
            if (this.focusType != null) {
                System.out.println("    for hierarchy focused on " + ((JavaElement)((Object)this.focusType)).toStringWithAncestors());
            }
        }
        int i = 0;
        while (i < listeners.size()) {
            final ITypeHierarchyChangedListener listener = listeners.get(i);
            SafeRunner.run(new ISafeRunnable(){

                @Override
                public void handleException(Throwable exception) {
                    Util.log(exception, "Exception occurred in listener of Type hierarchy change notification");
                }

                @Override
                public void run() throws Exception {
                    listener.typeHierarchyChanged(TypeHierarchy.this);
                }
            });
            ++i;
        }
    }

    private synchronized ArrayList<ITypeHierarchyChangedListener> getClonedChangeListeners() {
        ArrayList<ITypeHierarchyChangedListener> listeners = this.changeListeners;
        if (listeners == null) {
            return null;
        }
        return (ArrayList)listeners.clone();
    }

    public IType[] getAllClasses() {
        TypeVector classes = this.rootClasses.copy();
        Iterator<IType> iter = this.classToSuperclass.keySet().iterator();
        while (iter.hasNext()) {
            classes.add(iter.next());
        }
        return classes.elements();
    }

    public IType[] getAllInterfaces() {
        IType[] collection = new IType[this.interfaces.size()];
        this.interfaces.toArray(collection);
        return collection;
    }

    @Override
    public IType[] getAllSubtypes(IType type) {
        return this.getAllSubtypesForType(type);
    }

    private IType[] getAllSubtypesForType(IType type) {
        ArrayList<IType> subTypes = new ArrayList<IType>();
        this.getAllSubtypesForType0(type, subTypes);
        IType[] subClasses = new IType[subTypes.size()];
        subTypes.toArray(subClasses);
        return subClasses;
    }

    private void getAllSubtypesForType0(IType type, ArrayList<IType> subs) {
        IType[] subTypes = this.getSubtypesForType(type);
        if (subTypes.length != 0) {
            int i = 0;
            while (i < subTypes.length) {
                IType subType = subTypes[i];
                if (!subs.contains(subType)) {
                    subs.add(subType);
                    this.getAllSubtypesForType0(subType, subs);
                }
                ++i;
            }
        }
    }

    private ArrayList<IType> getAllSuperInterfaces0(IType type, ArrayList<IType> supers) {
        IType superclass;
        IType[] superinterfaces = this.typeToSuperInterfaces.get(type);
        if (superinterfaces == null) {
            return supers;
        }
        if (superinterfaces.length != 0) {
            if (supers == null) {
                supers = new ArrayList();
            }
            int i1 = 0;
            while (i1 < superinterfaces.length) {
                IType element = superinterfaces[i1];
                if (!supers.contains(element)) {
                    supers.add(element);
                    supers = this.getAllSuperInterfaces0(element, supers);
                }
                ++i1;
            }
        }
        if ((superclass = this.classToSuperclass.get(type)) != null) {
            supers = this.getAllSuperInterfaces0(superclass, supers);
        }
        return supers;
    }

    @Override
    public IType[] getAllSupertypes(IType type) {
        ArrayList<IType> supers = this.getAllSupertypes0(type, null);
        if (supers == null) {
            return NO_TYPE;
        }
        IType[] supertypes = new IType[supers.size()];
        supers.toArray(supertypes);
        return supertypes;
    }

    private ArrayList<IType> getAllSupertypes0(IType type, ArrayList<IType> supers) {
        IType superclass;
        IType[] superinterfaces = this.typeToSuperInterfaces.get(type);
        if (superinterfaces == null) {
            return supers;
        }
        if (superinterfaces.length != 0) {
            if (supers == null) {
                supers = new ArrayList();
            }
            int i1 = 0;
            while (i1 < superinterfaces.length) {
                IType element = superinterfaces[i1];
                if (!supers.contains(element)) {
                    supers.add(element);
                    supers = this.getAllSuperInterfaces0(element, supers);
                }
                ++i1;
            }
        }
        if ((superclass = this.classToSuperclass.get(type)) != null) {
            if (supers == null) {
                supers = new ArrayList();
            }
            supers.add(superclass);
            supers = this.getAllSupertypes0(superclass, supers);
        }
        return supers;
    }

    @Override
    public IType[] getAllTypes() {
        IType[] classes = this.getAllClasses();
        int classesLength = classes.length;
        IType[] allInterfaces = this.getAllInterfaces();
        int interfacesLength = allInterfaces.length;
        IType[] all = new IType[classesLength + interfacesLength];
        System.arraycopy(classes, 0, all, 0, classesLength);
        System.arraycopy(allInterfaces, 0, all, classesLength, interfacesLength);
        return all;
    }

    public int getCachedFlags(IType type) {
        Integer flagObject = this.typeFlags.get(type);
        if (flagObject != null) {
            return flagObject;
        }
        return -1;
    }

    public IType[] getRootClasses() {
        return this.rootClasses.elements();
    }

    public IType[] getRootInterfaces() {
        IType[] allInterfaces = this.getAllInterfaces();
        IType[] roots = new IType[allInterfaces.length];
        int rootNumber = 0;
        int i = 0;
        while (i < allInterfaces.length) {
            IType[] superInterfaces = this.getSuperInterfaces(allInterfaces[i]);
            if (superInterfaces == null || superInterfaces.length == 0) {
                roots[rootNumber++] = allInterfaces[i];
            }
            ++i;
        }
        IType[] result = new IType[rootNumber];
        if (result.length > 0) {
            System.arraycopy(roots, 0, result, 0, rootNumber);
        }
        return result;
    }

    public IType[] getSubtypes(IType type) {
        return this.getSubtypesForType(type);
    }

    private IType[] getSubtypesForType(IType type) {
        TypeVector vector = this.typeToSubtypes.get(type);
        if (vector == null) {
            return NO_TYPE;
        }
        return vector.elements();
    }

    public IType getSuperclass(IType type) {
        if (this.isInterface(type)) {
            return null;
        }
        return this.classToSuperclass.get(type);
    }

    public IType[] getSuperInterfaces(IType type) {
        IType[] types = this.typeToSuperInterfaces.get(type);
        if (types == null) {
            return NO_TYPE;
        }
        return types;
    }

    public IType[] getSupertypes(IType type) {
        IType superclass = this.getSuperclass(type);
        if (superclass == null) {
            return this.getSuperInterfaces(type);
        }
        TypeVector superTypes = new TypeVector(this.getSuperInterfaces(type));
        superTypes.add(superclass);
        return superTypes.elements();
    }

    public IType getType() {
        return this.focusType;
    }

    public boolean hasFineGrainChanges() {
        ChangeCollector collector = this.changeCollector;
        return collector != null && collector.needsRefresh();
    }

    private boolean hasSubtypeNamed(String name) {
        String simpleName;
        int idx = -1;
        idx = name.indexOf(60);
        String rawName = idx > -1 ? name.substring(0, idx) : name;
        idx = rawName.lastIndexOf(46);
        String string = simpleName = idx > -1 ? rawName.substring(idx + 1) : rawName;
        if (this.focusType != null && this.focusType.getElementName().equals(simpleName)) {
            return true;
        }
        IType[] types = this.focusType == null ? this.getAllTypes() : this.getAllSubtypes(this.focusType);
        int i = 0;
        int length = types.length;
        while (i < length) {
            if (types[i].getElementName().equals(simpleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasTypeNamed(String simpleName) {
        IType[] types = this.getAllTypes();
        int i = 0;
        int length = types.length;
        while (i < length) {
            if (types[i].getElementName().equals(simpleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean includesTypeOrSupertype(IType type) {
        try {
            int lastSeparator;
            String simpleName;
            if (this.hasTypeNamed(type.getElementName())) {
                return true;
            }
            String superclassName = type.getSuperclassName();
            if (superclassName != null && this.hasTypeNamed(simpleName = superclassName.substring((lastSeparator = superclassName.lastIndexOf(46)) + 1))) {
                return true;
            }
            String[] superinterfaceNames = type.getSuperInterfaceNames();
            if (superinterfaceNames == null) return false;
            int i = 0;
            int length = superinterfaceNames.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                String superinterfaceName = superinterfaceNames[i];
                int lastSeparator2 = superinterfaceName.lastIndexOf(46);
                String simpleName2 = superinterfaceName.substring(lastSeparator2 + 1);
                if (this.hasTypeNamed(simpleName2)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    protected void initialize(int size) {
        if (size < 10) {
            size = 10;
        }
        int smallSize = size / 2;
        this.classToSuperclass = new HashMap<IType, IType>(size);
        this.interfaces = new ArrayList(smallSize);
        this.missingTypes = new ArrayList(smallSize);
        this.rootClasses = new TypeVector();
        this.typeToSubtypes = new HashMap<IType, TypeVector>(smallSize);
        this.typeToSuperInterfaces = new HashMap<IType, IType[]>(smallSize);
        this.typeFlags = new HashMap<IType, Integer>(smallSize);
        this.projectRegion = new Region();
        this.packageRegion = new Region();
        this.files = new HashMap<IOpenable, ArrayList<IType>>(5);
    }

    public synchronized boolean isAffected(IJavaElementDelta delta, int eventType) {
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                return this.isAffectedByJavaModel(delta, element, eventType);
            }
            case 2: {
                return this.isAffectedByJavaProject(delta, element, eventType);
            }
            case 3: {
                return this.isAffectedByPackageFragmentRoot(delta, element, eventType);
            }
            case 4: {
                return this.isAffectedByPackageFragment(delta, (PackageFragment)element, eventType);
            }
            case 5: 
            case 6: {
                return this.isAffectedByOpenable(delta, element, eventType);
            }
        }
        return false;
    }

    private boolean isAffectedByChildren(IJavaElementDelta delta, int eventType) {
        if ((delta.getFlags() & 8) > 0) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.isAffected(children[i], eventType)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isAffectedByJavaModel(IJavaElementDelta delta, IJavaElement element, int eventType) {
        switch (delta.getKind()) {
            case 1: 
            case 2: {
                return element.equals(this.javaProject().getJavaModel());
            }
            case 4: {
                return this.isAffectedByChildren(delta, eventType);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isAffectedByJavaProject(IJavaElementDelta delta, IJavaElement element, int eventType) {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if ((flags & 0x200) != 0) {
            kind = 1;
        }
        if ((flags & 0x400) != 0) {
            kind = 2;
        }
        switch (kind) {
            case 1: {
                try {
                    IClasspathEntry[] classpath = ((JavaProject)this.javaProject()).getExpandedClasspath();
                    int i = 0;
                    while (i < classpath.length) {
                        if (classpath[i].getEntryKind() == 2 && classpath[i].getPath().equals(element.getPath())) {
                            return true;
                        }
                        ++i;
                    }
                    if (this.focusType != null) {
                        classpath = ((JavaProject)element).getExpandedClasspath();
                        IPath hierarchyProject = this.javaProject().getPath();
                        int i2 = 0;
                        while (i2 < classpath.length) {
                            if (classpath[i2].getEntryKind() == 2 && classpath[i2].getPath().equals(hierarchyProject)) {
                                return true;
                            }
                            ++i2;
                        }
                    }
                    return false;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            case 2: {
                IJavaElement[] pkgs = this.packageRegion.getElements();
                int i = 0;
                while (i < pkgs.length) {
                    IJavaProject javaProject = pkgs[i].getJavaProject();
                    if (javaProject != null && javaProject.equals(element)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 4: {
                return this.isAffectedByChildren(delta, eventType);
            }
        }
        return false;
    }

    private boolean isAffectedByPackageFragment(IJavaElementDelta delta, PackageFragment element, int eventType) {
        switch (delta.getKind()) {
            case 1: {
                return this.projectRegion.contains(element);
            }
            case 2: {
                return this.packageRegionContainsSamePackageFragment(element);
            }
            case 4: {
                return this.isAffectedByChildren(delta, eventType);
            }
        }
        return false;
    }

    private boolean isAffectedByPackageFragmentRoot(IJavaElementDelta delta, IJavaElement element, int eventType) {
        switch (delta.getKind()) {
            case 1: {
                return this.projectRegion.contains(element);
            }
            case 2: 
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x40) > 0 && this.projectRegion != null) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    IPath rootPath = root.getPath();
                    IJavaElement[] elements = this.projectRegion.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        JavaProject javaProject = (JavaProject)elements[i];
                        try {
                            IClasspathEntry entry = javaProject.getClasspathEntryFor(rootPath);
                            if (entry != null) {
                                return true;
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                        ++i;
                    }
                }
                if ((flags & 0x80) <= 0 && (flags & 0x8000) <= 0) break;
                IJavaElement[] pkgs = this.packageRegion.getElements();
                int i = 0;
                while (i < pkgs.length) {
                    if (pkgs[i].getParent().equals(element)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        }
        return this.isAffectedByChildren(delta, eventType);
    }

    protected boolean isAffectedByOpenable(IJavaElementDelta delta, IJavaElement element, int eventType) {
        if (element instanceof CompilationUnit) {
            ChangeCollector collector;
            CompilationUnit cu;
            block16: {
                ICompilationUnit focusCU;
                cu = (CompilationUnit)element;
                ICompilationUnit iCompilationUnit = focusCU = this.focusType != null ? this.focusType.getCompilationUnit() : null;
                if (focusCU != null && focusCU.getOwner() != cu.getOwner()) {
                    return false;
                }
                if (eventType != 4 && !cu.isPrimary() && delta.getKind() == 1) {
                    return false;
                }
                collector = this.changeCollector;
                if (collector == null) {
                    collector = new ChangeCollector(this);
                }
                try {
                    collector.addChange(cu, delta);
                }
                catch (JavaModelException e) {
                    if (!DEBUG) break block16;
                    e.printStackTrace();
                }
            }
            if (cu.isWorkingCopy() && eventType == 4) {
                this.changeCollector = collector;
                return false;
            }
            return collector.needsRefresh();
        }
        if (element instanceof ClassFile) {
            switch (delta.getKind()) {
                case 2: {
                    IOpenable o = (IOpenable)((Object)element);
                    return this.files.get(o) != null;
                }
                case 1: {
                    IType type = ((ClassFile)element).getType();
                    String typeName = type.getElementName();
                    if (!this.hasSupertype(typeName) && !this.subtypesIncludeSupertypeOf(type) && !this.missingTypes.contains(typeName)) break;
                    return true;
                }
                case 4: {
                    IJavaElementDelta[] children = delta.getAffectedChildren();
                    int i = 0;
                    int length = children.length;
                    while (i < length) {
                        IJavaElementDelta child = children[i];
                        IJavaElement childElement = child.getElement();
                        if (childElement instanceof IType) {
                            boolean hasSupertypeChange;
                            IType type = (IType)childElement;
                            boolean hasVisibilityChange = (delta.getFlags() & 2) > 0;
                            boolean bl = hasSupertypeChange = (delta.getFlags() & 0x800) > 0;
                            if (hasVisibilityChange && this.hasSupertype(type.getElementName()) || hasSupertypeChange && this.includesTypeOrSupertype(type)) {
                                return true;
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return false;
    }

    private boolean isInterface(IType type) {
        int flags = this.getCachedFlags(type);
        if (flags == -1) {
            try {
                return type.isInterface();
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return Flags.isInterface(flags);
    }

    public IJavaProject javaProject() {
        return this.focusType.getJavaProject();
    }

    protected boolean packageRegionContainsSamePackageFragment(PackageFragment element) {
        IJavaElement[] pkgs = this.packageRegion.getElements();
        int i = 0;
        while (i < pkgs.length) {
            PackageFragment pkg = (PackageFragment)pkgs[i];
            if (Util.equalArraysOrNull(pkg.names, element.names)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public synchronized void refresh(IProgressMonitor monitor) throws JavaModelException {
        try {
            try {
                this.progressMonitor = SubMonitor.convert(monitor, this.focusType != null ? Messages.bind(Messages.hierarchy_creatingOnType, this.focusType.getFullyQualifiedName()) : Messages.hierarchy_creating, 100);
                long start = -1L;
                if (DEBUG) {
                    start = System.currentTimeMillis();
                    if (this.computeSubtypes) {
                        System.out.println("CREATING TYPE HIERARCHY [" + Thread.currentThread() + "]");
                    } else {
                        System.out.println("CREATING SUPER TYPE HIERARCHY [" + Thread.currentThread() + "]");
                    }
                    if (this.focusType != null) {
                        System.out.println("  on type " + ((JavaElement)((Object)this.focusType)).toStringWithAncestors());
                    }
                }
                this.compute();
                this.initializeRegions();
                this.needsRefresh = false;
                this.changeCollector = null;
                if (DEBUG) {
                    if (this.computeSubtypes) {
                        System.out.println("CREATED TYPE HIERARCHY in " + (System.currentTimeMillis() - start) + "ms");
                    } else {
                        System.out.println("CREATED SUPER TYPE HIERARCHY in " + (System.currentTimeMillis() - start) + "ms");
                    }
                    System.out.println(this.toString());
                }
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            this.progressMonitor = null;
        }
    }

    boolean subtypesIncludeSupertypeOf(IType type) {
        String superclassName = null;
        try {
            superclassName = type.getSuperclassName();
        }
        catch (JavaModelException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        if (superclassName == null) {
            superclassName = "Object";
        }
        if (this.hasSubtypeNamed(superclassName)) {
            return true;
        }
        String[] interfaceNames = null;
        try {
            interfaceNames = type.getSuperInterfaceNames();
        }
        catch (JavaModelException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        int i = 0;
        int length = interfaceNames.length;
        while (i < length) {
            String interfaceName = interfaceNames[i];
            if (this.hasSubtypeNamed(interfaceName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Focus: ");
        if (this.focusType == null) {
            buffer.append("<NONE>\n");
        } else {
            this.toString(buffer, this.focusType, 0);
        }
        if (this.exists()) {
            if (this.focusType != null) {
                buffer.append("Super types:\n");
                this.toString(buffer, this.focusType, 0, true);
                buffer.append("Sub types:\n");
                this.toString(buffer, this.focusType, 0, false);
            } else if (this.rootClasses.size > 0) {
                IJavaElement root;
                IJavaElement[] roots = Util.sortCopy(this.getRootClasses());
                buffer.append("Super types of root classes:\n");
                int length = roots.length;
                int i = 0;
                while (i < length) {
                    root = roots[i];
                    this.toString(buffer, root, 1);
                    this.toString(buffer, root, 1, true);
                    ++i;
                }
                buffer.append("Sub types of root classes:\n");
                i = 0;
                while (i < length) {
                    root = roots[i];
                    this.toString(buffer, root, 1);
                    this.toString(buffer, root, 1, false);
                    ++i;
                }
            } else if (this.rootClasses.size == 0) {
                buffer.append("No root classes");
            }
        } else {
            buffer.append("(Hierarchy became stale)");
        }
        return buffer.toString();
    }

    private void toString(StringBuffer buffer, IJavaElement type, int indent, boolean ascendant) {
        IJavaElement[] types = ascendant ? this.getSupertypes((IType)type) : this.getSubtypes((IType)type);
        IJavaElement[] sortedTypes = Util.sortCopy(types);
        int i = 0;
        while (i < sortedTypes.length) {
            this.toString(buffer, sortedTypes[i], indent + 1);
            this.toString(buffer, sortedTypes[i], indent + 1, ascendant);
            ++i;
        }
    }

    private void toString(StringBuffer buffer, IJavaElement type, int indent) {
        int j = 0;
        while (j < indent) {
            buffer.append("  ");
            ++j;
        }
        buffer.append(((JavaElement)type).toStringWithAncestors(false));
        buffer.append('\n');
    }

    boolean hasSupertype(String simpleName) {
        for (IType superType : this.classToSuperclass.values()) {
            if (!superType.getElementName().equals(simpleName)) continue;
            return true;
        }
        return false;
    }
}

