/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.util;

import org.eclipse.jdt.core.dom.AST;

public class DOMASTUtil {
    private static boolean isNodeTypeSupportedinAST(AST ast, int nodeType) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast.apiLevel(), ast.isPreviewEnabledSet(), nodeType);
    }

    private static boolean isNodeTypeSupportedinAST(int apiLevel, boolean previewEnabled, int nodeType) {
        switch (nodeType) {
            case 100: 
            case 101: {
                return apiLevel >= 14;
            }
            case 102: {
                return apiLevel >= 15;
            }
            case 62: 
            case 103: {
                return DOMASTUtil.isPreviewEnabled(apiLevel, previewEnabled);
            }
        }
        return false;
    }

    public static boolean isFeatureSupportedinAST(AST ast, int featureName) {
        switch (featureName) {
            case 512: {
                return DOMASTUtil.isPreviewEnabled(ast.apiLevel(), ast.isPreviewEnabledSet());
            }
        }
        return false;
    }

    public static boolean isFeatureSupportedinAST(int apiLevel, boolean previewEnabled, int featureName) {
        switch (featureName) {
            case 512: {
                return DOMASTUtil.isPreviewEnabled(apiLevel, previewEnabled);
            }
        }
        return false;
    }

    private static boolean isPreviewEnabled(int apiLevel, boolean previewEnabled) {
        return apiLevel == 15 && previewEnabled;
    }

    public static boolean isRecordDeclarationSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 103);
    }

    public static boolean isRecordDeclarationSupported(int apiLevel, boolean previewEnabled) {
        return DOMASTUtil.isNodeTypeSupportedinAST(apiLevel, previewEnabled, 103);
    }

    public static boolean isInstanceofExpressionPatternSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 62);
    }

    public static boolean isInstanceofExpressionPatternSupported(int apiLevel, boolean previewEnabled) {
        return DOMASTUtil.isNodeTypeSupportedinAST(apiLevel, previewEnabled, 62);
    }

    public static void checkASTLevel(int level) {
        switch (level) {
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return;
            }
        }
        throw new IllegalArgumentException();
    }
}

