/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.Annotation;
import org.eclipse.jdt.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.Initializer;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.NamedMember;
import org.eclipse.jdt.internal.core.ResolvedSourceType;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Messages;

public class SourceType
extends NamedMember
implements IType {
    public int localOccurrenceCount = 1;
    private static final IField[] NO_FIELDS = new IField[0];

    protected SourceType(JavaElement parent, String name) {
        super(parent, name);
    }

    @Override
    protected void closing(Object info) throws JavaModelException {
        super.closing(info);
        SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)info;
        ITypeParameter[] typeParameters = elementInfo.typeParameters;
        int i = 0;
        int length = typeParameters.length;
        while (i < length) {
            ((TypeParameter)typeParameters[i]).close();
            ++i;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SourceType)) {
            return false;
        }
        if (((SourceType)o).isLambda()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public IAnnotation[] getAnnotations() throws JavaModelException {
        AnnotatableInfo info = (AnnotatableInfo)this.getElementInfo();
        return info.annotations;
    }

    @Override
    public IType getDeclaringType() {
        for (IJavaElement parentElement = this.getParent(); parentElement != null; parentElement = parentElement.getParent()) {
            if (parentElement.getElementType() == 7) {
                return (IType)parentElement;
            }
            if (parentElement instanceof IMember) {
                continue;
            }
            return null;
        }
        return null;
    }

    @Override
    public IOrdinaryClassFile getClassFile() {
        return null;
    }

    @Override
    public int getElementType() {
        return 7;
    }

    @Override
    public IField getField(String fieldName) {
        return new SourceField(this, fieldName);
    }

    public IField[] getRecordComponents() throws JavaModelException {
        if (!this.isRecord()) {
            return NO_FIELDS;
        }
        return this.getFieldsOrComponents(true);
    }

    private IField[] getFieldsOrComponents(boolean component) throws JavaModelException {
        ArrayList list = this.getChildrenOfType(8);
        if (list.size() == 0) {
            return NO_FIELDS;
        }
        ArrayList<IField> fields = new ArrayList<IField>();
        for (Object object : list) {
            IField field = (IField)object;
            if (field.isRecordComponent() != component) continue;
            fields.add(field);
        }
        IField[] array = new IField[fields.size()];
        fields.toArray(array);
        return array;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName('$');
    }

    @Override
    public String getFullyQualifiedName(char enclosingTypeSeparator) {
        try {
            return this.getFullyQualifiedName(enclosingTypeSeparator, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    @Override
    protected String getOccurrenceCountSignature() {
        return Integer.toString(this.localOccurrenceCount);
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case '^': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String fieldName = memento.nextToken();
                JavaElement field = (JavaElement)((Object)this.getField(fieldName));
                return field.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '|': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String count = memento.nextToken();
                JavaElement initializer = (JavaElement)((Object)this.getInitializer(Integer.parseInt(count)));
                return initializer.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '~': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String selector = memento.nextToken();
                ArrayList<String> params = new ArrayList<String>();
                block16: while (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    switch (token.charAt(0)) {
                        case '[': 
                        case ']': 
                        case '}': {
                            break block16;
                        }
                        case '~': {
                            if (!memento.hasMoreTokens()) {
                                return this;
                            }
                            String param = memento.nextToken();
                            StringBuffer buffer = new StringBuffer();
                            while (param.length() == 1 && '[' == param.charAt(0)) {
                                buffer.append('[');
                                if (!memento.hasMoreTokens()) {
                                    return this;
                                }
                                param = memento.nextToken();
                            }
                            params.add(String.valueOf(buffer.toString()) + param);
                            break;
                        }
                        default: {
                            break block16;
                        }
                    }
                }
                String[] parameters = new String[params.size()];
                params.toArray(parameters);
                JavaElement method = (JavaElement)((Object)this.getMethod(selector, parameters));
                switch (token.charAt(0)) {
                    case ')': 
                    case '@': 
                    case '[': 
                    case ']': 
                    case '}': {
                        return method.getHandleFromMemento(token, memento, workingCopyOwner);
                    }
                }
                return method;
            }
            case '[': {
                String typeName;
                if (memento.hasMoreTokens()) {
                    typeName = memento.nextToken();
                    char firstChar = typeName.charAt(0);
                    if (firstChar == '^' || firstChar == '|' || firstChar == '~' || firstChar == '[' || firstChar == '!') {
                        token = typeName;
                        typeName = "";
                    } else {
                        token = null;
                    }
                } else {
                    typeName = "";
                    token = null;
                }
                JavaElement type = (JavaElement)((Object)this.getType(typeName));
                if (token == null) {
                    return type.getHandleFromMemento(memento, workingCopyOwner);
                }
                return type.getHandleFromMemento(token, memento, workingCopyOwner);
            }
            case ']': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeParameterName = memento.nextToken();
                TypeParameter typeParameter = new TypeParameter(this, typeParameterName);
                return typeParameter.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '}': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String annotationName = memento.nextToken();
                Annotation annotation = new Annotation(this, annotationName);
                return annotation.getHandleFromMemento(memento, workingCopyOwner);
            }
        }
        return null;
    }

    @Override
    public IInitializer getInitializer(int count) {
        return new Initializer(this, count);
    }

    public String getKey() {
        try {
            return this.getKey(this, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    @Override
    public IMethod getMethod(String selector, String[] parameterTypeSignatures) {
        return new SourceMethod(this, selector, parameterTypeSignatures);
    }

    @Override
    public IMethod[] getMethods() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(9);
        IMethod[] array = new IMethod[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IPackageFragment getPackageFragment() {
        IJavaElement parentElement = this.parent;
        while (parentElement != null) {
            if (parentElement.getElementType() == 4) {
                return (IPackageFragment)parentElement;
            }
            parentElement = parentElement.getParent();
        }
        Assert.isTrue(false);
        return null;
    }

    @Override
    public String getSuperclassName() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        char[] superclassName = info.getSuperclassName();
        if (superclassName == null) {
            return null;
        }
        return new String(superclassName);
    }

    @Override
    public String[] getSuperInterfaceNames() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        char[][] names = info.getInterfaceNames();
        return CharOperation.toStrings(names);
    }

    @Override
    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return info.typeParameters;
    }

    @Override
    public IType getType(String typeName) {
        return new SourceType(this, typeName);
    }

    @Override
    public ITypeParameter getTypeParameter(String typeParameterName) {
        return new TypeParameter(this, typeParameterName);
    }

    @Override
    public String getTypeQualifiedName(char enclosingTypeSeparator) {
        try {
            return this.getTypeQualifiedName(enclosingTypeSeparator, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    @Override
    public IType[] getTypes() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public boolean isAnonymous() {
        return this.name.length() == 0;
    }

    @Override
    public boolean isClass() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return TypeDeclaration.kind(info.getModifiers()) == 1;
    }

    @Override
    public boolean isEnum() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return TypeDeclaration.kind(info.getModifiers()) == 3;
    }

    public boolean isRecord() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return TypeDeclaration.kind(info.getModifiers()) == 5;
    }

    public boolean isSealed() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return Flags.isSealed(info.getModifiers());
    }

    @Override
    public boolean isInterface() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        switch (TypeDeclaration.kind(info.getModifiers())) {
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnnotation() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return TypeDeclaration.kind(info.getModifiers()) == 4;
    }

    public boolean isLocal() {
        switch (this.parent.getElementType()) {
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMember() {
        return this.getDeclaringType() != null;
    }

    @Override
    public ITypeHierarchy newSupertypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        return this.newSupertypeHierarchy(DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy newSupertypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), false);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IJavaProject project, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        if (project == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullProject);
        }
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        ICompilationUnit[] projectWCs = null;
        if (workingCopies != null) {
            int length = workingCopies.length;
            projectWCs = new ICompilationUnit[length];
            int index = 0;
            int i = 0;
            while (i < length) {
                ICompilationUnit wc = workingCopies[i];
                if (project.equals(wc.getJavaProject())) {
                    projectWCs[index++] = wc;
                }
                ++i;
            }
            if (index != length) {
                ICompilationUnit[] iCompilationUnitArray = projectWCs;
                projectWCs = new ICompilationUnit[index];
                System.arraycopy(iCompilationUnitArray, 0, projectWCs, 0, index);
            }
        }
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, projectWCs, project, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public JavaElement resolved(Binding binding) {
        ResolvedSourceType resolvedHandle = new ResolvedSourceType(this.parent, this.name, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        resolvedHandle.localOccurrenceCount = this.localOccurrenceCount;
        return resolvedHandle;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            if (this.isAnonymous()) {
                buffer.append("<anonymous #");
                buffer.append(this.occurrenceCount);
                buffer.append(">");
            } else {
                this.toStringName(buffer);
            }
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            if (this.isAnonymous()) {
                buffer.append("<anonymous #");
                buffer.append(this.occurrenceCount);
                buffer.append(">");
            } else {
                this.toStringName(buffer);
            }
        } else {
            try {
                if (this.isSealed()) {
                    buffer.append("sealed ");
                }
                if (this.isRecord()) {
                    buffer.append("record ");
                } else if (this.isEnum()) {
                    buffer.append("enum ");
                } else if (this.isAnnotation()) {
                    buffer.append("@interface ");
                } else if (this.isInterface()) {
                    buffer.append("interface ");
                } else {
                    buffer.append("class ");
                }
                if (this.isAnonymous()) {
                    buffer.append("<anonymous #");
                    buffer.append(this.occurrenceCount);
                    buffer.append(">");
                } else {
                    this.toStringName(buffer);
                }
            }
            catch (JavaModelException javaModelException) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }

    public boolean isLambda() {
        return false;
    }
}

