/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.eclipse.jdt.internal.core.ModuleUpdater;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.Util;

public class SearchableEnvironment
implements IJavaSearchConstants,
IModuleAwareNameEnvironment {
    public NameLookup nameLookup;
    protected org.eclipse.jdt.core.ICompilationUnit[] workingCopies;
    protected WorkingCopyOwner owner;
    protected JavaProject project;
    protected boolean checkAccessRestrictions;
    private Map<String, IPackageFragmentRoot[]> knownModuleLocations;
    private boolean excludeTestCode;
    private ModuleUpdater moduleUpdater;
    private Map<IPackageFragmentRoot, IModuleDescription> rootToModule;
    private long timeSpentInGetModulesDeclaringPackage;
    private long timeSpentInFindTypes;

    public SearchableEnvironment(JavaProject project, org.eclipse.jdt.core.ICompilationUnit[] workingCopies, boolean excludeTestCode) throws JavaModelException {
        this.project = project;
        this.excludeTestCode = excludeTestCode;
        this.checkAccessRestrictions = !"ignore".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) || !"ignore".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.discouragedReference", true));
        this.workingCopies = workingCopies;
        this.nameLookup = project.newNameLookup(workingCopies, excludeTestCode);
        if (CompilerOptions.versionToJdkLevel(project.getOption("org.eclipse.jdt.core.compiler.compliance", true)) >= 0x350000L) {
            this.knownModuleLocations = new HashMap<String, IPackageFragmentRoot[]>();
        }
        if (CompilerOptions.versionToJdkLevel(project.getOption("org.eclipse.jdt.core.compiler.compliance", true)) >= 0x350000L) {
            IClasspathEntry[] expandedClasspath;
            this.moduleUpdater = new ModuleUpdater(project);
            if (!excludeTestCode && Arrays.stream(expandedClasspath = project.getExpandedClasspath()).anyMatch(e -> e.isTest())) {
                this.moduleUpdater.addReadUnnamedForNonEmptyClasspath(project, expandedClasspath);
            }
            IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!excludeTestCode || !entry.isTest()) {
                    this.moduleUpdater.computeModuleUpdates(entry);
                }
                ++n2;
            }
        }
    }

    public SearchableEnvironment(JavaProject project, WorkingCopyOwner owner, boolean excludeTestCode) throws JavaModelException {
        this(project, owner == null ? null : JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true), excludeTestCode);
        this.owner = owner;
    }

    protected NameEnvironmentAnswer find(String typeName, String packageName, IPackageFragmentRoot[] moduleContext) {
        block12: {
            String source;
            if (packageName == null) {
                packageName = "";
            }
            if (this.owner != null && (source = this.owner.findSource(typeName, packageName)) != null) {
                IPackageFragmentRoot moduleElement = moduleContext != null && moduleContext.length > 0 ? moduleContext[0] : null;
                BasicCompilationUnit cu = new BasicCompilationUnit(source.toCharArray(), CharOperation.splitOn('.', packageName.toCharArray()), String.valueOf(typeName) + Util.defaultJavaExtension(), moduleElement);
                return new NameEnvironmentAnswer(cu, null);
            }
            NameLookup.Answer answer = this.nameLookup.findType(typeName, packageName, false, 0x100001E, this.checkAccessRestrictions, moduleContext);
            if (answer != null) {
                if (answer.type instanceof BinaryType) {
                    try {
                        char[] moduleName = answer.module != null ? answer.module.getElementName().toCharArray() : null;
                        return new NameEnvironmentAnswer((IBinaryType)((BinaryType)answer.type).getElementInfo(), answer.restriction, moduleName);
                    }
                    catch (JavaModelException javaModelException) {}
                } else {
                    try {
                        SourceTypeElementInfo sourceType;
                        ISourceType topLevelType = sourceType = (SourceTypeElementInfo)((SourceType)answer.type).getElementInfo();
                        while (topLevelType.getEnclosingType() != null) {
                            topLevelType = topLevelType.getEnclosingType();
                        }
                        IType[] types = sourceType.getHandle().getCompilationUnit().getTypes();
                        ISourceType[] sourceTypes = new ISourceType[types.length];
                        sourceTypes[0] = sourceType;
                        int length = types.length;
                        int i = 0;
                        int index = 1;
                        while (i < length) {
                            ISourceType otherType = (ISourceType)((JavaElement)((Object)types[i])).getElementInfo();
                            if (!otherType.equals(topLevelType) && index < length) {
                                sourceTypes[index++] = otherType;
                            }
                            ++i;
                        }
                        char[] moduleName = answer.module != null ? answer.module.getElementName().toCharArray() : null;
                        return new NameEnvironmentAnswer(sourceTypes, answer.restriction, this.getExternalAnnotationPath(answer.entry), moduleName);
                    }
                    catch (JavaModelException jme) {
                        if (!jme.isDoesNotExist() || !String.valueOf(TypeConstants.PACKAGE_INFO_NAME).equals(typeName)) break block12;
                        return new NameEnvironmentAnswer((ICompilationUnit)((Object)answer.type.getParent()), answer.restriction);
                    }
                }
            }
        }
        return null;
    }

    private String getExternalAnnotationPath(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        IPath path = ClasspathEntry.getExternalAnnotationPath(entry, this.project.getProject(), true);
        if (path == null) {
            return null;
        }
        return path.toOSString();
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundTypeName, char[] moduleName) {
        if (compoundTypeName == null) {
            return null;
        }
        boolean isNamedStrategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName) == IModuleAwareNameEnvironment.LookupStrategy.Named;
        IPackageFragmentRoot[] moduleLocations = isNamedStrategy ? this.findModuleContext(moduleName) : null;
        int length = compoundTypeName.length;
        if (length <= 1) {
            if (length == 0) {
                return null;
            }
            return this.find(new String(compoundTypeName[0]), null, moduleLocations);
        }
        int lengthM1 = length - 1;
        char[][] packageName = new char[lengthM1][];
        System.arraycopy(compoundTypeName, 0, packageName, 0, lengthM1);
        return this.find(new String(compoundTypeName[lengthM1]), CharOperation.toString(packageName), moduleLocations);
    }

    @Override
    public NameEnvironmentAnswer findType(char[] name, char[][] packageName, char[] moduleName) {
        if (name == null) {
            return null;
        }
        boolean isNamedStrategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName) == IModuleAwareNameEnvironment.LookupStrategy.Named;
        IPackageFragmentRoot[] moduleLocations = isNamedStrategy ? this.findModuleContext(moduleName) : null;
        return this.find(new String(name), packageName == null || packageName.length == 0 ? null : CharOperation.toString(packageName), moduleLocations);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public char[][] getModulesDeclaringPackage(char[][] packageName, char[] moduleName) {
        start = -1L;
        if (NameLookup.VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            pkgName = (String[])Arrays.stream(packageName).map((Function<char[], String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(char[] ), ([C)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$2(int ), (I)[Ljava/lang/String;)());
            strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
            switch (SearchableEnvironment.$SWITCH_TABLE$org$eclipse$jdt$internal$compiler$env$IModuleAwareNameEnvironment$LookupStrategy()[strategy.ordinal()]) {
                case 1: {
                    if (this.knownModuleLocations != null && (moduleContext = this.findModuleContext(moduleName)) != null && this.nameLookup.isPackage(pkgName, moduleContext)) {
                        var18_8 = new char[][]{moduleName};
                        return var18_8;
                    }
                    return null;
                }
                case 3: 
                case 4: {
                    if (this.knownModuleLocations == null) {
                        if (this.owner != null && this.owner.isPackage(pkgName) || this.nameLookup.isPackage(pkgName)) {
                            var18_9 = new char[][]{ModuleBinding.UNNAMED};
                            return var18_9;
                        }
                        return null;
                    }
                }
                case 2: {
                    names = CharOperation.NO_CHAR_CHAR;
                    matchingRoots = this.nameLookup.findPackageFragementRoots(pkgName);
                    if (matchingRoots == null) ** GOTO lbl41
                    containsUnnamed = false;
                    var13_13 = matchingRoots;
                    var12_14 = matchingRoots.length;
                    var11_15 = 0;
                    while (var11_15 < var12_14) {
                        packageRoot = var13_13[var11_15];
                        singleton = new IPackageFragmentRoot[]{packageRoot};
                        if (!strategy.matches(singleton, (Predicate<IPackageFragmentRoot[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$3(org.eclipse.jdt.core.IPackageFragmentRoot[] ), ([Lorg/eclipse/jdt/core/IPackageFragmentRoot;)Z)((SearchableEnvironment)this)) || !this.nameLookup.isPackage(pkgName, singleton)) ** GOTO lbl39
                        moduleDescription = this.getModuleDescription(singleton);
                        if (moduleDescription == null) ** GOTO lbl35
                        aName = moduleDescription.getElementName().toCharArray();
                        ** GOTO lbl38
lbl35:
                        // 1 sources

                        if (containsUnnamed) ** GOTO lbl39
                        containsUnnamed = true;
                        aName = ModuleBinding.UNNAMED;
lbl38:
                        // 2 sources

                        names = CharOperation.arrayConcat(names, aName);
lbl39:
                        // 3 sources

                        ++var11_15;
                    }
lbl41:
                    // 2 sources

                    var18_10 = names == CharOperation.NO_CHAR_CHAR ? null : names;
                    return var18_10;
                }
            }
            throw new IllegalArgumentException("Unexpected LookupStrategy " + (Object)strategy);
        }
        finally {
            if (NameLookup.VERBOSE) {
                this.timeSpentInGetModulesDeclaringPackage += System.currentTimeMillis() - start;
            }
        }
    }

    @Override
    public boolean hasCompilationUnit(char[][] pkgName, char[] moduleName, boolean checkCUs) {
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        switch (strategy) {
            case Named: {
                IPackageFragmentRoot[] moduleContext;
                return this.knownModuleLocations != null && (moduleContext = this.findModuleContext(moduleName)) != null && this.nameLookup.hasCompilationUnit(pkgName, moduleContext);
            }
            case Any: 
            case Unnamed: {
                if (this.knownModuleLocations == null && this.nameLookup.hasCompilationUnit(pkgName, null)) {
                    return true;
                }
            }
            case AnyNamed: {
                String[] splittedName = Util.toStrings(pkgName);
                IPackageFragmentRoot[] packageRoots = this.nameLookup.findPackageFragementRoots(splittedName);
                if (packageRoots != null) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = packageRoots;
                    int n = packageRoots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot packageRoot = iPackageFragmentRootArray[n2];
                        IPackageFragmentRoot[] singleton = new IPackageFragmentRoot[]{packageRoot};
                        if (strategy.matches(singleton, locs -> locs[0] instanceof JrtPackageFragmentRoot || this.getModuleDescription((IPackageFragmentRoot[])locs) != null) && this.nameLookup.hasCompilationUnit(pkgName, singleton)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected LookupStrategy " + (Object)((Object)strategy));
    }

    private IModuleDescription getModuleDescription(IPackageFragmentRoot[] roots) {
        if (this.rootToModule == null) {
            this.rootToModule = new HashMap<IPackageFragmentRoot, IModuleDescription>();
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            IModuleDescription moduleDescription = NameLookup.getModuleDescription(this.project, root, this.rootToModule, this.nameLookup.rootToResolvedEntries::get);
            if (moduleDescription != null) {
                return moduleDescription;
            }
            ++n2;
        }
        return null;
    }

    private IPackageFragmentRoot[] findModuleContext(char[] moduleName) {
        NameLookup.Answer moduleAnswer;
        IPackageFragmentRoot[] moduleContext = null;
        if (this.knownModuleLocations != null && moduleName != null && moduleName.length > 0 && (moduleContext = this.knownModuleLocations.get(String.valueOf(moduleName))) == null && (moduleAnswer = this.nameLookup.findModule(moduleName)) != null) {
            IProject currentProject = moduleAnswer.module.getJavaProject().getProject();
            IJavaElement current = moduleAnswer.module.getParent();
            block8: while (moduleContext == null && current != null) {
                switch (current.getElementType()) {
                    case 3: {
                        if (!((IPackageFragmentRoot)current).isExternal() && !(current instanceof JarPackageFragmentRoot)) {
                            current = current.getJavaProject();
                        } else {
                            moduleContext = new IPackageFragmentRoot[]{(IPackageFragmentRoot)current};
                            break;
                        }
                    }
                    case 2: {
                        try {
                            moduleContext = SearchableEnvironment.getOwnedPackageFragmentRoots((IJavaProject)current);
                        }
                        catch (JavaModelException javaModelException) {}
                        continue block8;
                    }
                    default: {
                        current = current.getParent();
                        if (current == null) continue block8;
                        try {
                            IJavaProject otherJavaProject;
                            IProject otherProject;
                            IResource resource = current.getUnderlyingResource();
                            if (resource == null || (otherProject = resource.getProject()) == null || otherProject.equals(currentProject) || !(otherJavaProject = JavaCore.create(otherProject)).exists()) continue block8;
                            moduleContext = this.getRootsForOutputLocation(otherJavaProject, resource);
                            break;
                        }
                        catch (JavaModelException e) {
                            Util.log(e, "Failed to find package fragment root for " + current);
                        }
                    }
                }
            }
            this.knownModuleLocations.put(String.valueOf(moduleName), moduleContext);
        }
        return moduleContext;
    }

    @Override
    public IModule getModule(char[] name) {
        NameLookup.Answer answer = this.nameLookup.findModule(name);
        IModule module = null;
        if (answer != null) {
            module = NameLookup.getModuleDescriptionInfo(answer.module);
        }
        return module;
    }

    @Override
    public char[][] getAllAutomaticModules() {
        return CharOperation.NO_CHAR_CHAR;
    }

    @Override
    public void applyModuleUpdates(IUpdatableModule module, IUpdatableModule.UpdateKind kind) {
        if (this.moduleUpdater != null) {
            this.moduleUpdater.applyModuleUpdates(module, kind);
        }
    }

    private IPackageFragmentRoot[] getRootsForOutputLocation(IJavaProject otherJavaProject, IResource outputLocation) throws JavaModelException {
        IClasspathEntry classpathEntry;
        int n;
        int n2;
        IClasspathEntry[] iClasspathEntryArray;
        IPath outputPath = outputLocation.getFullPath();
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        if (outputPath.equals(otherJavaProject.getOutputLocation())) {
            iClasspathEntryArray = otherJavaProject.getRawClasspath();
            n2 = iClasspathEntryArray.length;
            n = 0;
            while (n < n2) {
                classpathEntry = iClasspathEntryArray[n];
                if (classpathEntry.getOutputLocation() == null) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = otherJavaProject.findPackageFragmentRoots(classpathEntry);
                    int n3 = iPackageFragmentRootArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                        IResource rootResource = root.getResource();
                        if (rootResource != null && rootResource.getProject().equals(otherJavaProject.getProject())) {
                            result.add(root);
                        }
                        ++n4;
                    }
                }
                ++n;
            }
        }
        if (!result.isEmpty()) {
            return result.toArray(new IPackageFragmentRoot[result.size()]);
        }
        iClasspathEntryArray = otherJavaProject.getRawClasspath();
        n2 = iClasspathEntryArray.length;
        n = 0;
        while (n < n2) {
            classpathEntry = iClasspathEntryArray[n];
            if (outputPath.equals(classpathEntry.getOutputLocation())) {
                return otherJavaProject.findPackageFragmentRoots(classpathEntry);
            }
            ++n;
        }
        return null;
    }

    public static IPackageFragmentRoot[] getOwnedPackageFragmentRoots(IJavaProject javaProject) throws JavaModelException {
        IPackageFragmentRoot[] allRoots = javaProject.getPackageFragmentRoots();
        IPackageFragmentRoot[] sourceRoots = Arrays.copyOf(allRoots, allRoots.length);
        int count = 0;
        int i = 0;
        while (i < allRoots.length) {
            IResource resource;
            IPackageFragmentRoot root = allRoots[i];
            if (root.getKind() != 2 || !(root instanceof JarPackageFragmentRoot) && (resource = root.getResource()) != null && resource.getProject().equals(javaProject.getProject())) {
                sourceRoots[count++] = root;
            }
            ++i;
        }
        if (count < allRoots.length) {
            return Arrays.copyOf(sourceRoots, count);
        }
        return sourceRoots;
    }

    @Override
    public char[][] listPackages(char[] moduleName) {
        switch (IModuleAwareNameEnvironment.LookupStrategy.get(moduleName)) {
            case Named: {
                IPackageFragmentRoot[] packageRoots = this.findModuleContext(moduleName);
                HashSet<String> packages = new HashSet<String>();
                IPackageFragmentRoot[] iPackageFragmentRootArray = packageRoots;
                int n2 = packageRoots.length;
                int n3 = 0;
                while (n3 < n2) {
                    IPackageFragmentRoot packageRoot = iPackageFragmentRootArray[n3];
                    try {
                        IJavaElement[] iJavaElementArray = packageRoot.getChildren();
                        int n4 = iJavaElementArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            IJavaElement javaElement = iJavaElementArray[n5];
                            if (javaElement instanceof IPackageFragment && !((IPackageFragment)javaElement).isDefaultPackage()) {
                                packages.add(javaElement.getElementName());
                            }
                            ++n5;
                        }
                    }
                    catch (JavaModelException e) {
                        Util.log(e, "Failed to retrieve packages from " + packageRoot);
                    }
                    ++n3;
                }
                return (char[][])packages.stream().map(String::toCharArray).toArray(n -> new char[n][]);
            }
        }
        throw new UnsupportedOperationException("can list packages only of a named module");
    }

    public void printTimeSpent() {
        if (!NameLookup.VERBOSE) {
            return;
        }
        Util.verbose(" TIME SPENT SearchableEnvironment");
        Util.verbose(" -> getModulesDeclaringPackage..." + this.timeSpentInGetModulesDeclaringPackage + "ms");
        Util.verbose(" -> findTypes...................." + this.timeSpentInFindTypes + "ms");
        this.nameLookup.printTimeSpent();
    }

    private static /* synthetic */ String[] lambda$2(int n) {
        return new String[n];
    }

    private /* synthetic */ boolean lambda$3(IPackageFragmentRoot[] locs) {
        return locs[0] instanceof JrtPackageFragmentRoot || this.getModuleDescription(locs) != null;
    }
}

