/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.ASTHolderCUInfo;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.CompilationUnitProblemFinder;
import org.eclipse.jdt.internal.core.CompilationUnitStructureRequestor;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.ImportContainer;
import org.eclipse.jdt.internal.core.ImportContainerInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageDeclaration;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceModule;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class CompilationUnit
extends Openable
implements org.eclipse.jdt.core.ICompilationUnit,
ICompilationUnit,
SuffixConstants {
    private static final IImportDeclaration[] NO_IMPORTS = new IImportDeclaration[0];
    protected String name;
    public WorkingCopyOwner owner;

    public CompilationUnit(PackageFragment parent, String name, WorkingCopyOwner owner) {
        super(parent);
        this.name = name;
        this.owner = owner;
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        HashMap problems;
        int reconcileFlags;
        boolean resolveBindings;
        boolean createAST;
        CompilationUnitElementInfo unitInfo = (CompilationUnitElementInfo)info;
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        if (buffer == null) {
            this.openBuffer(pm, unitInfo);
        }
        CompilationUnitStructureRequestor requestor = new CompilationUnitStructureRequestor(this, unitInfo, newElements);
        JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = this.getPerWorkingCopyInfo();
        IJavaProject project = this.getJavaProject();
        if (info instanceof ASTHolderCUInfo) {
            ASTHolderCUInfo astHolder = (ASTHolderCUInfo)info;
            createAST = astHolder.astLevel != 0;
            resolveBindings = astHolder.resolveBindings;
            reconcileFlags = astHolder.reconcileFlags;
            problems = astHolder.problems;
        } else {
            createAST = false;
            resolveBindings = false;
            reconcileFlags = 0;
            problems = null;
        }
        boolean computeProblems = perWorkingCopyInfo != null && perWorkingCopyInfo.isActive() && project != null && JavaProject.hasJavaNature(project.getProject());
        DefaultProblemFactory problemFactory = new DefaultProblemFactory();
        Map<String, String> options = this.getOptions(true);
        if (!computeProblems) {
            options.put("org.eclipse.jdt.core.compiler.taskTags", "");
        }
        CompilerOptions compilerOptions = new CompilerOptions(options);
        compilerOptions.ignoreMethodBodies = (reconcileFlags & 8) != 0;
        SourceElementParser parser = new SourceElementParser(requestor, problemFactory, compilerOptions, true, !createAST);
        parser.reportOnlyOneSyntaxError = !computeProblems;
        parser.setMethodsFullRecovery(true);
        parser.setStatementsRecovery((reconcileFlags & 2) != 0);
        if (!(computeProblems || resolveBindings || createAST)) {
            parser.javadocParser.checkDocComment = false;
        }
        requestor.parser = parser;
        if (underlyingResource == null) {
            underlyingResource = this.getResource();
        }
        if (underlyingResource != null) {
            unitInfo.timestamp = ((IFile)underlyingResource).getModificationStamp();
        }
        CompilationUnitDeclaration compilationUnitDeclaration = null;
        CompilationUnit source = this.cloneCachingContents();
        try {
            if (computeProblems) {
                if (problems == null) {
                    problems = new HashMap();
                    compilationUnitDeclaration = CompilationUnitProblemFinder.process(source, parser, this.owner, problems, createAST, reconcileFlags, pm);
                    try {
                        perWorkingCopyInfo.beginReporting();
                        for (CategorizedProblem[] categorizedProblems : problems.values()) {
                            if (categorizedProblems == null) continue;
                            int i = 0;
                            int length = categorizedProblems.length;
                            while (i < length) {
                                perWorkingCopyInfo.acceptProblem(categorizedProblems[i]);
                                ++i;
                            }
                        }
                    }
                    finally {
                        perWorkingCopyInfo.endReporting();
                    }
                } else {
                    compilationUnitDeclaration = CompilationUnitProblemFinder.process(source, parser, this.owner, problems, createAST, reconcileFlags, pm);
                }
            } else {
                compilationUnitDeclaration = parser.parseCompilationUnit(source, true, pm);
            }
            if (createAST) {
                org.eclipse.jdt.core.dom.CompilationUnit cu;
                int astLevel = ((ASTHolderCUInfo)info).astLevel;
                ((ASTHolderCUInfo)info).ast = cu = AST.convertCompilationUnit(astLevel, compilationUnitDeclaration, options, computeProblems, source, reconcileFlags, pm);
            }
        }
        finally {
            if (compilationUnitDeclaration != null) {
                unitInfo.hasFunctionalTypes = compilationUnitDeclaration.hasFunctionalTypes();
                compilationUnitDeclaration.cleanUp();
            }
        }
        return unitInfo.isStructureKnown();
    }

    public CompilationUnit cloneCachingContents() {
        return new CompilationUnit((PackageFragment)this.parent, this.name, this.owner){
            private char[] cachedContents;

            @Override
            public char[] getContents() {
                if (this.cachedContents == null) {
                    this.cachedContents = CompilationUnit.this.getContents();
                }
                return this.cachedContents;
            }

            @Override
            public CompilationUnit originalFromClone() {
                return CompilationUnit.this;
            }
        };
    }

    @Override
    public boolean canBeRemovedFromCache() {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBeRemovedFromCache();
    }

    @Override
    public boolean canBufferBeRemovedFromCache(IBuffer buffer) {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBufferBeRemovedFromCache(buffer);
    }

    @Override
    public void close() throws JavaModelException {
        if (this.getPerWorkingCopyInfo() != null) {
            return;
        }
        super.close();
    }

    @Override
    protected void closing(Object info) {
        if (this.getPerWorkingCopyInfo() == null) {
            super.closing(info);
        }
    }

    @Override
    protected Object createElementInfo() {
        return new CompilationUnitElementInfo();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CompilationUnit)) {
            return false;
        }
        CompilationUnit other = (CompilationUnit)obj;
        return this.owner.equals(other.owner) && super.equals(obj);
    }

    @Override
    public IType findPrimaryType() {
        String typeName = Util.getNameWithoutJavaLikeExtension(this.getElementName());
        IType primaryType = this.getType(typeName);
        if (primaryType.exists()) {
            return primaryType;
        }
        return null;
    }

    @Override
    public org.eclipse.jdt.core.ICompilationUnit getCompilationUnit() {
        return this;
    }

    @Override
    public char[] getContents() {
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        char[] contents = null;
        if (buffer != null) {
            contents = buffer.getCharacters();
        }
        if (buffer == null || !this.isWorkingCopy() && contents == null && buffer.isClosed()) {
            String encoding;
            IFile file = (IFile)this.getResource();
            try {
                encoding = file.getCharset();
            }
            catch (CoreException coreException) {
                encoding = null;
            }
            try {
                return Util.getResourceContentsAsCharArray(file, encoding);
            }
            catch (JavaModelException e) {
                if (JavaModelManager.getJavaModelManager().abortOnMissingSource.get() == Boolean.TRUE) {
                    IOException ioException = e.getJavaModelStatus().getCode() == 985 ? (IOException)e.getException() : new IOException(e.getMessage());
                    throw new AbortCompilationUnit(null, ioException, encoding);
                }
                Util.log(e, Messages.bind(Messages.file_notFound, file.getFullPath().toString()));
                return CharOperation.NO_CHAR;
            }
        }
        if (contents == null) {
            if (JavaModelManager.getJavaModelManager().abortOnMissingSource.get() == Boolean.TRUE) {
                String encoding;
                IOException ioException = new IOException(Messages.buffer_closed);
                IFile file = (IFile)this.getResource();
                try {
                    encoding = file.getCharset();
                }
                catch (CoreException coreException) {
                    encoding = null;
                }
                throw new AbortCompilationUnit(null, ioException, encoding);
            }
            return CharOperation.NO_CHAR;
        }
        return contents;
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 5;
    }

    @Override
    public char[] getFileName() {
        return this.getPath().toString().toCharArray();
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '#': {
                JavaElement container = (JavaElement)((Object)this.getImportContainer());
                return container.getHandleFromMemento(token, memento, workingCopyOwner);
            }
            case '%': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String pkgName = memento.nextToken();
                JavaElement pkgDecl = (JavaElement)((Object)this.getPackageDeclaration(pkgName));
                return pkgDecl.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '[': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeName = memento.nextToken();
                JavaElement type = (JavaElement)((Object)this.getType(typeName));
                return type.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '`': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String modName = memento.nextToken();
                SourceModule mod = new SourceModule(this, modName);
                return mod.getHandleFromMemento(memento, workingCopyOwner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '{';
    }

    @Override
    public IImportContainer getImportContainer() {
        return new ImportContainer(this);
    }

    @Override
    public IImportDeclaration[] getImports() throws JavaModelException {
        IImportContainer container = this.getImportContainer();
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Object info = manager.getInfo(container);
        if (info == null) {
            if (manager.getInfo(this) != null) {
                return NO_IMPORTS;
            }
            this.open(null);
            info = manager.getInfo(container);
            if (info == null) {
                return NO_IMPORTS;
            }
        }
        IJavaElement[] elements = ((ImportContainerInfo)info).children;
        int length = elements.length;
        IImportDeclaration[] imports = new IImportDeclaration[length];
        System.arraycopy(elements, 0, imports, 0, length);
        return imports;
    }

    @Override
    public char[] getMainTypeName() {
        return Util.getNameWithoutJavaLikeExtension(this.getElementName()).toCharArray();
    }

    @Override
    public WorkingCopyOwner getOwner() {
        return this.isPrimary() || !this.isWorkingCopy() ? null : this.owner;
    }

    public IPackageDeclaration getPackageDeclaration(String pkg) {
        return new PackageDeclaration(this, pkg);
    }

    @Override
    public IPackageDeclaration[] getPackageDeclarations() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(11);
        IPackageDeclaration[] array = new IPackageDeclaration[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public char[][] getPackageName() {
        PackageFragment packageFragment = (PackageFragment)this.getParent();
        if (packageFragment == null) {
            return CharOperation.NO_CHAR_CHAR;
        }
        return Util.toCharArrays(packageFragment.names);
    }

    @Override
    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return new Path(this.getElementName());
        }
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    public JavaModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        return JavaModelManager.getJavaModelManager().getPerWorkingCopyInfo(this, false, false, null);
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        if (root == null) {
            return null;
        }
        return ((IContainer)((Openable)this.parent).resource(root)).getFile(new Path(this.getElementName()));
    }

    @Override
    public String getSource() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return "";
        }
        return buffer.getContents();
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        return ((CompilationUnitElementInfo)this.getElementInfo()).getSourceRange();
    }

    @Override
    public IType getType(String typeName) {
        return new SourceType(this, typeName);
    }

    @Override
    public IType[] getTypes() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IResource getUnderlyingResource() throws JavaModelException {
        if (this.isWorkingCopy() && !this.isPrimary()) {
            return null;
        }
        return super.getUnderlyingResource();
    }

    @Override
    protected boolean hasBuffer() {
        return true;
    }

    public boolean hasResourceChanged() {
        if (!this.isWorkingCopy()) {
            return false;
        }
        Object info = JavaModelManager.getJavaModelManager().getInfo(this);
        if (info == null) {
            return false;
        }
        IResource resource = this.getResource();
        if (resource == null) {
            return false;
        }
        return ((CompilationUnitElementInfo)info).timestamp != resource.getModificationStamp();
    }

    @Override
    public boolean ignoreOptionalProblems() {
        return this.getPackageFragmentRoot().ignoreOptionalProblems();
    }

    @Override
    public boolean isConsistent() {
        return !JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().contains(this);
    }

    public boolean isPrimary() {
        return this.owner == DefaultWorkingCopyOwner.PRIMARY;
    }

    protected IStatus validateCompilationUnit(IResource resource) {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        try {
            if (root.getKind() != 1) {
                return new JavaModelStatus(967, root);
            }
        }
        catch (JavaModelException e) {
            return e.getJavaModelStatus();
        }
        if (resource != null) {
            char[][] exclusionPatterns;
            char[][] inclusionPatterns = root.fullInclusionPatternChars();
            if (Util.isExcluded(resource, inclusionPatterns, exclusionPatterns = root.fullExclusionPatternChars())) {
                return new JavaModelStatus(1006, this);
            }
            if (!resource.isAccessible()) {
                return new JavaModelStatus(969, this);
            }
        }
        IJavaProject project = this.getJavaProject();
        return JavaConventions.validateCompilationUnitName(this.getElementName(), project.getOption("org.eclipse.jdt.core.compiler.source", true), project.getOption("org.eclipse.jdt.core.compiler.compliance", true));
    }

    @Override
    public boolean isWorkingCopy() {
        return !this.isPrimary() || this.getPerWorkingCopyInfo() != null;
    }

    public org.eclipse.jdt.core.dom.CompilationUnit makeConsistent(int astLevel, boolean resolveBindings, int reconcileFlags, HashMap problems, IProgressMonitor monitor) throws JavaModelException {
        if (this.isConsistent()) {
            return null;
        }
        try {
            JavaModelManager.getJavaModelManager().abortOnMissingSource.set(Boolean.TRUE);
            if (astLevel != 0 || problems != null) {
                ASTHolderCUInfo info = new ASTHolderCUInfo();
                info.astLevel = astLevel;
                info.resolveBindings = resolveBindings;
                info.reconcileFlags = reconcileFlags;
                info.problems = problems;
                this.openWhenClosed(info, true, monitor);
                org.eclipse.jdt.core.dom.CompilationUnit result = info.ast;
                info.ast = null;
                org.eclipse.jdt.core.dom.CompilationUnit compilationUnit = result;
                return compilationUnit;
            }
            this.openWhenClosed(this.createElementInfo(), true, monitor);
            return null;
        }
        finally {
            JavaModelManager.getJavaModelManager().abortOnMissingSource.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        IBuffer existingBuffer;
        IBuffer buffer;
        BufferManager bufManager = this.getBufferManager();
        boolean isWorkingCopy = this.isWorkingCopy();
        IBuffer iBuffer = buffer = isWorkingCopy ? this.owner.createBuffer(this) : BufferManager.createBuffer(this);
        if (buffer == null) {
            return null;
        }
        CompilationUnit original = null;
        boolean mustSetToOriginalContent = false;
        if (isWorkingCopy) {
            mustSetToOriginalContent = !this.isPrimary() && (original = new CompilationUnit((PackageFragment)this.getParent(), this.getElementName(), DefaultWorkingCopyOwner.PRIMARY)).isOpen();
        }
        BufferManager bufferManager = bufManager;
        synchronized (bufferManager) {
            existingBuffer = bufManager.getBuffer(this);
            if (existingBuffer == null) {
                if (buffer.getCharacters() == null) {
                    if (isWorkingCopy) {
                        if (mustSetToOriginalContent) {
                            buffer.setContents(original.getSource());
                        } else {
                            IFile file = (IFile)this.getResource();
                            if (file == null || !file.exists()) {
                                buffer.setContents(CharOperation.NO_CHAR);
                            } else {
                                buffer.setContents(Util.getResourceContentsAsCharArray(file));
                            }
                        }
                    } else {
                        IFile file = (IFile)this.getResource();
                        if (file == null || !file.exists()) {
                            throw this.newNotPresentException();
                        }
                        buffer.setContents(Util.getResourceContentsAsCharArray(file));
                    }
                }
                bufManager.addBuffer(buffer);
                buffer.addBufferChangedListener(this);
            }
        }
        if (existingBuffer != null) {
            buffer.close();
            return existingBuffer;
        }
        return buffer;
    }

    @Override
    protected void openAncestors(HashMap newElements, IProgressMonitor monitor) throws JavaModelException {
        if (!this.isWorkingCopy()) {
            super.openAncestors(newElements, monitor);
        }
    }

    public CompilationUnit originalFromClone() {
        return this;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        if (!this.isPrimary()) {
            buffer.append(this.tabString(tab));
            buffer.append("[Working copy] ");
            this.toStringName(buffer);
        } else if (this.isWorkingCopy()) {
            buffer.append(this.tabString(tab));
            buffer.append("[Working copy] ");
            this.toStringName(buffer);
            if (info == null) {
                buffer.append(" (not open)");
            }
        } else {
            super.toStringInfo(tab, buffer, info, showResolvedInfo);
        }
    }

    @Override
    protected IStatus validateExistence(IResource underlyingResource) {
        IStatus status;
        if (!this.isWorkingCopy() && !(status = this.validateCompilationUnit(underlyingResource)).isOK()) {
            return status;
        }
        if (!this.isPrimary() && this.getPerWorkingCopyInfo() == null) {
            return this.newDoesNotExistStatus();
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    @Override
    public ISourceRange getNameRange() {
        return null;
    }

    @Override
    public IModuleDescription getModule() throws JavaModelException {
        if ("module-info.java".equals(this.getElementName())) {
            return ((CompilationUnitElementInfo)this.getElementInfo()).getModule();
        }
        return null;
    }

    @Override
    public char[] getModuleName() {
        try {
            IModuleDescription module = this.getModule();
            if (module == null) {
                JavaProject project = (JavaProject)this.getAncestor(2);
                module = project.getModuleDescription();
            }
            if (module != null) {
                return module.getElementName().toCharArray();
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Map<String, String> getCustomOptions() {
        try {
            Map<String, String> customOptions = this.getCompilationUnitElementInfo().getCustomOptions();
            return customOptions == null ? Collections.emptyMap() : customOptions;
        }
        catch (JavaModelException javaModelException) {
            return Collections.emptyMap();
        }
    }

    private CompilationUnitElementInfo getCompilationUnitElementInfo() throws JavaModelException {
        return (CompilationUnitElementInfo)this.getElementInfo();
    }
}

