/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.ClassFileInfo;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class AbstractClassFile
extends Openable
implements IClassFile,
SuffixConstants {
    protected String name;

    protected AbstractClassFile(PackageFragment parent, String nameWithoutExtension) {
        super(parent);
        this.name = nameWithoutExtension;
    }

    @Override
    protected Object createElementInfo() {
        return new ClassFileInfo();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AbstractClassFile)) {
            return false;
        }
        AbstractClassFile other = (AbstractClassFile)o;
        return this.name.equals(other.name) && this.parent.equals(other.parent);
    }

    protected byte[] getClassFileContent(JarPackageFragmentRoot root, String className) throws CoreException, IOException {
        byte[] contents = null;
        String rootPath = root.getPath().toOSString();
        if (org.eclipse.jdt.internal.compiler.util.Util.isJrt(rootPath)) {
            contents = JRTUtil.getClassfileContent(new File(rootPath), className, root.getElementName());
        } else {
            ZipFile zip = root.getJar();
            try {
                ZipEntry ze = zip.getEntry(className);
                if (ze != null) {
                    contents = org.eclipse.jdt.internal.compiler.util.Util.getZipEntryByteContent(ze, zip);
                }
            }
            finally {
                JavaModelManager.getJavaModelManager().closeZipFile(zip);
            }
        }
        if (contents == null && Thread.interrupted()) {
            throw new OperationCanceledException();
        }
        return contents;
    }

    @Override
    public IBuffer getBuffer() throws JavaModelException {
        IStatus status = this.validateClassFile();
        if (status.isOK()) {
            return super.getBuffer();
        }
        switch (status.getCode()) {
            case 967: 
            case 1006: {
                return null;
            }
        }
        throw new JavaModelException(status);
    }

    @Override
    public String getElementName() {
        return String.valueOf(this.name) + ".class";
    }

    @Override
    public int getElementType() {
        return 6;
    }

    @Override
    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        return ((IContainer)((Openable)this.parent).resource(root)).getFile(new Path(this.getElementName()));
    }

    @Override
    public String getSource() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return null;
        }
        return buffer.getContents();
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer != null) {
            String contents = buffer.getContents();
            if (contents == null) {
                return null;
            }
            return new SourceRange(0, contents.length());
        }
        return null;
    }

    @Override
    protected boolean hasBuffer() {
        return true;
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(this.name.hashCode(), this.parent.hashCode());
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    private IStatus validateClassFile() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        try {
            if (root.getKind() != 2) {
                return new JavaModelStatus(967, root);
            }
        }
        catch (JavaModelException e) {
            return e.getJavaModelStatus();
        }
        IJavaProject project = this.getJavaProject();
        return JavaConventions.validateClassFileName(this.getElementName(), project.getOption("org.eclipse.jdt.core.compiler.source", true), project.getOption("org.eclipse.jdt.core.compiler.compliance", true));
    }

    @Override
    protected IStatus validateExistence(IResource underlyingResource) {
        IStatus status = this.validateClassFile();
        if (!status.isOK()) {
            return status;
        }
        if (underlyingResource != null) {
            PackageFragmentRoot root;
            if (!underlyingResource.isAccessible()) {
                return this.newDoesNotExistStatus();
            }
            if (underlyingResource instanceof IFolder && (root = this.getPackageFragmentRoot()).isArchive()) {
                return root.newDoesNotExistStatus();
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    @Override
    public ISourceRange getNameRange() {
        return null;
    }
}

