/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.search;

import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchScope;

public abstract class SearchPattern {
    private int matchRule;
    public IJavaElement focus;
    public int kind;
    public boolean mustResolve = true;

    public SearchPattern(int matchRule) {
        this.matchRule = matchRule;
        if ((matchRule & 0x30) == 0) {
            this.matchRule |= 0x40;
        }
        if ((matchRule & 0x80) != 0) {
            this.matchRule &= 0xFFFFFEFF;
            this.matchRule &= 0xFFFFFFFE;
        } else if ((matchRule & 0x100) != 0) {
            this.matchRule &= 0xFFFFFFFE;
        }
    }

    public void acceptMatch(String relativePath, String containerPath, char separator, SearchPattern pattern, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor monitor) {
        if (scope instanceof JavaSearchScope) {
            JavaSearchScope javaSearchScope = (JavaSearchScope)scope;
            AccessRuleSet access = javaSearchScope.getAccessRuleSet(relativePath, containerPath);
            if (access != JavaSearchScope.NOT_ENCLOSED) {
                StringBuffer documentPath = new StringBuffer(containerPath.length() + 1 + relativePath.length());
                documentPath.append(containerPath);
                documentPath.append(separator);
                documentPath.append(relativePath);
                if (!requestor.acceptIndexMatch(documentPath.toString(), pattern, participant, access)) {
                    throw new OperationCanceledException();
                }
            }
        } else {
            boolean encloses;
            StringBuffer buffer = new StringBuffer(containerPath.length() + 1 + relativePath.length());
            buffer.append(containerPath);
            buffer.append(separator);
            buffer.append(relativePath);
            String documentPath = buffer.toString();
            boolean bl = encloses = scope instanceof HierarchyScope ? ((HierarchyScope)scope).encloses(documentPath, monitor) : scope.encloses(documentPath);
            if (encloses && !requestor.acceptIndexMatch(documentPath, pattern, participant, null)) {
                throw new OperationCanceledException();
            }
        }
    }

    public SearchPattern currentPattern() {
        return this;
    }

    public void decodeIndexKey(char[] key) {
    }

    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor monitor) throws IOException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            index.startQuery();
            SearchPattern pattern = this.currentPattern();
            EntryResult[] entries = pattern.queryIn(index);
            if (entries == null) {
                return;
            }
            String containerPath = index.containerPath;
            char separator = index.separator;
            int i = 0;
            int l = entries.length;
            while (i < l) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                EntryResult entry = entries[i];
                SearchPattern decodedResult = pattern.getBlankPattern();
                decodedResult.decodeIndexKey(entry.getWord());
                if (pattern.matchesDecodedKey(decodedResult)) {
                    String[] names = entry.getDocumentNames(index);
                    int j = 0;
                    int n = names.length;
                    while (j < n) {
                        this.acceptMatch(names[j], containerPath, separator, decodedResult, requestor, participant, scope, monitor);
                        ++j;
                    }
                }
                ++i;
            }
        }
        finally {
            index.stopQuery();
        }
    }

    public abstract SearchPattern getBlankPattern();

    public char[] getIndexKey() {
        return null;
    }

    public char[][] getIndexCategories() {
        return CharOperation.NO_CHAR_CHAR;
    }

    public final int getMatchRule() {
        return this.matchRule;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    public boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            boolean matchFirstChar;
            boolean emptyPattern;
            boolean isCaseSensitive = (this.matchRule & 8) != 0;
            int matchMode = this.matchRule & 0x787;
            boolean bl = emptyPattern = pattern.length == 0;
            if (emptyPattern && (this.matchRule & 1) != 0) {
                return true;
            }
            boolean sameLength = pattern.length == name.length;
            boolean canBePrefix = name.length >= pattern.length;
            boolean bl2 = matchFirstChar = !isCaseSensitive || emptyPattern || name.length > 0 && pattern[0] == name[0];
            if ((matchMode & 0x200) != 0) {
                if (CharOperation.substringMatch(pattern, name)) {
                    return true;
                }
                matchMode &= 0xFFFFFDFF;
            }
            if ((matchMode & 0x400) != 0) {
                if (CharOperation.subWordMatch(pattern, name)) {
                    return true;
                }
                matchMode &= 0xFFFFFBFF;
            }
            switch (matchMode) {
                case 0: {
                    if (!sameLength || !matchFirstChar) break;
                    return CharOperation.equals(pattern, name, isCaseSensitive);
                }
                case 1: {
                    if (!canBePrefix || !matchFirstChar) break;
                    return CharOperation.prefixEquals(pattern, name, isCaseSensitive);
                }
                case 2: {
                    if (!isCaseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, isCaseSensitive);
                }
                case 128: {
                    if (matchFirstChar && CharOperation.camelCaseMatch(pattern, name, false)) {
                        return true;
                    }
                    if (isCaseSensitive || !matchFirstChar || !CharOperation.prefixEquals(pattern, name, false)) break;
                    return true;
                }
                case 256: {
                    return matchFirstChar && CharOperation.camelCaseMatch(pattern, name, true);
                }
                case 4: {
                    return Pattern.matches(new String(pattern), new String(name));
                }
            }
        }
        return false;
    }

    public EntryResult[] queryIn(Index index) throws IOException {
        return index.query(this.getIndexCategories(), this.getIndexKey(), this.getMatchRule());
    }

    public String toString() {
        return "SearchPattern";
    }

    public SearchPattern clone() throws CloneNotSupportedException {
        return (SearchPattern)super.clone();
    }
}

