/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.security.AccessController;
import java.util.Optional;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

public class ServiceCaller<Service> {
    final Bundle bundle;
    final Class<Service> serviceType;
    final String filter;
    volatile ReferenceAndService service;

    static int getRank(ServiceReference<?> ref) {
        Object rank = ref.getProperty("service.ranking");
        if (rank instanceof Integer) {
            return (Integer)rank;
        }
        return 0;
    }

    private BundleContext getContext() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> this.bundle.getBundleContext());
        }
        return this.bundle.getBundleContext();
    }

    public Optional<Service> current() {
        return this.trackCurrent().map(r -> r.instance);
    }

    private Optional<ReferenceAndService> trackCurrent() {
        ReferenceAndService current = this.service;
        if (current != null) {
            return Optional.of(current);
        }
        return this.getCurrent().flatMap(r -> {
            ServiceCaller serviceCaller = this;
            synchronized (serviceCaller) {
                if (this.service != null) {
                    r.unget();
                    return Optional.of(this.service);
                }
                return r.track();
            }
        });
    }

    private Optional<ReferenceAndService> getCurrent() {
        BundleContext context = this.getContext();
        return this.getServiceReference(context).map(r -> {
            Object current = context.getService(r);
            return current == null ? null : new ReferenceAndService(context, r, current);
        });
    }

    private Optional<ServiceReference<Service>> getServiceReference(BundleContext context) {
        if (context == null) {
            return Optional.empty();
        }
        if (this.filter == null) {
            return Optional.ofNullable(context.getServiceReference(this.serviceType));
        }
        try {
            return context.getServiceReferences(this.serviceType, this.filter).stream().findFirst();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return Optional.empty();
        }
    }

    class ReferenceAndService
    implements ServiceListener,
    SynchronousBundleListener {
        final BundleContext context;
        final ServiceReference<Service> ref;
        final Service instance;
        final int rank;

        public ReferenceAndService(BundleContext context, ServiceReference<Service> ref, Service instance) {
            this.context = context;
            this.ref = ref;
            this.instance = instance;
            this.rank = ServiceCaller.getRank(ref);
        }

        void unget() {
            this.untrack();
            try {
                this.context.ungetService(this.ref);
            }
            catch (IllegalStateException illegalStateException) {}
        }

        @Override
        public void bundleChanged(BundleEvent e) {
            if (ServiceCaller.this.bundle.equals(e.getBundle()) && e.getType() == 256) {
                this.unget();
            }
        }

        @Override
        public void serviceChanged(ServiceEvent e) {
            if (e.getServiceReference().equals(this.ref)) {
                if (e.getType() == 4) {
                    this.unget();
                } else if (ServiceCaller.this.filter != null && e.getType() == 8) {
                    this.unget();
                } else if (e.getType() == 2 && ServiceCaller.getRank(this.ref) != this.rank) {
                    this.unget();
                }
            } else if (e.getType() == 2 && ServiceCaller.getRank(e.getServiceReference()) > this.rank) {
                this.unget();
            }
        }

        Optional<ReferenceAndService> track() {
            try {
                ServiceCaller.this.service = this;
                this.context.addServiceListener(this, "(&(objectClass=" + ServiceCaller.this.serviceType.getName() + ")" + (ServiceCaller.this.filter == null ? "" : ServiceCaller.this.filter) + ")");
                this.context.addBundleListener(this);
                if ((this.ref.getBundle() == null || this.context.getBundle() == null) && ServiceCaller.this.service == this) {
                    this.unget();
                }
                if (ServiceCaller.getRank(this.ref) != this.rank) {
                    this.unget();
                }
            }
            catch (InvalidSyntaxException e) {
                ServiceCaller.this.service = null;
                throw new IllegalStateException(e);
            }
            catch (IllegalStateException illegalStateException) {
                ServiceCaller.this.service = null;
            }
            return Optional.of(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void untrack() {
            ServiceCaller serviceCaller = ServiceCaller.this;
            synchronized (serviceCaller) {
                if (ServiceCaller.this.service == this) {
                    ServiceCaller.this.service = null;
                }
                try {
                    this.context.removeServiceListener(this);
                    this.context.removeBundleListener(this);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }
}

