/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogEntry;

public class Log
implements ILog,
LogFilter,
SynchronousLogListener {
    final Bundle bundle;
    private final Logger logger;
    private final Set<ILogListener> logListeners = new HashSet<ILogListener>(5);

    public Log(Bundle plugin, Logger logger) {
        if (plugin == null) {
            throw new IllegalArgumentException("Logging bundle must not be null.");
        }
        this.bundle = plugin;
        this.logger = logger;
    }

    @Override
    public void log(IStatus status) {
        this.logger.log(PlatformLogWriter.getLog(status), PlatformLogWriter.getLevel(status), status.getMessage(), status.getException());
    }

    @Override
    public void logged(LogEntry entry) {
        this.logToListeners(PlatformLogWriter.convertToStatus(entry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToListeners(final IStatus status) {
        ILogListener[] listeners;
        Set<ILogListener> set = this.logListeners;
        synchronized (set) {
            listeners = this.logListeners.toArray(new ILogListener[this.logListeners.size()]);
        }
        ILogListener[] iLogListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final ILogListener listener = iLogListenerArray[n2];
            ISafeRunnable code = new ISafeRunnable(){

                @Override
                public void run() throws Exception {
                    listener.logging(status, Log.this.bundle.getSymbolicName());
                }

                @Override
                public void handleException(Throwable e) {
                }
            };
            SafeRunner.run(code);
            ++n2;
        }
    }

    @Override
    public boolean isLoggable(Bundle loggingBundle, String loggerName, int logLevel) {
        return "org.eclipse.equinox.logger".equals(loggerName) && this.bundle.getBundleId() == loggingBundle.getBundleId();
    }
}

