/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;

public final class AdapterManager
implements IAdapterManager {
    private Map<String, Map<String, IAdapterFactory>> adapterLookup;
    private Map<IAdapterFactory, Map<String, Class<?>>> classLookup;
    private final Object classLookupLock = new Object();
    private Map<Class<?>, Class<?>[]> classSearchOrderLookup;
    private final HashMap<String, List<IAdapterFactory>> factories = new HashMap(5);
    private final ArrayList<Object> lazyFactoryProviders = new ArrayList(1);
    private static final AdapterManager singleton = new AdapterManager();

    public static AdapterManager getDefault() {
        return singleton;
    }

    private AdapterManager() {
    }

    public synchronized void flushLookup() {
        this.adapterLookup = null;
        this.classLookup = null;
        this.classSearchOrderLookup = null;
    }

    public void registerFactory(IAdapterFactory factory, String adaptableType) {
        List<IAdapterFactory> list = this.factories.get(adaptableType);
        if (list == null) {
            list = new ArrayList<IAdapterFactory>(5);
            this.factories.put(adaptableType, list);
        }
        list.add(factory);
    }

    public synchronized void unregisterAdapters(IAdapterFactory factory) {
        for (List<IAdapterFactory> list : this.factories.values()) {
            list.remove(factory);
        }
        this.flushLookup();
    }
}

