/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.resources.team.TeamHook;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

class Rules
implements ILifecycleListener,
IResourceRuleFactory {
    private final ResourceRuleFactory defaultFactory = new ResourceRuleFactory(){};
    private final Map<String, IResourceRuleFactory> projectsToRules = Collections.synchronizedMap(new HashMap());
    private final TeamHook teamHook;
    private final IWorkspaceRoot root;

    Rules(Workspace workspace) {
        this.root = workspace.getRoot();
        this.teamHook = workspace.getTeamHook();
        workspace.addLifecycleListener(this);
    }

    @Override
    public ISchedulingRule buildRule() {
        return this.root;
    }

    @Override
    public ISchedulingRule copyRule(IResource source, IResource destination) {
        if (source.getType() == 8 || destination.getType() == 8) {
            return this.root;
        }
        return this.factoryFor(destination).copyRule(source, destination);
    }

    @Override
    public ISchedulingRule createRule(IResource resource) {
        if (resource.getType() == 8) {
            return this.root;
        }
        return this.factoryFor(resource).createRule(resource);
    }

    @Override
    public ISchedulingRule deleteRule(IResource resource) {
        if (resource.getType() == 8) {
            return this.root;
        }
        return this.factoryFor(resource).deleteRule(resource);
    }

    private IResourceRuleFactory factoryFor(IResource destination) {
        IResourceRuleFactory fac = this.projectsToRules.get(destination.getFullPath().segment(0));
        if (fac == null) {
            if (!destination.getProject().isAccessible()) {
                return this.defaultFactory;
            }
            fac = this.teamHook.getRuleFactory(destination.getProject());
            this.projectsToRules.put(destination.getFullPath().segment(0), fac);
        }
        return fac;
    }

    @Override
    public void handleEvent(LifecycleEvent event) {
        switch (event.kind) {
            case 1: 
            case 16: 
            case 64: {
                this.setRuleFactory((IProject)event.resource, null);
            }
        }
    }

    @Override
    public ISchedulingRule derivedRule(IResource resource) {
        return null;
    }

    @Override
    public ISchedulingRule markerRule(IResource resource) {
        return null;
    }

    @Override
    public ISchedulingRule modifyRule(IResource resource) {
        if (resource.getType() == 8) {
            return this.root;
        }
        return this.factoryFor(resource).modifyRule(resource);
    }

    @Override
    public ISchedulingRule refreshRule(IResource resource) {
        if (resource.getType() == 8) {
            return this.root;
        }
        return this.factoryFor(resource).refreshRule(resource);
    }

    void setRuleFactory(IProject project, IResourceRuleFactory factory) {
        if (factory == null) {
            this.projectsToRules.remove(project.getName());
        } else {
            this.projectsToRules.put(project.getName(), factory);
        }
    }
}

