/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Objects;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;

public class BuildConfiguration
extends PlatformObject
implements IBuildConfiguration {
    private final IProject project;
    private final String name;

    public BuildConfiguration(IProject project) {
        this(project, "");
    }

    public BuildConfiguration(IProject project, String configName) {
        this.project = project;
        this.name = configName;
    }

    public IBuildConfiguration getBuildConfig() throws CoreException {
        return this.project.getBuildConfig(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildConfiguration other = (BuildConfiguration)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.project, other.project);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.project);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.project != null) {
            result.append(this.project.getName());
        } else {
            result.append("?");
        }
        result.append(";");
        if (this.name != null) {
            result.append(" [").append(this.name).append(']');
        } else {
            result.append(" [active]");
        }
        return result.toString();
    }
}

