/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertyFilePropertySource;
import org.apache.logging.log4j.util.PropertySource;

public final class PropertiesUtil {
    private static final PropertiesUtil LOG4J_PROPERTIES = new PropertiesUtil("log4j2.component.properties");
    private final Environment environment;

    public PropertiesUtil(String propertiesFileName) {
        this.environment = new Environment(new PropertyFilePropertySource(propertiesFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadClose(InputStream in, Object source) {
        Properties props = new Properties();
        if (null != in) {
            try {
                props.load(in);
            }
            catch (IOException e) {
                LowLevelLogUtil.logException("Unable to read " + source, e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LowLevelLogUtil.logException("Unable to close " + source, e);
                }
            }
        }
        return props;
    }

    public static PropertiesUtil getProperties() {
        return LOG4J_PROPERTIES;
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    public boolean getBooleanProperty(String name, boolean defaultValueIfAbsent, boolean defaultValueIfPresent) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValueIfAbsent : (prop.isEmpty() ? defaultValueIfPresent : "true".equalsIgnoreCase(prop));
    }

    public int getIntegerProperty(String name, int defaultValue) {
        String prop = this.getStringProperty(name);
        if (prop != null) {
            try {
                return Integer.parseInt(prop);
            }
            catch (Exception ignored) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String getStringProperty(String name) {
        return this.environment.get(name);
    }

    public String getStringProperty(String name, String defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : prop;
    }

    private static class Environment {
        private final Set<PropertySource> sources = new TreeSet<PropertySource>(new PropertySource.Comparator());
        private final Map<CharSequence, String> literal = new ConcurrentHashMap<CharSequence, String>();
        private final Map<CharSequence, String> normalized = new ConcurrentHashMap<CharSequence, String>();
        private final Map<List<CharSequence>, String> tokenized = new ConcurrentHashMap<List<CharSequence>, String>();

        private Environment(PropertySource propertySource) {
            this.sources.add(propertySource);
            for (ClassLoader classLoader : LoaderUtil.getClassLoaders()) {
                try {
                    for (PropertySource source : ServiceLoader.load(PropertySource.class, classLoader)) {
                        this.sources.add(source);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.reload();
        }

        private synchronized void reload() {
            this.literal.clear();
            this.normalized.clear();
            this.tokenized.clear();
            for (final PropertySource source : this.sources) {
                source.forEach(new BiConsumer<String, String>(){

                    @Override
                    public void accept(String key, String value) {
                        if (key != null && value != null) {
                            Environment.this.literal.put(key, value);
                            List<CharSequence> tokens = PropertySource.Util.tokenize(key);
                            if (tokens.isEmpty()) {
                                Environment.this.normalized.put(source.getNormalForm(Collections.singleton(key)), value);
                            } else {
                                Environment.this.normalized.put(source.getNormalForm(tokens), value);
                                Environment.this.tokenized.put(tokens, value);
                            }
                        }
                    }
                });
            }
        }

        private static boolean hasSystemProperty(String key) {
            try {
                return System.getProperties().containsKey(key);
            }
            catch (SecurityException ignored) {
                return false;
            }
        }

        private String get(String key) {
            if (this.normalized.containsKey(key)) {
                return this.normalized.get(key);
            }
            if (this.literal.containsKey(key)) {
                return this.literal.get(key);
            }
            if (Environment.hasSystemProperty(key)) {
                return System.getProperty(key);
            }
            return this.tokenized.get(PropertySource.Util.tokenize(key));
        }
    }
}

