/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srgutils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.srgutils.IMappingBuilder;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.INamedMappingFile;

class InternalUtils {
    private static final List<String> ORDER = Arrays.asList("PK:", "CL:", "FD:", "MD:");

    static IMappingFile load(InputStream in) throws IOException {
        INamedMappingFile named = InternalUtils.loadNamed(in);
        return named.getMap(named.getNames().get(0), named.getNames().get(1));
    }

    static INamedMappingFile loadNamed(InputStream in) throws IOException {
        List<String> lines = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().filter(l -> !l.isEmpty()).collect(Collectors.toList());
        String firstLine = (String)lines.get(0);
        Iterator itr = lines.iterator();
        while (InternalUtils.stripComment(firstLine).isEmpty() && itr.hasNext()) {
            firstLine = (String)itr.next();
        }
        String test = firstLine.split(" ")[0];
        if ("PK:".equals(test) || "CL:".equals(test) || "FD:".equals(test) || "MD:".equals(test)) {
            return InternalUtils.loadSRG(InternalUtils.filter(lines)).build();
        }
        if (firstLine.contains(" -> ")) {
            return InternalUtils.loadProguard(InternalUtils.filter(lines)).build();
        }
        if (firstLine.startsWith("v1\t")) {
            return InternalUtils.loadTinyV1(lines).build();
        }
        if (firstLine.startsWith("tiny\t")) {
            return InternalUtils.loadTinyV2(lines).build();
        }
        if (firstLine.startsWith("tsrg2 ")) {
            return InternalUtils.loadTSrg2(lines).build();
        }
        return InternalUtils.loadSlimSRG(InternalUtils.filter(lines)).build();
    }

    private static List<String> filter(List<String> lines) {
        return lines.stream().map(InternalUtils::stripComment).filter(l -> !l.isEmpty()).collect(Collectors.toList());
    }

    private static IMappingBuilder loadSRG(List<String> lines) throws IOException {
        IMappingBuilder ret = IMappingBuilder.create("left", "right");
        HashMap<String, IMappingBuilder.IClass> classes = new HashMap<String, IMappingBuilder.IClass>();
        block12: for (String line : lines) {
            String[] pts = line.split(" ");
            switch (pts[0]) {
                case "PK:": {
                    ret.addPackage(pts[1], pts[2]);
                    continue block12;
                }
                case "CL:": {
                    classes.put(pts[1], ret.addClass(pts[1], pts[2]));
                    continue block12;
                }
                case "FD:": {
                    String[] right;
                    String[] left;
                    if (pts.length == 5) {
                        left = InternalUtils.rsplit(pts[1], '/', 1);
                        right = InternalUtils.rsplit(pts[3], '/', 1);
                        classes.computeIfAbsent(left[0], k -> ret.addClass(left[0], right[0])).field(left[1], right[1]).descriptor(pts[2]);
                        continue block12;
                    }
                    left = InternalUtils.rsplit(pts[1], '/', 1);
                    right = InternalUtils.rsplit(pts[2], '/', 1);
                    classes.computeIfAbsent(left[0], k -> ret.addClass(left[0], right[0])).field(left[1], right[1]).descriptor(pts[2]);
                    continue block12;
                }
                case "MD:": {
                    String[] left = InternalUtils.rsplit(pts[1], '/', 1);
                    String[] right = InternalUtils.rsplit(pts[3], '/', 1);
                    classes.computeIfAbsent(left[0], k -> ret.addClass(left[0], right[0])).method(pts[2], left[1], right[1]);
                    continue block12;
                }
            }
            throw new IOException("Invalid SRG file, Unknown type: " + line);
        }
        return ret;
    }

    private static IMappingBuilder loadProguard(List<String> lines) throws IOException {
        IMappingBuilder ret = IMappingBuilder.create("left", "right");
        IMappingBuilder.IClass cls = null;
        for (String line : lines) {
            String[] pts;
            if (!(line = line.replace('.', '/')).startsWith("    ") && line.endsWith(":")) {
                pts = line.replace('.', '/').split(" -> ");
                cls = ret.addClass(pts[0], pts[1].substring(0, pts[1].length() - 1));
                continue;
            }
            if (line.contains("(") && line.contains(")")) {
                if (cls == null) {
                    throw new IOException("Invalid PG line, missing class: " + line);
                }
                line = line.trim();
                int start = 0;
                int end = 0;
                if (line.indexOf(58) != -1) {
                    int i = line.indexOf(58);
                    int j = line.indexOf(58, i + 1);
                    start = Integer.parseInt(line.substring(0, i));
                    end = Integer.parseInt(line.substring(i + 1, j));
                    line = line.substring(j + 1);
                }
                String obf = line.split(" -> ")[1];
                String _ret = InternalUtils.toDesc(line.split(" ")[0]);
                String name = line.substring(line.indexOf(32) + 1, line.indexOf(40));
                String[] args = line.substring(line.indexOf(40) + 1, line.indexOf(41)).split(",");
                StringBuffer desc = new StringBuffer();
                desc.append('(');
                for (String arg : args) {
                    if (arg.isEmpty()) break;
                    desc.append(InternalUtils.toDesc(arg));
                }
                desc.append(')').append(_ret);
                IMappingBuilder.IMethod mtd = cls.method(desc.toString(), name, obf);
                if (start != 0) {
                    mtd.meta("start_line", Integer.toString(start));
                }
                if (end == 0) continue;
                mtd.meta("end_line", Integer.toString(end));
                continue;
            }
            if (cls == null) {
                throw new IOException("Invalid PG line, missing class: " + line);
            }
            pts = line.trim().split(" ");
            cls.field(pts[1], pts[3]).descriptor(InternalUtils.toDesc(pts[0]));
        }
        return ret;
    }

    private static IMappingBuilder loadSlimSRG(List<String> lines) throws IOException {
        IMappingBuilder ret = IMappingBuilder.create("left", "right");
        HashMap classes = new HashMap();
        lines.stream().filter(l -> l.charAt(0) != '\t').map(l -> l.split(" ")).filter(pts -> ((String[])pts).length == 2).forEach(pts -> {
            if (pts[0].endsWith("/")) {
                ret.addPackage(pts[0].substring(0, pts[0].length() - 1), pts[1].substring(0, pts[1].length() - 1));
            } else {
                classes.put(pts[0], ret.addClass(pts[0], pts[1]));
            }
        });
        IMappingBuilder.IClass cls = null;
        for (String line : lines) {
            String[] pts2 = line.split(" ");
            if (pts2[0].charAt(0) == '\t') {
                if (cls == null) {
                    throw new IOException("Invalid TSRG line, missing class: " + line);
                }
                pts2[0] = pts2[0].substring(1);
                if (pts2.length == 2) {
                    cls.field(pts2[0], pts2[1]);
                    continue;
                }
                if (pts2.length == 3) {
                    cls.method(pts2[1], pts2[0], pts2[2]);
                    continue;
                }
                throw new IOException("Invalid TSRG line, to many parts: " + line);
            }
            if (pts2.length == 2) {
                if (pts2[0].endsWith("/")) continue;
                cls = (IMappingBuilder.IClass)classes.get(pts2[0]);
                continue;
            }
            if (pts2.length == 3) {
                ((IMappingBuilder.IClass)classes.get(pts2[0])).field(pts2[1], pts2[2]);
                continue;
            }
            if (pts2.length == 4) {
                ((IMappingBuilder.IClass)classes.get(pts2[0])).method(pts2[2], pts2[1], pts2[3]);
                continue;
            }
            throw new IOException("Invalid CSRG line, to many parts: " + line);
        }
        return ret;
    }

    private static IMappingBuilder loadTSrg2(List<String> lines) throws IOException {
        String[] header = lines.get(0).split(" ");
        if (header.length < 3) {
            throw new IOException("Invalid TSrg v2 Header: " + lines.get(0));
        }
        IMappingBuilder ret = IMappingBuilder.create(Arrays.copyOfRange(header, 1, header.length));
        int nameCount = header.length - 1;
        lines.remove(0);
        IMappingBuilder.IClass cls = null;
        IMappingBuilder.IMethod mtd = null;
        for (String line : lines) {
            if (line.length() < 2) {
                throw new IOException("Invalid TSRG v2 line, too short: " + line);
            }
            String[] pts = line.split(" ");
            if (line.charAt(0) != '\t') {
                if (pts.length != nameCount) {
                    throw new IOException("Invalid TSRG v2 line: " + line);
                }
                if (pts[0].charAt(pts[0].length() - 1) == '/') {
                    for (int x = 0; x < pts.length; ++x) {
                        pts[x] = pts[x].substring(0, pts[x].length() - 1);
                    }
                    ret.addPackage(pts);
                    cls = null;
                } else {
                    cls = ret.addClass(pts);
                }
                mtd = null;
                continue;
            }
            if (line.charAt(1) == '\t') {
                if (mtd == null) {
                    throw new IOException("Invalid TSRG v2 line, missing method: " + line);
                }
                pts[0] = pts[0].substring(2);
                if (pts.length == 1 && pts[0].equals("static")) {
                    mtd.meta("is_static", "true");
                    continue;
                }
                if (pts.length == nameCount + 1) {
                    mtd.parameter(Integer.parseInt(pts[0]), Arrays.copyOfRange(pts, 1, pts.length));
                    continue;
                }
                throw new IOException("Invalid TSRG v2 line, too many parts: " + line);
            }
            if (cls == null) {
                throw new IOException("Invalid TSRG v2 line, missing class: " + line);
            }
            pts[0] = pts[0].substring(1);
            if (pts.length == nameCount) {
                cls.field(pts);
                continue;
            }
            if (pts.length == 1 + nameCount) {
                InternalUtils.swapFirst(pts);
                if (pts[0].charAt(0) == '(') {
                    mtd = cls.method(pts[0], Arrays.copyOfRange(pts, 1, pts.length));
                    continue;
                }
                mtd = null;
                cls.field(Arrays.copyOfRange(pts, 1, pts.length)).descriptor(pts[0]);
                continue;
            }
            throw new IOException("Invalid TSRG v2 line, to many parts: " + line);
        }
        return ret;
    }

    private static IMappingBuilder loadTinyV1(List<String> lines) throws IOException {
        String[] header = lines.get(0).split("\t");
        if (header.length < 3) {
            throw new IOException("Invalid Tiny v1 Header: " + lines.get(0));
        }
        IMappingBuilder ret = IMappingBuilder.create(Arrays.copyOfRange(header, 1, header.length));
        HashMap<String, IMappingBuilder.IClass> classes = new HashMap<String, IMappingBuilder.IClass>();
        int nameCount = header.length - 1;
        block10: for (int x = 1; x < lines.size(); ++x) {
            String[] line = lines.get(x).split("\t");
            switch (line[0]) {
                case "CLASS": {
                    if (line.length != nameCount + 1) {
                        throw new IOException("Invalid Tiny v1 line: #" + x + ": " + line);
                    }
                    classes.put(line[1], ret.addClass(Arrays.copyOfRange(line, 1, line.length)));
                    continue block10;
                }
                case "FIELD": {
                    if (line.length != nameCount + 3) {
                        throw new IOException("Invalid Tiny v1 line: #" + x + ": " + line);
                    }
                    classes.computeIfAbsent(line[1], k -> ret.addClass(InternalUtils.duplicate(k, nameCount))).field(Arrays.copyOfRange(line, 3, line.length)).descriptor(line[2]);
                    continue block10;
                }
                case "METHOD": {
                    if (line.length != nameCount + 3) {
                        throw new IOException("Invalid Tiny v1 line: #" + x + ": " + line);
                    }
                    classes.computeIfAbsent(line[1], k -> ret.addClass(InternalUtils.duplicate(k, nameCount))).method(line[2], Arrays.copyOfRange(line, 3, line.length));
                    continue block10;
                }
                default: {
                    throw new IOException("Invalid Tiny v1 line: #" + x + ": " + line);
                }
            }
        }
        return ret;
    }

    private static IMappingBuilder loadTinyV2(List<String> lines) throws IOException {
        String[] line;
        String[] header = lines.get(0).split("\t");
        if (header.length < 5) {
            throw new IOException("Invalid Tiny v2 Header: " + lines.get(0));
        }
        try {
            int major = Integer.parseInt(header[1]);
            int minor = Integer.parseInt(header[2]);
            if (major != 2 || minor != 0) {
                throw new IOException("Unsupported Tiny v2 version: " + lines.get(0));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid Tiny v2 Header: " + lines.get(0));
        }
        IMappingBuilder ret = IMappingBuilder.create(Arrays.copyOfRange(header, 3, header.length));
        int nameCount = header.length - 3;
        boolean escaped = false;
        HashMap<String, String> properties = new HashMap<String, String>();
        int start = 1;
        for (start = 1; start < lines.size() && (line = lines.get(start).split("\t"))[0].isEmpty(); ++start) {
            properties.put(line[1], line.length < 3 ? null : (escaped ? InternalUtils.unescapeTinyString(line[2]) : line[2]));
            if (!"escaped-names".equals(line[1])) continue;
            escaped = true;
        }
        ArrayDeque<TinyV2State> stack = new ArrayDeque<TinyV2State>();
        IMappingBuilder.IClass cls = null;
        IMappingBuilder.IField field = null;
        IMappingBuilder.IMethod method = null;
        IMappingBuilder.IParameter param = null;
        block23: for (int x = start; x < lines.size(); ++x) {
            String line2 = lines.get(x);
            int newdepth = 0;
            while (line2.charAt(newdepth) == '\t') {
                ++newdepth;
            }
            if (newdepth != 0) {
                line2 = line2.substring(newdepth);
            }
            if (newdepth != stack.size()) {
                block25: while (stack.size() != newdepth) {
                    switch ((TinyV2State)((Object)stack.pop())) {
                        case CLASS: {
                            cls = null;
                            continue block25;
                        }
                        case FIELD: {
                            field = null;
                            continue block25;
                        }
                        case METHOD: {
                            method = null;
                            continue block25;
                        }
                        case PARAMETER: {
                            param = null;
                            continue block25;
                        }
                    }
                }
            }
            String[] parts = line2.split("\t");
            if (escaped) {
                for (int y = 1; y < parts.length; ++y) {
                    parts[y] = InternalUtils.unescapeTinyString(parts[y]);
                }
            }
            switch (parts[0]) {
                case "c": {
                    if (stack.size() == 0) {
                        if (parts.length != nameCount + 1) {
                            throw new IOException("Invalid Tiny v2 line: #" + x + ": " + line2);
                        }
                        cls = ret.addClass(Arrays.copyOfRange(parts, 1, parts.length));
                        stack.push(TinyV2State.CLASS);
                        continue block23;
                    }
                    String comment = InternalUtils.unescapeTinyString(parts[1]);
                    if (method != null) {
                        method.meta("comment", comment);
                        continue block23;
                    }
                    if (field != null) {
                        field.meta("comment", comment);
                        continue block23;
                    }
                    if (cls != null) {
                        cls.meta("comment", comment);
                        continue block23;
                    }
                    if (param == null) continue block23;
                    param.meta("comment", comment);
                    continue block23;
                }
                case "f": {
                    if (parts.length != nameCount + 2 || stack.peek() != TinyV2State.CLASS) {
                        throw new IOException("Invalid Tiny v2 line: #" + x + ": " + line2);
                    }
                    field = cls.field(Arrays.copyOfRange(parts, 2, parts.length)).descriptor(parts[1]);
                    stack.push(TinyV2State.FIELD);
                    continue block23;
                }
                case "m": {
                    if (parts.length != nameCount + 2 || stack.peek() != TinyV2State.CLASS) {
                        throw new IOException("Invalid Tiny v2 line: #" + x + ": " + line2);
                    }
                    method = cls.method(parts[1], Arrays.copyOfRange(parts, 2, parts.length));
                    stack.push(TinyV2State.METHOD);
                    continue block23;
                }
                case "p": {
                    if (parts.length != nameCount + 2 || stack.peek() != TinyV2State.METHOD) {
                        throw new IOException("Invalid Tiny v2 line: #" + x + ": " + line2);
                    }
                    param = method.parameter(Integer.parseInt(parts[1]), Arrays.copyOfRange(parts, 2, parts.length));
                    stack.push(TinyV2State.PARAMETER);
                    continue block23;
                }
                case "v": {
                    continue block23;
                }
                default: {
                    throw new IOException("Invalid Tiny v2 line: #" + x + ": " + line2);
                }
            }
        }
        return ret;
    }

    private static String unescapeTinyString(String value) {
        return value.replace("\\\\", "\\").replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\0", "\u0000");
    }

    static String toDesc(String type) {
        if (type.endsWith("[]")) {
            return "[" + InternalUtils.toDesc(type.substring(0, type.length() - 2));
        }
        if (type.equals("int")) {
            return "I";
        }
        if (type.equals("void")) {
            return "V";
        }
        if (type.equals("boolean")) {
            return "Z";
        }
        if (type.equals("byte")) {
            return "B";
        }
        if (type.equals("char")) {
            return "C";
        }
        if (type.equals("short")) {
            return "S";
        }
        if (type.equals("double")) {
            return "D";
        }
        if (type.equals("float")) {
            return "F";
        }
        if (type.equals("long")) {
            return "J";
        }
        if (type.contains("/")) {
            return "L" + type + ";";
        }
        throw new RuntimeException("Invalid toDesc input: " + type);
    }

    static String toSource(String desc) {
        char first = desc.charAt(0);
        switch (first) {
            case 'I': {
                return "int";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'S': {
                return "short";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'J': {
                return "long";
            }
            case '[': {
                return InternalUtils.toSource(desc.substring(1)) + "[]";
            }
            case 'L': {
                return desc.substring(1, desc.length() - 1).replace('/', '.');
            }
        }
        throw new IllegalArgumentException("Unknown descriptor: " + desc);
    }

    static String toSource(String name, String desc) {
        StringBuilder buf = new StringBuilder();
        int endParams = desc.lastIndexOf(41);
        String ret = desc.substring(endParams + 1);
        buf.append(InternalUtils.toSource(ret)).append(' ').append(name).append('(');
        int idx = 1;
        while (idx < endParams) {
            int array = 0;
            char c = desc.charAt(idx);
            if (c == '[') {
                while (desc.charAt(idx) == '[') {
                    ++array;
                    ++idx;
                }
                c = desc.charAt(idx);
            }
            if (c == 'L') {
                int end = desc.indexOf(59, idx);
                buf.append(InternalUtils.toSource(desc.substring(idx, end + 1)));
                idx = end;
            } else {
                buf.append(InternalUtils.toSource(c + ""));
            }
            while (array-- > 0) {
                buf.append("[]");
            }
            if (++idx >= endParams) continue;
            buf.append(',');
        }
        buf.append(')');
        return buf.toString();
    }

    private static String[] rsplit(String str, char chr, int count) {
        int idx;
        ArrayList<String> pts = new ArrayList<String>();
        while ((idx = str.lastIndexOf(chr)) != -1 && count > 0) {
            pts.add(str.substring(idx + 1));
            str = str.substring(0, idx);
            --count;
        }
        pts.add(str);
        Collections.reverse(pts);
        return pts.toArray(new String[pts.size()]);
    }

    public static int compareLines(String o1, String o2) {
        String[] pt2;
        String[] pt1 = o1.split(" ");
        if (!pt1[0].equals((pt2 = o2.split(" "))[0])) {
            return ORDER.indexOf(pt1[0]) - ORDER.lastIndexOf(pt2[0]);
        }
        if ("PK:".equals(pt1[0])) {
            return o1.compareTo(o2);
        }
        if ("CL:".equals(pt1[0])) {
            return InternalUtils.compareCls(pt1[1], pt2[1]);
        }
        if ("FD:".equals(pt1[0]) || "MD:".equals(pt1[0])) {
            String[][] y = new String[][]{{pt1[1].substring(0, pt1[1].lastIndexOf(47)), pt1[1].substring(pt1[1].lastIndexOf(47) + 1)}, {pt2[1].substring(0, pt2[1].lastIndexOf(47)), pt2[1].substring(pt2[1].lastIndexOf(47) + 1)}};
            int ret = InternalUtils.compareCls(y[0][0], y[1][0]);
            if (ret != 0) {
                return ret;
            }
            return y[0][1].compareTo(y[1][1]);
        }
        return o1.compareTo(o2);
    }

    public static int compareCls(String cls1, String cls2) {
        if (cls1.indexOf(47) > 0 && cls2.indexOf(47) > 0) {
            return cls1.compareTo(cls2);
        }
        String[][] t = new String[][]{cls1.split("\\$"), cls2.split("\\$")};
        int max = Math.min(t[0].length, t[1].length);
        for (int i = 0; i < max; ++i) {
            if (t[0][i].equals(t[1][i])) continue;
            if (t[0][i].length() != t[1][i].length()) {
                return t[0][i].length() - t[1][i].length();
            }
            return t[0][i].compareTo(t[1][i]);
        }
        return Integer.compare(t[0].length, t[1].length);
    }

    public static String stripComment(String str) {
        int end;
        int idx = str.indexOf(35);
        if (idx == 0) {
            return "";
        }
        if (idx != -1) {
            str = str.substring(0, idx - 1);
        }
        for (end = str.length(); end > 1 && str.charAt(end - 1) == ' '; --end) {
        }
        return end == 0 ? "" : str.substring(0, end);
    }

    private static void swapFirst(String[] values) {
        String tmp = values[0];
        values[0] = values[1];
        values[1] = tmp;
    }

    private static String[] duplicate(String value, int count) {
        Object[] ret = new String[count];
        Arrays.fill(ret, value);
        return ret;
    }

    static void writeMeta(IMappingFile.Format format, List<String> lines, Element element, Map<String, String> meta) {
        int indent = 0;
        switch (element) {
            case PACKAGE: 
            case CLASS: {
                indent = 1;
                break;
            }
            case FIELD: 
            case METHOD: {
                indent = 2;
                break;
            }
            case PARAMETER: {
                indent = 3;
            }
        }
        switch (format) {
            case CSRG: 
            case PG: 
            case SRG: 
            case TINY1: 
            case TSRG: 
            case XSRG: {
                break;
            }
            case TINY: {
                String comment = meta.get("comment");
                if (comment == null) break;
                char[] prefix = new char[indent];
                Arrays.fill(prefix, '\t');
                lines.add(new String(prefix) + "c\t" + comment);
                break;
            }
            case TSRG2: {
                if (!meta.containsKey("is_static")) break;
                char[] prefix = new char[indent];
                Arrays.fill(prefix, '\t');
                lines.add(new String(prefix) + "static");
            }
        }
    }

    static enum Element {
        PACKAGE,
        CLASS,
        FIELD,
        METHOD,
        PARAMETER;

    }

    static enum TinyV2State {
        ROOT,
        CLASS,
        FIELD,
        METHOD,
        PARAMETER;

    }
}

