/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Util {
    public static String getTopLevelClassForFilename(String filename) {
        if ((filename = filename.replace('\\', '/')).startsWith("/")) {
            filename = filename.substring(1);
        }
        int lastSlash = filename.lastIndexOf(47);
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > lastSlash) {
            filename = filename.substring(0, lastDot);
        }
        return filename;
    }

    public static int transferTo(InputStream input, OutputStream output) throws IOException {
        int cnt;
        byte[] buf = new byte[1024];
        int total = 0;
        while ((cnt = input.read(buf)) > 0) {
            output.write(buf, 0, cnt);
            total += cnt;
        }
        return total;
    }

    public static byte[] readStream(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Util.transferTo(input, output);
        return output.toByteArray();
    }

    public static String md5(String data, Charset encoding) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(data.getBytes(encoding));
            return Util.hex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String hex(byte[] data) {
        return IntStream.range(0, data.length).collect(StringBuilder::new, (sb, i) -> new Formatter((Appendable)sb).format("%02x", data[i] & 0xFF), StringBuilder::append).toString();
    }

    public static String quote(String data) {
        if (data.indexOf(32) != -1 || data.indexOf(34) == 0) {
            data = '\"' + data.replaceAll("\"", "\\\\\"") + '\"';
        }
        return data;
    }

    public static String quote(String ... data) {
        return Arrays.stream(data).map(Util::quote).collect(Collectors.joining(" "));
    }

    public static List<String> unquote(String data, int count) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int x = 0; x < count; ++x) {
            int idx;
            if (data.charAt(0) != '\"') {
                idx = data.indexOf(32);
                if (idx == -1) break;
                ret.add(data.substring(0, idx));
                data = data.substring(idx + 1);
                continue;
            }
            idx = data.indexOf(34, 1);
            while (idx != -1 && data.charAt(idx - 1) == '\\') {
                idx = data.indexOf(34, idx + 1);
            }
            if (idx == -1 || data.charAt(idx - 1) == '\\') {
                throw new IllegalArgumentException("Improperly quoted string: " + data);
            }
            idx = data.indexOf(32, idx);
            ret.add(data.substring(1, idx - 1).replace("\\\"", "\""));
            if (idx == -1) {
                data = null;
                break;
            }
            data = data.substring(idx + 1);
        }
        if (data != null) {
            ret.add(data);
        }
        return ret;
    }
}

