/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.mixin;

import net.minecraftforge.srg2source.extract.MixinProcessor;
import net.minecraftforge.srg2source.extract.SymbolReferenceWalker;
import net.minecraftforge.srg2source.mixin.IAnnotationProcessor;
import net.minecraftforge.srg2source.mixin.MixinAnnotation;
import net.minecraftforge.srg2source.mixin.MixinInfo;
import net.minecraftforge.srg2source.range.RangeMapBuilder;
import org.eclipse.jdt.core.dom.ASTNode;

public abstract class AnnotationBase
implements IAnnotationProcessor {
    protected final MixinProcessor processor;
    protected final MixinAnnotation type;

    protected AnnotationBase(MixinProcessor processor, MixinAnnotation type) {
        this.processor = processor;
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type.getType();
    }

    protected SymbolReferenceWalker getWalker() {
        return this.processor.getWalker();
    }

    protected RangeMapBuilder getBuilder() {
        return this.processor.getBuilder();
    }

    protected String getFilename() {
        return this.getBuilder().getFilename();
    }

    protected MixinInfo getInfo(String owner) {
        return this.processor.getInfo(owner);
    }

    protected boolean error(ASTNode node, String message) {
        String error = "ERROR: " + this.getFilename() + " @ " + node.getStartPosition() + ": " + message;
        this.getWalker().error(error);
        if (this.getWalker().getExtractor().areMixinsFatal()) {
            throw new IllegalStateException(error);
        }
        return true;
    }
}

