/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.TransformList;
import cpw.mods.modlauncher.api.ITransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public final class TransformTargetLabel {
    private final Type className;
    private final String elementName;
    private final Type elementDescriptor;
    private final LabelType labelType;

    TransformTargetLabel(ITransformer.Target target) {
        this(target.getClassName(), target.getElementName(), target.getElementDescriptor(), LabelType.valueOf(target.getTargetType().name()));
    }

    private TransformTargetLabel(String className, String elementName, String elementDescriptor, LabelType labelType) {
        this.className = Type.getObjectType(className.replace('.', '/'));
        this.elementName = elementName;
        this.elementDescriptor = elementDescriptor.length() > 0 ? Type.getMethodType(elementDescriptor) : Type.VOID_TYPE;
        this.labelType = labelType;
    }

    public TransformTargetLabel(String className, String fieldName) {
        this(className, fieldName, "", LabelType.FIELD);
    }

    TransformTargetLabel(String className, String methodName, String methodDesc) {
        this(className, methodName, methodDesc, LabelType.METHOD);
    }

    public TransformTargetLabel(String className, LabelType type) {
        this(className, "", "", type);
        if (type.nodeType != ClassNode.class) {
            throw new IllegalArgumentException("Invalid type " + (Object)((Object)type) + ", must be for class!");
        }
    }

    final Type getClassName() {
        return this.className;
    }

    final LabelType getLabelType() {
        return this.labelType;
    }

    public int hashCode() {
        return Objects.hash(this.className, this.elementName, this.elementDescriptor);
    }

    public boolean equals(Object obj) {
        try {
            TransformTargetLabel tl = (TransformTargetLabel)obj;
            return Objects.equals(this.className, tl.className) && Objects.equals(this.elementName, tl.elementName) && Objects.equals(this.elementDescriptor, tl.elementDescriptor);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public String toString() {
        return "Target : " + Objects.toString((Object)this.labelType) + " {" + Objects.toString(this.className) + "} {" + Objects.toString(this.elementName) + "} {" + Objects.toString(this.elementDescriptor) + "}";
    }

    public static enum LabelType {
        FIELD(FieldNode.class),
        METHOD(MethodNode.class),
        CLASS(ClassNode.class),
        PRE_CLASS(ClassNode.class);

        private final Class<?> nodeType;
        private static final Map<String, List<LabelType>> TYPE_LOOKUP;

        private LabelType(Class<?> nodeType) {
            this.nodeType = nodeType;
        }

        public static List<LabelType> getTypeFor(java.lang.reflect.Type type) {
            return TYPE_LOOKUP.getOrDefault(type.getTypeName(), Collections.emptyList());
        }

        public Class<?> getNodeType() {
            return this.nodeType;
        }

        public <V> TransformList<V> getFromMap(EnumMap<LabelType, TransformList<?>> transformers) {
            return this.get(transformers, this.nodeType);
        }

        private <V> TransformList<V> get(EnumMap<LabelType, TransformList<?>> transformers, Class<V> type) {
            return transformers.get((Object)this);
        }

        static {
            HashMap<String, List> tmpTypes = new HashMap<String, List>();
            for (LabelType type : LabelType.values()) {
                tmpTypes.computeIfAbsent(type.nodeType.getName(), s -> new ArrayList()).add(type);
            }
            Map<String, List> unmodifiableTypes = tmpTypes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, pair -> Collections.unmodifiableList((List)pair.getValue())));
            TYPE_LOOKUP = Collections.unmodifiableMap(unmodifiableTypes);
        }
    }
}

