/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ServiceLoaderStreamUtils {
    public static <T> void parallelForEach(ServiceLoader<T> services, Consumer<T> consumer) {
        ServiceLoaderStreamUtils.forEach(services, consumer, true);
    }

    private static <T> void forEach(ServiceLoader<T> services, Consumer<T> consumer, boolean parallel) {
        StreamSupport.stream(services.spliterator(), parallel).forEach(consumer);
    }

    public static <T, U> Stream<U> map(ServiceLoader<T> services, Function<T, U> function) {
        return StreamSupport.stream(services.spliterator(), false).map(function);
    }

    public static <K, T> Map<K, T> toMap(ServiceLoader<T> services, Function<T, K> keyFunction) {
        return ServiceLoaderStreamUtils.toMap(services, keyFunction, Function.identity());
    }

    public static <K, V, T> Map<K, V> toMap(ServiceLoader<T> services, Function<T, K> keyFunction, Function<T, V> valueFunction) {
        return StreamSupport.stream(services.spliterator(), false).collect(Collectors.toMap(keyFunction, valueFunction));
    }

    public static <T> ServiceLoader<T> errorHandlingServiceLoader(Class<T> clazz, Consumer<ServiceConfigurationError> errorHandler) {
        return ServiceLoaderStreamUtils.errorHandlingServiceLoader(clazz, null, errorHandler);
    }

    public static <T> ServiceLoader<T> errorHandlingServiceLoader(Class<T> clazz, ClassLoader cl, Consumer<ServiceConfigurationError> errorHandler) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, cl);
        Iterator<T> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next();
            }
            catch (ServiceConfigurationError e) {
                errorHandler.accept(e);
            }
        }
        return serviceLoader;
    }
}

