/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.apply;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ExceptorClass {
    @Nullable
    private final Map<String, String[]> params;
    @Nullable
    private final Map<String, String[]> exceptions;

    public static Map<String, ExceptorClass> create(Path path) throws IOException {
        return ExceptorClass.create(path, StandardCharsets.UTF_8);
    }

    public static Map<String, ExceptorClass> create(Path path, Charset encoding) throws IOException {
        return ExceptorClass.create(path, encoding, null);
    }

    public static Map<String, ExceptorClass> create(Path path, Charset encoding, Map<String, ExceptorClass> parent) throws IOException {
        HashMap<String, Map> params = new HashMap<String, Map>();
        HashMap<String, Map> exceptions = new HashMap<String, Map>();
        HashSet<String> known = new HashSet<String>();
        parent.forEach((k, v) -> {
            if (v.params != null) {
                params.put((String)k, new HashMap<String, String[]>(v.params));
            }
            if (v.exceptions != null) {
                exceptions.put((String)k, new HashMap<String, String[]>(v.exceptions));
            }
            known.add((String)k);
        });
        InputStream stream = Files.newInputStream(path, new OpenOption[0]);
        Object object = null;
        try {
            List lines = new BufferedReader(new InputStreamReader(stream, encoding)).lines().collect(Collectors.toList());
            for (int x = 0; x < lines.size(); ++x) {
                String args;
                String line = ExceptorClass.stripComment((String)lines.get(x)).trim();
                if (line.isEmpty()) continue;
                int idx = line.indexOf(61);
                if (idx == -1) {
                    throw new IllegalArgumentException("Invalid Exceptor line #" + x + ": " + (String)lines.get(x));
                }
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                idx = key.indexOf(46);
                if (idx == -1 || value.isEmpty()) {
                    throw new IllegalArgumentException("Invalid Exceptor line #" + x + ": " + (String)lines.get(x));
                }
                String cls = key.substring(0, idx);
                String mtd = key.substring(idx + 1);
                idx = value.indexOf(124);
                String excps = idx == -1 ? value : value.substring(0, idx);
                String string = args = idx == -1 ? "" : value.substring(idx + 1);
                if (!excps.isEmpty()) {
                    exceptions.computeIfAbsent(cls, k -> new HashMap()).put(mtd, excps.split(","));
                }
                if (!args.isEmpty()) {
                    params.computeIfAbsent(cls, k -> new HashMap()).put(mtd, args.split(","));
                }
                known.add(cls);
            }
        }
        catch (Throwable lines) {
            object = lines;
            throw lines;
        }
        finally {
            if (stream != null) {
                if (object != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable lines) {
                        ((Throwable)object).addSuppressed(lines);
                    }
                } else {
                    stream.close();
                }
            }
        }
        HashMap<String, ExceptorClass> ret = new HashMap<String, ExceptorClass>();
        for (String cls : known) {
            ret.put(cls, new ExceptorClass((Map)params.get(cls), (Map)exceptions.get(cls)));
        }
        return ret;
    }

    private static String stripComment(String line) {
        int idx = line.indexOf(35);
        return idx == -1 ? line : line.substring(0, idx);
    }

    private ExceptorClass(Map<String, String[]> params, Map<String, String[]> exceptions) {
        this.params = params != null && !params.isEmpty() ? Collections.unmodifiableMap(params) : null;
        this.exceptions = exceptions != null && !exceptions.isEmpty() ? Collections.unmodifiableMap(exceptions) : null;
    }

    public String mapParam(String name, String desc, int index, String old) {
        String[] args = this.params.get(name + desc);
        if (args == null || index >= args.length) {
            return old;
        }
        return args[index];
    }
}

