/*
 * Srg2Source
 * Copyright (c) 2020.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation version 2.1
 * of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package net.minecraftforge.srg2source.util;

import java.util.Objects;

public class MemberInfo {
    private final String owner;
    private final String name;
    private final String desc;

    public MemberInfo(String owner, String name, String desc) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return this.desc;
    }

    @Override
    public String toString() {
        return this.owner  + '/' + this.name + this.desc;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.owner, this.name, this.desc);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        MemberInfo m = (MemberInfo)o;
        return Objects.equals(this.owner, m.owner) &&
               Objects.equals(this.name, m.name) &&
               Objects.equals(this.desc, m.desc);
    }

}
