/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type {
    public static final Type VOID_TYPE = new Type(0, "VZCBSIFJD", 0, 1);
    public static final Type BOOLEAN_TYPE = new Type(1, "VZCBSIFJD", 1, 2);
    public static final Type CHAR_TYPE = new Type(2, "VZCBSIFJD", 2, 3);
    public static final Type BYTE_TYPE = new Type(3, "VZCBSIFJD", 3, 4);
    public static final Type SHORT_TYPE = new Type(4, "VZCBSIFJD", 4, 5);
    public static final Type INT_TYPE = new Type(5, "VZCBSIFJD", 5, 6);
    public static final Type FLOAT_TYPE = new Type(6, "VZCBSIFJD", 6, 7);
    public static final Type LONG_TYPE = new Type(7, "VZCBSIFJD", 7, 8);
    public static final Type DOUBLE_TYPE = new Type(8, "VZCBSIFJD", 8, 9);
    private final int sort;
    private final String valueBuffer;
    private final int valueBegin;
    private final int valueEnd;

    private Type(int sort, String valueBuffer, int valueBegin, int valueEnd) {
        this.sort = sort;
        this.valueBuffer = valueBuffer;
        this.valueBegin = valueBegin;
        this.valueEnd = valueEnd;
    }

    public static Type getType(String typeDescriptor) {
        return Type.getType(typeDescriptor, 0, typeDescriptor.length());
    }

    public static Type getObjectType(String internalName) {
        return new Type(internalName.charAt(0) == '[' ? 9 : 12, internalName, 0, internalName.length());
    }

    public static Type getMethodType(String methodDescriptor) {
        return new Type(11, methodDescriptor, 0, methodDescriptor.length());
    }

    public static Type getType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT_TYPE;
            }
            if (clazz == Void.TYPE) {
                return VOID_TYPE;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_TYPE;
            }
            if (clazz == Byte.TYPE) {
                return BYTE_TYPE;
            }
            if (clazz == Character.TYPE) {
                return CHAR_TYPE;
            }
            if (clazz == Short.TYPE) {
                return SHORT_TYPE;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE_TYPE;
            }
            if (clazz == Float.TYPE) {
                return FLOAT_TYPE;
            }
            if (clazz == Long.TYPE) {
                return LONG_TYPE;
            }
            throw new AssertionError();
        }
        return Type.getType(Type.getDescriptor(clazz));
    }

    public static Type[] getArgumentTypes(String methodDescriptor) {
        int numArgumentTypes = 0;
        int currentOffset = 1;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) == 'L') {
                while (methodDescriptor.charAt(currentOffset++) != ';') {
                }
            }
            ++numArgumentTypes;
        }
        Type[] argumentTypes = new Type[numArgumentTypes];
        currentOffset = 1;
        int currentArgumentTypeIndex = 0;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            int currentArgumentTypeOffset = currentOffset;
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) == 'L') {
                while (methodDescriptor.charAt(currentOffset++) != ';') {
                }
            }
            argumentTypes[currentArgumentTypeIndex++] = Type.getType(methodDescriptor, currentArgumentTypeOffset, currentOffset);
        }
        return argumentTypes;
    }

    public static int getArgumentsAndReturnSizes(String methodDescriptor) {
        int argumentsSize = 1;
        int currentOffset = 1;
        char currentChar = methodDescriptor.charAt(currentOffset);
        while (currentChar != ')') {
            if (currentChar == 'J' || currentChar == 'D') {
                ++currentOffset;
                argumentsSize += 2;
            } else {
                while (methodDescriptor.charAt(currentOffset) == '[') {
                    ++currentOffset;
                }
                if (methodDescriptor.charAt(currentOffset++) == 'L') {
                    while (methodDescriptor.charAt(currentOffset++) != ';') {
                    }
                }
                ++argumentsSize;
            }
            currentChar = methodDescriptor.charAt(currentOffset);
        }
        currentChar = methodDescriptor.charAt(currentOffset + 1);
        if (currentChar == 'V') {
            return argumentsSize << 2;
        }
        int returnSize = currentChar == 'J' || currentChar == 'D' ? 2 : 1;
        return argumentsSize << 2 | returnSize;
    }

    private static Type getType(String descriptorBuffer, int descriptorBegin, int descriptorEnd) {
        switch (descriptorBuffer.charAt(descriptorBegin)) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                return new Type(9, descriptorBuffer, descriptorBegin, descriptorEnd);
            }
            case 'L': {
                return new Type(10, descriptorBuffer, descriptorBegin + 1, descriptorEnd - 1);
            }
            case '(': {
                return new Type(11, descriptorBuffer, descriptorBegin, descriptorEnd);
            }
        }
        throw new IllegalArgumentException();
    }

    public int getSort() {
        return this.sort == 12 ? 10 : this.sort;
    }

    public String getInternalName() {
        return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
    }

    public String getDescriptor() {
        if (this.sort == 10) {
            return this.valueBuffer.substring(this.valueBegin - 1, this.valueEnd + 1);
        }
        if (this.sort == 12) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('L');
            stringBuilder.append(this.valueBuffer, this.valueBegin, this.valueEnd);
            stringBuilder.append(';');
            return stringBuilder.toString();
        }
        return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
    }

    public static String getMethodDescriptor(Type returnType, Type ... argumentTypes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < argumentTypes.length; ++i) {
            argumentTypes[i].appendDescriptor(stringBuilder);
        }
        stringBuilder.append(')');
        returnType.appendDescriptor(stringBuilder);
        return stringBuilder.toString();
    }

    private void appendDescriptor(StringBuilder stringBuilder) {
        if (this.sort == 10) {
            stringBuilder.append(this.valueBuffer, this.valueBegin - 1, this.valueEnd + 1);
        } else if (this.sort == 12) {
            stringBuilder.append('L');
            stringBuilder.append(this.valueBuffer, this.valueBegin, this.valueEnd);
            stringBuilder.append(';');
        } else {
            stringBuilder.append(this.valueBuffer, this.valueBegin, this.valueEnd);
        }
    }

    public static String getInternalName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static String getDescriptor(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        Type.appendDescriptor(stringBuilder, clazz);
        return stringBuilder.toString();
    }

    private static void appendDescriptor(StringBuilder stringBuilder, Class<?> clazz) {
        Class<?> currentClass = clazz;
        while (currentClass.isArray()) {
            stringBuilder.append('[');
            currentClass = currentClass.getComponentType();
        }
        if (currentClass.isPrimitive()) {
            int descriptor;
            if (currentClass == Integer.TYPE) {
                descriptor = 73;
            } else if (currentClass == Void.TYPE) {
                descriptor = 86;
            } else if (currentClass == Boolean.TYPE) {
                descriptor = 90;
            } else if (currentClass == Byte.TYPE) {
                descriptor = 66;
            } else if (currentClass == Character.TYPE) {
                descriptor = 67;
            } else if (currentClass == Short.TYPE) {
                descriptor = 83;
            } else if (currentClass == Double.TYPE) {
                descriptor = 68;
            } else if (currentClass == Float.TYPE) {
                descriptor = 70;
            } else if (currentClass == Long.TYPE) {
                descriptor = 74;
            } else {
                throw new AssertionError();
            }
            stringBuilder.append((char)descriptor);
        } else {
            stringBuilder.append('L');
            String name = currentClass.getName();
            int nameLength = name.length();
            for (int i = 0; i < nameLength; ++i) {
                char car = name.charAt(i);
                stringBuilder.append(car == '.' ? (char)'/' : (char)car);
            }
            stringBuilder.append(';');
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Type)) {
            return false;
        }
        Type other = (Type)object;
        if ((this.sort == 12 ? 10 : this.sort) != (other.sort == 12 ? 10 : other.sort)) {
            return false;
        }
        int end = this.valueEnd;
        int begin = this.valueBegin;
        int otherEnd = other.valueEnd;
        int otherBegin = other.valueBegin;
        if (end - begin != otherEnd - otherBegin) {
            return false;
        }
        int i = begin;
        int j = otherBegin;
        while (i < end) {
            if (this.valueBuffer.charAt(i) != other.valueBuffer.charAt(j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 13 * (this.sort == 12 ? 10 : this.sort);
        if (this.sort >= 9) {
            int end = this.valueEnd;
            for (int i = this.valueBegin; i < end; ++i) {
                hashCode = 17 * (hashCode + this.valueBuffer.charAt(i));
            }
        }
        return hashCode;
    }

    public String toString() {
        return this.getDescriptor();
    }
}

