/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage.bundlefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;

public class FileBundleEntry
extends BundleEntry {
    private final File file;
    private final String name;

    public FileBundleEntry(File file, String name) {
        boolean endsInSlash;
        this.file = file;
        boolean bl = endsInSlash = name.length() > 0 && name.charAt(name.length() - 1) == '/';
        if (BundleFile.secureAction.isDirectory(file)) {
            if (!endsInSlash) {
                name = String.valueOf(name) + '/';
            }
        } else if (endsInSlash) {
            name = name.substring(0, name.length() - 1);
        }
        this.name = name;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return BundleFile.secureAction.getFileInputStream(this.file);
    }

    @Override
    public long getSize() {
        return BundleFile.secureAction.length(this.file);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTime() {
        return BundleFile.secureAction.lastModified(this.file);
    }
}

