/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;

public class MethodPattern
extends JavaSearchPattern {
    protected boolean findDeclarations = true;
    protected boolean findReferences = true;
    public char[] selector;
    public char[] declaringQualification;
    public char[] declaringSimpleName;
    public char[] declaringPackageName;
    public char[] returnQualification;
    public char[] returnSimpleName;
    public char[][] parameterQualifications;
    public char[][] parameterSimpleNames;
    public int parameterCount;
    public boolean varargs = false;
    boolean methodParameters = false;
    protected static char[][] REF_CATEGORIES = new char[][]{METHOD_REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{METHOD_REF, METHOD_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{METHOD_DECL};

    public static char[] createIndexKey(char[] selector, int argCount) {
        char[] countChars = argCount < 10 ? COUNTS[argCount] : ("/" + String.valueOf(argCount)).toCharArray();
        return CharOperation.concat(selector, countChars);
    }

    MethodPattern(int matchRule) {
        super(128, matchRule);
    }

    @Override
    public void decodeIndexKey(char[] key) {
        int last = key.length - 1;
        this.parameterCount = 0;
        this.selector = null;
        int power = 1;
        int i = last;
        while (i >= 0) {
            if (key[i] == '/') {
                this.selector = new char[i];
                System.arraycopy(key, 0, this.selector, 0, i);
                break;
            }
            this.parameterCount = i == last ? key[i] - 48 : (this.parameterCount += (power *= 10) * (key[i] - 48));
            --i;
        }
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new MethodPattern(8);
    }

    @Override
    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    @Override
    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        MethodPattern pattern = (MethodPattern)decodedPattern;
        return (this.parameterCount == pattern.parameterCount || this.parameterCount == -1 || this.varargs) && this.matchesName(this.selector, pattern.selector);
    }

    @Override
    public EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.selector;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.selector != null && this.parameterCount >= 0 && !this.varargs) {
                    key = MethodPattern.createIndexKey(this.selector, this.parameterCount);
                    break;
                }
                matchRule &= 0xFFFFFFFF;
                matchRule |= 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.parameterCount >= 0 && !this.varargs) {
                    key = MethodPattern.createIndexKey(this.selector == null ? ONE_STAR : this.selector, this.parameterCount);
                    break;
                }
                if (this.selector == null || this.selector[this.selector.length - 1] == '*') break;
                key = CharOperation.concat(this.selector, ONE_STAR, '/');
                break;
            }
            case 4: {
                break;
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "MethodCombinedPattern: " : "MethodDeclarationPattern: ");
        } else {
            output.append("MethodReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            output.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            output.append(this.declaringSimpleName).append('.');
        } else if (this.declaringQualification != null) {
            output.append("*.");
        }
        if (this.selector != null) {
            output.append(this.selector);
        } else {
            output.append("*");
        }
        output.append('(');
        if (this.parameterSimpleNames == null) {
            output.append("...");
        } else {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (i > 0) {
                    output.append(", ");
                }
                if (this.parameterQualifications[i] != null) {
                    output.append(this.parameterQualifications[i]).append('.');
                }
                if (this.parameterSimpleNames[i] == null) {
                    output.append('*');
                } else {
                    output.append(this.parameterSimpleNames[i]);
                }
                ++i;
            }
        }
        output.append(')');
        if (this.returnQualification != null) {
            output.append(" --> ").append(this.returnQualification).append('.');
        } else if (this.returnSimpleName != null) {
            output.append(" --> ");
        }
        if (this.returnSimpleName != null) {
            output.append(this.returnSimpleName);
        } else if (this.returnQualification != null) {
            output.append("*");
        }
        return super.print(output);
    }
}

