/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.eclipse.jdt.internal.core.nd.java.NdAnnotation;
import org.eclipse.jdt.internal.core.nd.java.NdConstantClass;
import org.eclipse.jdt.internal.core.nd.java.NdConstantEnum;
import org.eclipse.jdt.internal.core.nd.java.NdMethod;
import org.eclipse.jdt.internal.core.nd.java.NdMethodException;
import org.eclipse.jdt.internal.core.nd.java.NdMethodParameter;
import org.eclipse.jdt.internal.core.nd.java.NdType;
import org.eclipse.jdt.internal.core.nd.java.NdTypeArgument;
import org.eclipse.jdt.internal.core.nd.java.NdTypeBound;
import org.eclipse.jdt.internal.core.nd.java.NdTypeId;
import org.eclipse.jdt.internal.core.nd.java.NdTypeInterface;
import org.eclipse.jdt.internal.core.nd.java.NdVariable;
import org.eclipse.jdt.internal.core.util.CharArrayBuffer;

public abstract class NdTypeSignature
extends NdNode {
    public static final FieldOneToMany<NdType> SUBCLASSES;
    public static final FieldOneToMany<NdAnnotation> ANNOTATIONS_OF_THIS_TYPE;
    public static final FieldOneToMany<NdTypeInterface> IMPLEMENTATIONS;
    public static final FieldOneToMany<NdVariable> VARIABLES_OF_TYPE;
    public static final FieldOneToMany<NdConstantClass> USED_AS_CONSTANT;
    public static final FieldOneToMany<NdConstantEnum> USED_AS_ENUM_CONSTANT;
    public static final FieldOneToMany<NdTypeArgument> USED_AS_TYPE_ARGUMENT;
    public static final FieldOneToMany<NdTypeBound> USED_AS_TYPE_BOUND;
    public static final FieldOneToMany<NdMethodParameter> USED_AS_METHOD_ARGUMENT;
    public static final FieldOneToMany<NdMethodException> USED_AS_EXCEPTION;
    public static final FieldOneToMany<NdMethod> USED_AS_RETURN_TYPE;
    public static StructDef<NdTypeSignature> type;

    static {
        type = StructDef.createAbstract(NdTypeSignature.class, NdNode.type);
        SUBCLASSES = FieldOneToMany.create(type, NdType.SUPERCLASS);
        ANNOTATIONS_OF_THIS_TYPE = FieldOneToMany.create(type, NdAnnotation.ANNOTATION_TYPE);
        IMPLEMENTATIONS = FieldOneToMany.create(type, NdTypeInterface.IMPLEMENTS);
        VARIABLES_OF_TYPE = FieldOneToMany.create(type, NdVariable.TYPE);
        USED_AS_CONSTANT = FieldOneToMany.create(type, NdConstantClass.VALUE);
        USED_AS_ENUM_CONSTANT = FieldOneToMany.create(type, NdConstantEnum.ENUM_TYPE);
        USED_AS_TYPE_ARGUMENT = FieldOneToMany.create(type, NdTypeArgument.TYPE_SIGNATURE);
        USED_AS_TYPE_BOUND = FieldOneToMany.create(type, NdTypeBound.TYPE);
        USED_AS_METHOD_ARGUMENT = FieldOneToMany.create(type, NdMethodParameter.ARGUMENT_TYPE);
        USED_AS_EXCEPTION = FieldOneToMany.create(type, NdMethodException.EXCEPTION_TYPE);
        USED_AS_RETURN_TYPE = FieldOneToMany.create(type, NdMethod.RETURN_TYPE);
        type.useStandardRefCounting().done();
    }

    public NdTypeSignature(Nd nd) {
        super(nd);
    }

    public List<NdType> getSubclasses() {
        return SUBCLASSES.asList(this.getNd(), this.address);
    }

    public List<NdTypeInterface> getImplementations() {
        return IMPLEMENTATIONS.asList(this.getNd(), this.address);
    }

    public List<NdType> getSubTypes() {
        ArrayList<NdType> result = new ArrayList<NdType>();
        result.addAll(this.getSubclasses());
        for (NdTypeInterface next : this.getImplementations()) {
            result.add(next.getImplementation());
        }
        return result;
    }

    public abstract NdTypeId getRawType();

    public final void getSignature(CharArrayBuffer result) {
        this.getSignature(result, true);
    }

    public abstract void getSignature(CharArrayBuffer var1, boolean var2);

    public String toString() {
        try {
            CharArrayBuffer result = new CharArrayBuffer();
            this.getSignature(result);
            return result.toString();
        }
        catch (RuntimeException runtimeException) {
            return super.toString();
        }
    }
}

