/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.indexer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ClassSignature;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.indexer.GenericSignatures;
import org.eclipse.jdt.internal.core.nd.indexer.Package;
import org.eclipse.jdt.internal.core.nd.java.JavaIndex;
import org.eclipse.jdt.internal.core.nd.java.JavaNames;
import org.eclipse.jdt.internal.core.nd.java.NdAnnotation;
import org.eclipse.jdt.internal.core.nd.java.NdAnnotationValuePair;
import org.eclipse.jdt.internal.core.nd.java.NdBinding;
import org.eclipse.jdt.internal.core.nd.java.NdComplexTypeSignature;
import org.eclipse.jdt.internal.core.nd.java.NdConstant;
import org.eclipse.jdt.internal.core.nd.java.NdConstantAnnotation;
import org.eclipse.jdt.internal.core.nd.java.NdConstantArray;
import org.eclipse.jdt.internal.core.nd.java.NdConstantClass;
import org.eclipse.jdt.internal.core.nd.java.NdConstantEnum;
import org.eclipse.jdt.internal.core.nd.java.NdMethod;
import org.eclipse.jdt.internal.core.nd.java.NdMethodParameter;
import org.eclipse.jdt.internal.core.nd.java.NdResourceFile;
import org.eclipse.jdt.internal.core.nd.java.NdType;
import org.eclipse.jdt.internal.core.nd.java.NdTypeAnnotation;
import org.eclipse.jdt.internal.core.nd.java.NdTypeArgument;
import org.eclipse.jdt.internal.core.nd.java.NdTypeId;
import org.eclipse.jdt.internal.core.nd.java.NdTypeInterface;
import org.eclipse.jdt.internal.core.nd.java.NdTypeParameter;
import org.eclipse.jdt.internal.core.nd.java.NdTypeSignature;
import org.eclipse.jdt.internal.core.nd.java.NdVariable;
import org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;
import org.eclipse.jdt.internal.core.util.CharArrayBuffer;

public final class ClassFileToIndexConverter {
    private static final char[] JAVA_LANG_OBJECT_FIELD_DESCRIPTOR = "Ljava/lang/Object;".toCharArray();
    private static final char[] INNER_TYPE_SEPARATOR = new char[]{'$'};
    private static final char[] FIELD_DESCRIPTOR_SUFFIX = new char[]{';'};
    private static final char[] COMMA = new char[]{','};
    private static final char[][] EMPTY_CHAR_ARRAY_ARRAY = new char[0][];
    static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final char[] PATH_SEPARATOR = new char[]{'/'};
    private static final char[] ARRAY_FIELD_DESCRIPTOR_PREFIX = new char[]{'['};
    private NdResourceFile resource;
    private JavaIndex index;

    public ClassFileToIndexConverter(NdResourceFile resourceFile) {
        this.resource = resourceFile;
        this.index = JavaIndex.getIndex(resourceFile.getNd());
    }

    private Nd getNd() {
        return this.resource.getNd();
    }

    public NdType addType(IBinaryType binaryType, char[] fieldDescriptor, IProgressMonitor monitor) throws CoreException {
        IBinaryMethod[] methods;
        char[][] interfaces;
        IBinaryTypeAnnotation[] typeAnnotations;
        char[] fieldDescriptorFromClass = JavaNames.binaryNameToFieldDescriptor(binaryType.getName());
        this.logInfo("adding binary type " + new String(fieldDescriptor));
        NdTypeId name = this.createTypeIdFromFieldDescriptor(fieldDescriptor);
        NdType type = name.findTypeByResourceAddress(this.resource.address);
        if (type == null) {
            type = new NdType(this.getNd(), this.resource);
        }
        if ((typeAnnotations = binaryType.getTypeAnnotations()) != null) {
            type.allocateTypeAnnotations(typeAnnotations.length);
            IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray = typeAnnotations;
            int n = typeAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryTypeAnnotation typeAnnotation = iBinaryTypeAnnotationArray[n2];
                NdTypeAnnotation annotation = type.createTypeAnnotation();
                this.initTypeAnnotation(annotation, typeAnnotation);
                ++n2;
            }
        }
        type.setTypeId(name);
        if (!CharArrayUtils.equals(fieldDescriptorFromClass, fieldDescriptor)) {
            type.setFieldDescriptorFromClass(fieldDescriptorFromClass);
        }
        if ((interfaces = binaryType.getInterfaceNames()) == null) {
            interfaces = EMPTY_CHAR_ARRAY_ARRAY;
        }
        if (binaryType.getGenericSignature() != null) {
            type.setFlag((byte)8, true);
        }
        SignatureWrapper signatureWrapper = GenericSignatures.getGenericSignature(binaryType);
        type.setModifiers(binaryType.getModifiers());
        type.setDeclaringType(this.createTypeIdFromBinaryName(binaryType.getEnclosingTypeName()));
        this.readTypeParameters(type, signatureWrapper);
        char[] superclassBinaryName = binaryType.getSuperclassName();
        char[] superclassFieldDescriptor = superclassBinaryName == null ? JAVA_LANG_OBJECT_FIELD_DESCRIPTOR : JavaNames.binaryNameToFieldDescriptor(superclassBinaryName);
        type.setSuperclass(this.createTypeSignature(signatureWrapper, superclassFieldDescriptor));
        int interfaceIdx = 0;
        while (signatureWrapper.start < signatureWrapper.signature.length) {
            char[] interfaceSpec = interfaceIdx < interfaces.length ? interfaces[interfaceIdx] : EMPTY_CHAR_ARRAY;
            new NdTypeInterface(this.getNd(), type, this.createTypeSignature(signatureWrapper, JavaNames.binaryNameToFieldDescriptor(interfaceSpec)));
            interfaceIdx = (short)(interfaceIdx + 1);
        }
        IBinaryAnnotation[] annotations = binaryType.getAnnotations();
        this.attachAnnotations(type, annotations);
        type.setDeclaringMethod(binaryType.getEnclosingMethod());
        IBinaryField[] fields = binaryType.getFields();
        if (fields != null) {
            type.allocateVariables(fields.length);
            IBinaryField[] iBinaryFieldArray = fields;
            int n = fields.length;
            int n3 = 0;
            while (n3 < n) {
                IBinaryField nextField = iBinaryFieldArray[n3];
                this.addField(type, nextField);
                ++n3;
            }
        }
        if ((methods = binaryType.getMethods()) != null) {
            char[][] methodNames = new char[methods.length][];
            Integer[] sortedElementIndices = new Integer[methods.length];
            int idx = 0;
            while (idx < sortedElementIndices.length) {
                sortedElementIndices[idx] = idx;
                methodNames[idx] = this.getSelectorAndDescriptor(methods[idx]);
                ++idx;
            }
            Arrays.sort(sortedElementIndices, (i1, i2) -> CharArrayUtils.compare(methodNames[i1], methodNames[i2]));
            type.allocateMethods(methods.length);
            idx = 0;
            while (idx < methods.length) {
                NdMethod newMethod = type.createMethod();
                int position = sortedElementIndices[idx];
                newMethod.setDeclarationPosition(position);
                newMethod.setMethodName(methodNames[position]);
                IBinaryMethod nextMethod = methods[position];
                this.addMethod(newMethod, nextMethod, binaryType);
                ++idx;
            }
        }
        char[][][] missingTypeNames = binaryType.getMissingTypeNames();
        char[] missingTypeString = ClassFileToIndexConverter.getMissingTypeString(missingTypeNames);
        type.setMissingTypeNames(missingTypeString);
        type.setSourceFileName(binaryType.sourceFileName());
        type.setAnonymous(binaryType.isAnonymous());
        type.setIsLocal(binaryType.isLocal());
        type.setIsMember(binaryType.isMember());
        type.setTagBits(binaryType.getTagBits());
        type.setSourceNameOverride(binaryType.getSourceName());
        return type;
    }

    private char[] getSelectorAndDescriptor(IBinaryMethod binaryMethod) {
        return CharArrayUtils.concat(binaryMethod.getSelector(), binaryMethod.getMethodDescriptor());
    }

    private static char[] getMissingTypeString(char[][][] missingTypeNames) {
        char[] missingTypeString = null;
        if (missingTypeNames != null) {
            CharArrayBuffer builder = new CharArrayBuffer();
            int typeIdx = 0;
            while (typeIdx < missingTypeNames.length) {
                char[][] next = missingTypeNames[typeIdx];
                if (typeIdx != 0) {
                    builder.append(COMMA);
                }
                if (next != null) {
                    int segmentIdx = 0;
                    while (segmentIdx < next.length) {
                        char[] segment = next[segmentIdx];
                        if (segment != null) {
                            if (segmentIdx != 0) {
                                builder.append(PATH_SEPARATOR);
                            }
                            builder.append(segment);
                        }
                        ++segmentIdx;
                    }
                }
                ++typeIdx;
            }
            missingTypeString = builder.getContents();
        }
        return missingTypeString;
    }

    private void attachAnnotations(NdMethod method, IBinaryAnnotation[] annotations) {
        if (annotations != null) {
            method.allocateAnnotations(annotations.length);
            IBinaryAnnotation[] iBinaryAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryAnnotation next = iBinaryAnnotationArray[n2];
                NdAnnotation annotation = method.createAnnotation();
                this.initAnnotation(annotation, next);
                ++n2;
            }
        }
    }

    private void attachAnnotations(NdType type, IBinaryAnnotation[] annotations) {
        if (annotations != null) {
            type.allocateAnnotations(annotations.length);
            IBinaryAnnotation[] iBinaryAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryAnnotation next = iBinaryAnnotationArray[n2];
                NdAnnotation annotation = type.createAnnotation();
                this.initAnnotation(annotation, next);
                ++n2;
            }
        }
    }

    private void attachAnnotations(NdVariable variable, IBinaryAnnotation[] annotations) {
        if (annotations != null) {
            variable.allocateAnnotations(annotations.length);
            IBinaryAnnotation[] iBinaryAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryAnnotation next = iBinaryAnnotationArray[n2];
                NdAnnotation annotation = variable.createAnnotation();
                this.initAnnotation(annotation, next);
                ++n2;
            }
        }
    }

    private void attachAnnotations(NdMethodParameter variable, IBinaryAnnotation[] annotations) {
        if (annotations != null) {
            variable.allocateAnnotations(annotations.length);
            IBinaryAnnotation[] iBinaryAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryAnnotation next = iBinaryAnnotationArray[n2];
                NdAnnotation annotation = variable.createAnnotation();
                this.initAnnotation(annotation, next);
                ++n2;
            }
        }
    }

    private void addMethod(NdMethod method, IBinaryMethod next, IBinaryType binaryType) throws CoreException {
        Object defaultValue;
        char[] nextFieldDescriptor;
        boolean compilerDefinedParametersAreIncludedInSignature;
        int flags = 0;
        this.attachAnnotations(method, next.getAnnotations());
        if (next.getGenericSignature() != null) {
            flags |= 1;
        }
        SignatureWrapper signature = GenericSignatures.getGenericSignature(next);
        SignatureWrapper descriptor = new SignatureWrapper(next.getMethodDescriptor());
        this.readTypeParameters(method, signature);
        IBinaryTypeAnnotation[] typeAnnotations = next.getTypeAnnotations();
        if (typeAnnotations != null) {
            method.allocateTypeAnnotations(typeAnnotations.length);
            IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray = typeAnnotations;
            int n = typeAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryTypeAnnotation typeAnnotation = iBinaryTypeAnnotationArray[n2];
                NdTypeAnnotation annotation = method.createTypeAnnotation();
                this.initTypeAnnotation(annotation, typeAnnotation);
                ++n2;
            }
        }
        this.skipChar(signature, '(');
        this.skipChar(descriptor, '(');
        ArrayList<char[]> parameterFieldDescriptors = new ArrayList<char[]>();
        while (!descriptor.atEnd()) {
            if (descriptor.charAtStart() == ')') {
                this.skipChar(descriptor, ')');
                break;
            }
            parameterFieldDescriptors.add(this.readNextFieldDescriptor(descriptor));
        }
        char[][] parameterNames = next.getArgumentNames();
        int numArgumentsInGenericSignature = this.countMethodArguments(signature);
        int numCompilerDefinedParameters = Math.max(0, parameterFieldDescriptors.size() - numArgumentsInGenericSignature);
        boolean bl = compilerDefinedParametersAreIncludedInSignature = next.getGenericSignature() == null;
        if (compilerDefinedParametersAreIncludedInSignature) {
            numCompilerDefinedParameters = binaryType.isMember() && next.isConstructor() && (binaryType.getModifiers() & 8) == 0 && parameterFieldDescriptors.size() > 0 ? 1 : 0;
        }
        int parameterNameIdx = 0;
        int annotatedParametersCount = next.getAnnotatedParametersCount();
        int namedParameterCount = parameterNames == null ? 0 : parameterNames.length;
        int estimatedParameterCount = Math.max(Math.max(Math.max(numArgumentsInGenericSignature, namedParameterCount), annotatedParametersCount), parameterFieldDescriptors.size());
        method.allocateParameters(estimatedParameterCount);
        int descriptorParameterIdx = 0;
        char[] binaryTypeName = binaryType.getName();
        while (!signature.atEnd()) {
            if (signature.charAtStart() == ')') {
                this.skipChar(signature, ')');
                break;
            }
            nextFieldDescriptor = (char[])parameterFieldDescriptors.get(descriptorParameterIdx);
            boolean isCompilerDefined = descriptorParameterIdx < numCompilerDefinedParameters;
            SignatureWrapper nextFieldSignature = signature;
            if (isCompilerDefined && !compilerDefinedParametersAreIncludedInSignature) {
                nextFieldSignature = new SignatureWrapper(nextFieldDescriptor);
            }
            NdMethodParameter parameter = method.createNewParameter();
            parameter.setType(this.createTypeSignature(nextFieldSignature, nextFieldDescriptor));
            parameter.setCompilerDefined(isCompilerDefined);
            if (descriptorParameterIdx < annotatedParametersCount) {
                IBinaryAnnotation[] parameterAnnotations = next.getParameterAnnotations(descriptorParameterIdx, binaryTypeName);
                this.attachAnnotations(parameter, parameterAnnotations);
            }
            if (!isCompilerDefined && namedParameterCount > parameterNameIdx) {
                parameter.setName(parameterNames[parameterNameIdx++]);
            }
            descriptorParameterIdx = (short)(descriptorParameterIdx + 1);
        }
        this.skipChar(descriptor, ')');
        nextFieldDescriptor = this.readNextFieldDescriptor(descriptor);
        method.setReturnType(this.createTypeSignature(signature, nextFieldDescriptor));
        boolean hasExceptionsInSignature = this.hasAnotherException(signature);
        char[][] exceptionTypes = next.getExceptionTypeNames();
        if (exceptionTypes == null) {
            exceptionTypes = CharArrayUtils.EMPTY_ARRAY_OF_CHAR_ARRAYS;
        }
        method.allocateExceptions(exceptionTypes.length);
        int throwsIdx = 0;
        if (hasExceptionsInSignature) {
            while (this.hasAnotherException(signature)) {
                ++signature.start;
                method.createException(this.createTypeSignature(signature, JavaNames.binaryNameToFieldDescriptor(exceptionTypes[throwsIdx])));
                ++throwsIdx;
            }
        } else if (exceptionTypes.length != 0) {
            while (throwsIdx < exceptionTypes.length) {
                char[] fieldDescriptor = JavaNames.binaryNameToFieldDescriptor(exceptionTypes[throwsIdx]);
                SignatureWrapper convertedWrapper = new SignatureWrapper(fieldDescriptor);
                method.createException(this.createTypeSignature(convertedWrapper, JavaNames.binaryNameToFieldDescriptor(exceptionTypes[throwsIdx])));
                ++throwsIdx;
            }
        }
        if (hasExceptionsInSignature) {
            flags |= 2;
        }
        if ((defaultValue = next.getDefaultValue()) != null) {
            method.setDefaultValue(this.createConstantFromMixedType(defaultValue));
        }
        method.setModifiers(next.getModifiers());
        method.setTagBits(next.getTagBits());
        method.setFlags(flags);
    }

    private boolean hasAnotherException(SignatureWrapper signature) {
        return !signature.atEnd() && signature.charAtStart() == '^';
    }

    private void skipChar(SignatureWrapper signature, char toSkip) {
        if (signature.start < signature.signature.length && signature.charAtStart() == toSkip) {
            ++signature.start;
        }
    }

    private void addField(NdType type, IBinaryField nextField) throws CoreException {
        NdVariable variable = type.createVariable();
        variable.setName(nextField.getName());
        if (nextField.getGenericSignature() != null) {
            variable.setVariableFlag((byte)1);
        }
        this.attachAnnotations(variable, nextField.getAnnotations());
        variable.setConstant(NdConstant.create(this.getNd(), nextField.getConstant()));
        variable.setModifiers(nextField.getModifiers());
        SignatureWrapper nextTypeSignature = GenericSignatures.getGenericSignatureFor(nextField);
        IBinaryTypeAnnotation[] typeAnnotations = nextField.getTypeAnnotations();
        if (typeAnnotations != null) {
            variable.allocateTypeAnnotations(typeAnnotations.length);
            IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray = typeAnnotations;
            int n = typeAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryTypeAnnotation next = iBinaryTypeAnnotationArray[n2];
                NdTypeAnnotation annotation = variable.createTypeAnnotation();
                this.initTypeAnnotation(annotation, next);
                ++n2;
            }
        }
        variable.setType(this.createTypeSignature(nextTypeSignature, nextField.getTypeName()));
        variable.setTagBits(nextField.getTagBits());
    }

    private void readTypeParameters(NdBinding type, SignatureWrapper wrapper) throws CoreException {
        char[] genericSignature = wrapper.signature;
        if (genericSignature.length == 0 || wrapper.charAtStart() != '<') {
            return;
        }
        ArrayList<TypeParameter> typeParameters = new ArrayList<TypeParameter>();
        int indexOfClosingBracket = wrapper.skipAngleContents(wrapper.start) - 1;
        ++wrapper.start;
        TypeParameter parameter = null;
        while (wrapper.start < indexOfClosingBracket) {
            int colonPos = CharOperation.indexOf(':', genericSignature, wrapper.start, indexOfClosingBracket);
            if (colonPos > wrapper.start) {
                char[] identifier = CharOperation.subarray(genericSignature, wrapper.start, colonPos);
                parameter = new TypeParameter();
                typeParameters.add(parameter);
                parameter.identifier = identifier;
                wrapper.start = colonPos + 1;
                parameter.firstBoundIsClass = wrapper.charAtStart() != ':';
            }
            this.skipChar(wrapper, ':');
            NdTypeSignature boundSignature = this.createTypeSignature(wrapper, JAVA_LANG_OBJECT_FIELD_DESCRIPTOR);
            parameter.bounds.add(boundSignature);
        }
        type.allocateTypeParameters(typeParameters.size());
        for (TypeParameter param : typeParameters) {
            NdTypeParameter ndParam = type.createTypeParameter();
            ndParam.setIdentifier(param.identifier);
            ndParam.setFirstBoundIsClass(param.firstBoundIsClass);
            ndParam.allocateBounds(param.bounds.size());
            for (NdTypeSignature bound : param.bounds) {
                ndParam.createBound(bound);
            }
        }
        this.skipChar(wrapper, '>');
    }

    private char[] readNextFieldDescriptor(SignatureWrapper genericSignature) throws CoreException {
        int endPosition = this.findEndOfFieldDescriptor(genericSignature);
        char[] result = CharArrayUtils.subarray(genericSignature.signature, genericSignature.start, endPosition);
        genericSignature.start = endPosition;
        return result;
    }

    private int findEndOfFieldDescriptor(SignatureWrapper genericSignature) throws CoreException {
        char[] signature = genericSignature.signature;
        if (signature == null || signature.length == 0) {
            return genericSignature.start;
        }
        int current = genericSignature.start;
        while (current < signature.length) {
            char firstChar = signature[current];
            switch (firstChar) {
                case 'L': 
                case 'T': {
                    return CharArrayUtils.indexOf(';', signature, current, signature.length) + 1;
                }
                case '[': {
                    ++current;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    return current + 1;
                }
                default: {
                    throw new CoreException(Package.createStatus("Field descriptor starts with unknown character: " + genericSignature.toString()));
                }
            }
        }
        return current;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int countMethodArguments(SignatureWrapper genericSignature) {
        SignatureWrapper lookaheadSignature = new SignatureWrapper(genericSignature.signature);
        lookaheadSignature.start = genericSignature.start;
        this.skipChar(lookaheadSignature, '(');
        int argumentCount = 0;
        block6: while (!lookaheadSignature.atEnd() && lookaheadSignature.charAtStart() != ')') {
            char nextChar;
            switch (lookaheadSignature.charAtStart()) {
                case 'T': {
                    lookaheadSignature.nextWord();
                    this.skipChar(lookaheadSignature, ';');
                    ++argumentCount;
                    continue block6;
                }
                case '[': {
                    ++lookaheadSignature.start;
                    continue block6;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    ++argumentCount;
                    ++lookaheadSignature.start;
                    continue block6;
                }
                case 'L': {
                    break;
                }
                default: {
                    throw new IllegalStateException("Generic signature starts with unknown character: " + lookaheadSignature.toString());
                }
            }
            do {
                lookaheadSignature.nextWord();
                lookaheadSignature.start = lookaheadSignature.skipAngleContents(lookaheadSignature.start);
                nextChar = lookaheadSignature.charAtStart();
                if (nextChar != ';') continue;
                this.skipChar(lookaheadSignature, ';');
                ++argumentCount;
                continue block6;
            } while (nextChar == '.');
            throw new IllegalStateException("Unknown char in generic signature " + lookaheadSignature.toString());
        }
        return argumentCount;
    }

    private NdTypeSignature createTypeSignature(SignatureWrapper genericSignature, char[] fieldDescriptorIfVariable) throws CoreException {
        char[] signature = genericSignature.signature;
        if (signature == null || signature.length == 0) {
            return null;
        }
        char firstChar = genericSignature.charAtStart();
        switch (firstChar) {
            case 'T': {
                ++genericSignature.start;
                NdComplexTypeSignature typeSignature = new NdComplexTypeSignature(this.getNd());
                char[] fieldDescriptor = fieldDescriptorIfVariable;
                if (fieldDescriptor == null) {
                    fieldDescriptor = JAVA_LANG_OBJECT_FIELD_DESCRIPTOR;
                }
                typeSignature.setRawType(this.createTypeIdFromFieldDescriptor(fieldDescriptor));
                typeSignature.setVariableIdentifier(genericSignature.nextWord());
                this.skipChar(genericSignature, ';');
                return typeSignature;
            }
            case '[': {
                ++genericSignature.start;
                char[] nestedFieldDescriptor = null;
                if (fieldDescriptorIfVariable != null && fieldDescriptorIfVariable.length > 0 && fieldDescriptorIfVariable[0] == '[') {
                    nestedFieldDescriptor = CharArrayUtils.subarray(fieldDescriptorIfVariable, 1);
                }
                NdTypeSignature elementType = this.createTypeSignature(genericSignature, nestedFieldDescriptor);
                char[] computedFieldDescriptor = CharArrayUtils.concat(ARRAY_FIELD_DESCRIPTOR_PREFIX, elementType.getRawType().getFieldDescriptor().getChars());
                NdTypeId rawType = this.createTypeIdFromFieldDescriptor(computedFieldDescriptor);
                NdComplexTypeSignature typeSignature = new NdComplexTypeSignature(this.getNd());
                typeSignature.setRawType(rawType);
                NdTypeArgument typeArgument = new NdTypeArgument(this.getNd(), typeSignature);
                typeArgument.setType(elementType);
                return typeSignature;
            }
            case 'V': {
                ++genericSignature.start;
                return null;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                ++genericSignature.start;
                return this.createTypeIdFromFieldDescriptor(new char[]{firstChar});
            }
            case 'L': {
                return this.parseClassTypeSignature(null, genericSignature);
            }
            case '*': 
            case '+': 
            case '-': {
                throw new CoreException(Package.createStatus("Unexpected wildcard in top-level of generic signature: " + genericSignature.toString()));
            }
        }
        throw new CoreException(Package.createStatus("Generic signature starts with unknown character: " + genericSignature.toString()));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private NdTypeSignature parseClassTypeSignature(NdComplexTypeSignature parentTypeOrNull, SignatureWrapper wrapper) throws CoreException {
        void var9_12;
        NdTypeId rawType;
        char[] identifier = wrapper.nextWord();
        char[] fieldDescriptor = parentTypeOrNull != null ? CharArrayUtils.concat(parentTypeOrNull.getRawType().getFieldDescriptorWithoutTrailingSemicolon(), INNER_TYPE_SEPARATOR, identifier, FIELD_DESCRIPTOR_SUFFIX) : CharArrayUtils.concat(identifier, FIELD_DESCRIPTOR_SUFFIX);
        char[] genericSignature = wrapper.signature;
        boolean hasGenericArguments = genericSignature.length > wrapper.start && genericSignature[wrapper.start] == '<';
        boolean isRawTypeWithNestedClass = genericSignature[wrapper.start] == '.';
        NdTypeId ndTypeId = rawType = this.createTypeIdFromFieldDescriptor(fieldDescriptor);
        boolean checkForSemicolon = true;
        if (hasGenericArguments || parentTypeOrNull != null || isRawTypeWithNestedClass) {
            NdComplexTypeSignature typeSignature = new NdComplexTypeSignature(this.getNd());
            typeSignature.setRawType(rawType);
            if (hasGenericArguments) {
                ++wrapper.start;
                block5: while (wrapper.start < genericSignature.length && genericSignature[wrapper.start] != '>') {
                    NdTypeArgument typeArgument = new NdTypeArgument(this.getNd(), typeSignature);
                    switch (genericSignature[wrapper.start]) {
                        case '+': {
                            typeArgument.setWildcard(2);
                            ++wrapper.start;
                            break;
                        }
                        case '-': {
                            typeArgument.setWildcard(1);
                            ++wrapper.start;
                            break;
                        }
                        case '*': {
                            typeArgument.setWildcard(3);
                            ++wrapper.start;
                            continue block5;
                        }
                    }
                    NdTypeSignature nextSignature = this.createTypeSignature(wrapper, null);
                    typeArgument.setType(nextSignature);
                }
                this.skipChar(wrapper, '>');
            }
            NdComplexTypeSignature ndComplexTypeSignature = typeSignature;
            if (parentTypeOrNull != null) {
                typeSignature.setGenericDeclaringType(parentTypeOrNull);
            }
            if (genericSignature[wrapper.start] == '.') {
                checkForSemicolon = false;
                this.skipChar(wrapper, '.');
                NdTypeSignature ndTypeSignature = this.parseClassTypeSignature(typeSignature, wrapper);
            }
        }
        if (checkForSemicolon) {
            this.skipChar(wrapper, ';');
        }
        return var9_12;
    }

    private NdTypeId createTypeIdFromFieldDescriptor(char[] typeName) {
        if (typeName == null) {
            return null;
        }
        return this.index.createTypeId(typeName);
    }

    private void initTypeAnnotation(NdTypeAnnotation annotation, IBinaryTypeAnnotation next) {
        int[] typePath = next.getTypePath();
        if (typePath != null && typePath.length > 0) {
            byte[] bytePath = new byte[typePath.length];
            int idx = 0;
            while (idx < bytePath.length) {
                bytePath[idx] = (byte)typePath[idx];
                ++idx;
            }
            annotation.setPath(bytePath);
        }
        int targetType = next.getTargetType();
        annotation.setTargetType(targetType);
        switch (targetType) {
            case 0: 
            case 1: {
                annotation.setTargetInfo(next.getTypeParameterIndex());
                break;
            }
            case 16: {
                annotation.setTargetInfo(next.getSupertypeIndex());
                break;
            }
            case 17: 
            case 18: {
                annotation.setTargetInfo((byte)next.getTypeParameterIndex(), (byte)next.getBoundIndex());
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                annotation.setTargetInfo(next.getMethodFormalParameterIndex());
                break;
            }
            case 23: {
                annotation.setTargetInfo(next.getThrowsTypeIndex());
                break;
            }
            default: {
                throw new IllegalStateException("Target type not handled " + targetType);
            }
        }
        this.initAnnotation(annotation, next.getAnnotation());
    }

    private void initAnnotation(NdAnnotation annotation, IBinaryAnnotation next) {
        annotation.setType(this.createTypeIdFromBinaryName(next.getTypeName()));
        IBinaryElementValuePair[] pairs = next.getElementValuePairs();
        if (pairs != null) {
            annotation.allocateValuePairs(pairs.length);
            IBinaryElementValuePair[] iBinaryElementValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryElementValuePair element = iBinaryElementValuePairArray[n2];
                NdAnnotationValuePair nextPair = annotation.createValuePair(element.getName());
                nextPair.setValue(this.createConstantFromMixedType(element.getValue()));
                ++n2;
            }
        }
    }

    private void logInfo(String string) {
    }

    private NdTypeId createTypeIdFromBinaryName(char[] binaryName) {
        if (binaryName == null) {
            return null;
        }
        return this.index.createTypeId(JavaNames.binaryNameToFieldDescriptor(binaryName));
    }

    public NdConstant createConstantFromMixedType(Object value) {
        if (value instanceof Constant) {
            Constant constant = (Constant)value;
            return NdConstant.create(this.getNd(), constant);
        }
        if (value instanceof ClassSignature) {
            ClassSignature signature = (ClassSignature)value;
            char[] binaryName = JavaNames.binaryNameToFieldDescriptor(signature.getTypeName());
            NdTypeId typeId = this.index.createTypeId(binaryName);
            return NdConstantClass.create(this.getNd(), typeId);
        }
        if (value instanceof IBinaryAnnotation) {
            IBinaryAnnotation binaryAnnotation = (IBinaryAnnotation)value;
            NdConstantAnnotation constant = new NdConstantAnnotation(this.getNd());
            this.initAnnotation(constant.getValue(), binaryAnnotation);
            return constant;
        }
        if (value instanceof Object[]) {
            Object[] array;
            NdConstantArray result = new NdConstantArray(this.getNd());
            Object[] objectArray = array = (Object[])value;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = objectArray[n2];
                NdConstant nextConstant = this.createConstantFromMixedType(next);
                nextConstant.setParent(result);
                ++n2;
            }
            return result;
        }
        if (value instanceof EnumConstantSignature) {
            EnumConstantSignature signature = (EnumConstantSignature)value;
            NdConstantEnum result = NdConstantEnum.create(this.createTypeIdFromBinaryName(signature.getTypeName()), new String(signature.getEnumConstantName()));
            return result;
        }
        throw new IllegalStateException("Unknown constant type " + value.getClass().getName());
    }

    private static class TypeParameter {
        public List<NdTypeSignature> bounds = new ArrayList<NdTypeSignature>();
        public char[] identifier = EMPTY_CHAR_ARRAY;
        public boolean firstBoundIsClass;
    }
}

