/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.core.IJavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.ProjectEntry;

public class ModuleSourcePathManager {
    private Map<String, IModulePathEntry> knownModules = new HashMap<String, IModulePathEntry>(11);

    private IModulePathEntry getModuleRoot0(String name) {
        return this.knownModules.get(name);
    }

    public void addEntry(IModuleDescription module, JavaProject project) throws JavaModelException {
        String moduleName = new String(module.getElementName().toCharArray());
        IModulePathEntry entry = this.getModuleRoot0(moduleName);
        if (entry != null) {
            return;
        }
        this.knownModules.put(moduleName, new ProjectEntry(project));
    }

    public void removeEntry(JavaProject javaProject) {
        String key;
        Map.Entry entry = this.knownModules.entrySet().stream().filter(e -> ProjectEntry.representsProject((IModulePathEntry)e.getValue(), javaProject)).findFirst().orElse(null);
        String string = key = entry != null ? (String)entry.getKey() : null;
        if (key != null) {
            this.knownModules.remove(key);
        }
    }

    public void seekModule(char[] name, boolean prefixMatch, IJavaElementRequestor requestor) throws JavaModelException {
        if (name == null) {
            return;
        }
        IPrefixMatcherCharArray prefixMatcher = prefixMatch ? (CharOperation.equals(name, CharOperation.ALL_PREFIX) ? (x, y) -> true : CharOperation::prefixEquals) : CharOperation::equals;
        IJavaProject[] projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
        int i = 0;
        while (i < projects.length) {
            IModuleDescription module;
            IJavaProject project = projects[i];
            if (project.getProject().isAccessible() && project instanceof JavaProject && (module = ((JavaProject)project).getModuleDescription()) != null && prefixMatcher.matches(name, module.getElementName().toCharArray())) {
                requestor.acceptModule(module);
            }
            ++i;
        }
    }

    static interface IPrefixMatcherCharArray {
        public boolean matches(char[] var1, char[] var2);
    }
}

