/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.ResolvedBinaryMethod;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.util.Util;

public class BinaryMethod
extends BinaryMember
implements IMethod {
    protected String[] parameterTypes;
    protected String[] erasedParamaterTypes;
    protected String returnType;

    protected BinaryMethod(JavaElement parent, String name, String[] paramTypes) {
        super(parent, name);
        this.parameterTypes = paramTypes == null ? CharOperation.NO_STRINGS : paramTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BinaryMethod)) {
            return false;
        }
        return super.equals(o) && Util.equalArraysOrNull(this.getErasedParameterTypes(), ((BinaryMethod)o).getErasedParameterTypes());
    }

    @Override
    public IAnnotation[] getAnnotations() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        IBinaryAnnotation[] binaryAnnotations = info.getAnnotations();
        return this.getAnnotations(binaryAnnotations, info.getTagBits());
    }

    @Override
    public int getElementType() {
        return 9;
    }

    @Override
    public int getFlags() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        int modifiers = info.getModifiers();
        if (((IType)((Object)this.parent)).isInterface() && (modifiers & 0x408) == 0) {
            modifiers |= 0x10000;
        }
        return modifiers;
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        char delimiter = this.getHandleMementoDelimiter();
        buff.append(delimiter);
        this.escapeMementoName(buff, this.getElementName());
        int i = 0;
        while (i < this.parameterTypes.length) {
            buff.append(delimiter);
            this.escapeMementoName(buff, this.parameterTypes[i]);
            ++i;
        }
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '~';
    }

    @Override
    public int getNumberOfParameters() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    @Override
    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    private String[] getErasedParameterTypes() {
        if (this.erasedParamaterTypes == null) {
            int paramCount = this.parameterTypes.length;
            String[] erasedTypes = new String[paramCount];
            boolean erasureNeeded = false;
            int i = 0;
            while (i < paramCount) {
                String parameterType = this.parameterTypes[i];
                erasedTypes[i] = Signature.getTypeErasure(parameterType);
                if (erasedTypes[i] != parameterType) {
                    erasureNeeded = true;
                }
                ++i;
            }
            this.erasedParamaterTypes = erasureNeeded ? erasedTypes : this.parameterTypes;
        }
        return this.erasedParamaterTypes;
    }

    private String getErasedParameterType(int index) {
        return this.getErasedParameterTypes()[index];
    }

    @Override
    public ITypeParameter getTypeParameter(String typeParameterName) {
        return new TypeParameter(this, typeParameterName);
    }

    @Override
    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        String[] typeParameterSignatures = this.getTypeParameterSignatures();
        int length = typeParameterSignatures.length;
        if (length == 0) {
            return TypeParameter.NO_TYPE_PARAMETERS;
        }
        ITypeParameter[] typeParameters = new ITypeParameter[length];
        int i = 0;
        while (i < typeParameterSignatures.length) {
            String typeParameterName = Signature.getTypeVariable(typeParameterSignatures[i]);
            typeParameters[i] = new TypeParameter(this, typeParameterName);
            ++i;
        }
        return typeParameters;
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        char[] genericSignature = info.getGenericSignature();
        if (genericSignature == null) {
            return CharOperation.NO_STRINGS;
        }
        char[] dotBasedSignature = CharOperation.replaceOnCopy(genericSignature, '/', '.');
        char[][] typeParams = Signature.getTypeParameters(dotBasedSignature);
        return CharOperation.toStrings(typeParams);
    }

    @Override
    public String getReturnType() throws JavaModelException {
        if (this.returnType == null) {
            IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
            this.returnType = this.getReturnType(info);
        }
        return this.returnType;
    }

    private String getReturnType(IBinaryMethod info) {
        char[] genericSignature = info.getGenericSignature();
        char[] signature = genericSignature == null ? info.getMethodDescriptor() : genericSignature;
        char[] dotBasedSignature = CharOperation.replaceOnCopy(signature, '/', '.');
        String returnTypeName = Signature.getReturnType(new String(dotBasedSignature));
        return new String(ClassFile.translatedName(returnTypeName.toCharArray()));
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        int i = 0;
        int length = this.parameterTypes.length;
        while (i < length) {
            hash = Util.combineHashCodes(hash, this.getErasedParameterType(i).hashCode());
            ++i;
        }
        return hash;
    }

    @Override
    public boolean isConstructor() throws JavaModelException {
        if (!this.getElementName().equals(this.parent.getElementName())) {
            return false;
        }
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return info.isConstructor();
    }

    @Override
    public JavaElement resolved(Binding binding) {
        ResolvedBinaryMethod resolvedHandle = new ResolvedBinaryMethod(this.parent, this.name, this.parameterTypes, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            IBinaryMethod methodInfo = (IBinaryMethod)info;
            int flags = methodInfo.getModifiers();
            if (Flags.isStatic(flags)) {
                buffer.append("static ");
            }
            if (!methodInfo.isConstructor()) {
                buffer.append(Signature.toString(this.getReturnType(methodInfo)));
                buffer.append(' ');
            }
            this.toStringName(buffer, flags);
        }
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        this.toStringName(buffer, 0);
    }

    protected void toStringName(StringBuffer buffer, int flags) {
        int length;
        buffer.append(this.getElementName());
        buffer.append('(');
        String[] parameters = this.getParameterTypes();
        if (parameters != null && (length = parameters.length) > 0) {
            boolean isVarargs = Flags.isVarargs(flags);
            int i = 0;
            while (i < length) {
                try {
                    if (i < length - 1) {
                        buffer.append(Signature.toString(parameters[i]));
                        buffer.append(", ");
                    } else if (isVarargs) {
                        String parameter = parameters[i].substring(1);
                        buffer.append(Signature.toString(parameter));
                        buffer.append(" ...");
                    } else {
                        buffer.append(Signature.toString(parameters[i]));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    buffer.append("*** invalid signature: ");
                    buffer.append(parameters[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }
}

