/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;

public final class Modifier
extends ASTNode
implements IExtendedModifier {
    public static final SimplePropertyDescriptor KEYWORD_PROPERTY = new SimplePropertyDescriptor(Modifier.class, "keyword", ModifierKeyword.class, true);
    private static final List PROPERTY_DESCRIPTORS;
    private ModifierKeyword modifierKeyword = ModifierKeyword.PUBLIC_KEYWORD;

    static {
        ArrayList properyList = new ArrayList(2);
        Modifier.createPropertyList(Modifier.class, properyList);
        Modifier.addProperty(KEYWORD_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = Modifier.reapPropertyList(properyList);
    }

    public static boolean isAbstract(int flags) {
        return (flags & 0x400) != 0;
    }

    public static boolean isFinal(int flags) {
        return (flags & 0x10) != 0;
    }

    public static boolean isNative(int flags) {
        return (flags & 0x100) != 0;
    }

    public static boolean isPrivate(int flags) {
        return (flags & 2) != 0;
    }

    public static boolean isProtected(int flags) {
        return (flags & 4) != 0;
    }

    public static boolean isPublic(int flags) {
        return (flags & 1) != 0;
    }

    public static boolean isStatic(int flags) {
        return (flags & 8) != 0;
    }

    public static boolean isStrictfp(int flags) {
        return (flags & 0x800) != 0;
    }

    public static boolean isSynchronized(int flags) {
        return (flags & 0x20) != 0;
    }

    public static boolean isTransient(int flags) {
        return (flags & 0x80) != 0;
    }

    public static boolean isVolatile(int flags) {
        return (flags & 0x40) != 0;
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    Modifier(AST ast) {
        super(ast);
        this.unsupportedIn2();
    }

    @Override
    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public ModifierKeyword getKeyword() {
        return this.modifierKeyword;
    }

    @Override
    final int getNodeType0() {
        return 83;
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == KEYWORD_PROPERTY) {
            if (get) {
                return this.getKeyword();
            }
            this.setKeyword((ModifierKeyword)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return Modifier.propertyDescriptors(apiLevel);
    }

    @Override
    public boolean isAnnotation() {
        return false;
    }

    public void setKeyword(ModifierKeyword modifierKeyord) {
        if (modifierKeyord == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(KEYWORD_PROPERTY);
        this.modifierKeyword = modifierKeyord;
        this.postValueChange(KEYWORD_PROPERTY);
    }

    public static class ModifierKeyword {
        public static final ModifierKeyword ABSTRACT_KEYWORD = new ModifierKeyword("abstract", 1024);
        public static final ModifierKeyword FINAL_KEYWORD = new ModifierKeyword("final", 16);
        private static final Map KEYWORDS;
        public static final ModifierKeyword NATIVE_KEYWORD;
        public static final ModifierKeyword PRIVATE_KEYWORD;
        public static final ModifierKeyword PROTECTED_KEYWORD;
        public static final ModifierKeyword PUBLIC_KEYWORD;
        public static final ModifierKeyword STATIC_KEYWORD;
        public static final ModifierKeyword STRICTFP_KEYWORD;
        public static final ModifierKeyword SYNCHRONIZED_KEYWORD;
        public static final ModifierKeyword TRANSIENT_KEYWORD;
        public static final ModifierKeyword VOLATILE_KEYWORD;
        public static final ModifierKeyword DEFAULT_KEYWORD;
        private int flagValue;
        private String keyword;

        static {
            NATIVE_KEYWORD = new ModifierKeyword("native", 256);
            PRIVATE_KEYWORD = new ModifierKeyword("private", 2);
            PROTECTED_KEYWORD = new ModifierKeyword("protected", 4);
            PUBLIC_KEYWORD = new ModifierKeyword("public", 1);
            STATIC_KEYWORD = new ModifierKeyword("static", 8);
            STRICTFP_KEYWORD = new ModifierKeyword("strictfp", 2048);
            SYNCHRONIZED_KEYWORD = new ModifierKeyword("synchronized", 32);
            TRANSIENT_KEYWORD = new ModifierKeyword("transient", 128);
            VOLATILE_KEYWORD = new ModifierKeyword("volatile", 64);
            DEFAULT_KEYWORD = new ModifierKeyword("default", 65536);
            KEYWORDS = new HashMap(20);
            ModifierKeyword[] ops = new ModifierKeyword[]{PUBLIC_KEYWORD, PROTECTED_KEYWORD, PRIVATE_KEYWORD, STATIC_KEYWORD, ABSTRACT_KEYWORD, FINAL_KEYWORD, NATIVE_KEYWORD, SYNCHRONIZED_KEYWORD, TRANSIENT_KEYWORD, VOLATILE_KEYWORD, STRICTFP_KEYWORD, DEFAULT_KEYWORD};
            int i = 0;
            while (i < ops.length) {
                KEYWORDS.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private ModifierKeyword(String keyword, int flagValue) {
            this.keyword = keyword;
            this.flagValue = flagValue;
        }

        public int toFlagValue() {
            return this.flagValue;
        }

        public String toString() {
            return this.keyword;
        }
    }
}

