/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.util.Map;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.application.ScheduledApplication;
import org.osgi.util.tracker.ServiceTracker;

public class AppCommands
implements CommandProvider {
    private Map<String, String[]> commandsHelp = null;
    private static AppCommands instance;
    private BundleContext context;
    private ServiceTracker applicationDescriptors;
    private ServiceTracker applicationHandles;
    private ServiceTracker scheduledApplications;
    private Filter launchableApp;
    private Filter activeApp;
    private Filter lockedApp;
    private ServiceRegistration providerRegistration;

    static synchronized void create(BundleContext context) {
        if (instance != null) {
            return;
        }
        instance = new AppCommands();
        instance.start(context);
    }

    static synchronized void destroy(BundleContext context) {
        if (instance == null) {
            return;
        }
        instance.stop(context);
        instance = null;
    }

    protected AppCommands() {
    }

    public void start(BundleContext ctx) {
        this.context = ctx;
        try {
            this.applicationDescriptors = new ServiceTracker(ctx, ApplicationDescriptor.class.getName(), null);
            this.applicationDescriptors.open();
            this.applicationHandles = new ServiceTracker(ctx, ApplicationHandle.class.getName(), null);
            this.applicationHandles.open();
            this.scheduledApplications = new ServiceTracker(ctx, ScheduledApplication.class.getName(), null);
            this.scheduledApplications.open();
            this.launchableApp = ctx.createFilter("(&(application.locked=false)(application.launchable=true)(application.visible=true))");
            this.activeApp = ctx.createFilter("(!(application.state=STOPPING))");
            this.lockedApp = ctx.createFilter("(application.locked=true)");
            this.providerRegistration = ctx.registerService(CommandProvider.class.getName(), (Object)this, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    public void stop(BundleContext ctx) {
        this.providerRegistration.unregister();
        if (this.applicationDescriptors != null) {
            this.applicationDescriptors.close();
        }
        if (this.applicationHandles != null) {
            this.applicationHandles.close();
        }
        if (this.scheduledApplications != null) {
            this.scheduledApplications.close();
        }
    }
}

