/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.internal.preferences.exchange.ILegacyPreferences;
import org.eclipse.core.internal.preferences.exchange.IProductPreferencesService;
import org.eclipse.core.internal.preferences.legacy.InitLegacyPreferences;
import org.eclipse.core.internal.preferences.legacy.ProductPreferencesService;
import org.eclipse.core.internal.runtime.AuthorizationHandler;
import org.eclipse.core.internal.runtime.Log;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.MetaDataKeeper;
import org.eclipse.core.internal.runtime.Product;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.eclipse.equinox.internal.app.EclipseAppContainer;
import org.eclipse.equinox.internal.app.IBranding;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.util.tracker.ServiceTracker;

public final class InternalPlatform {
    private static final String[] ARCH_LIST = new String[]{"x86", "x86_64"};
    public static boolean DEBUG = false;
    public static boolean DEBUG_PLUGIN_PREFERENCES = false;
    private boolean splashEnded = false;
    private boolean initialized;
    private String keyringFile;
    private Map<Bundle, Log> logs = new HashMap<Bundle, Log>(5);
    private static final String[] OS_LIST = new String[]{"linux", "macosx", "win32"};
    private String password = "";
    private static final InternalPlatform singleton = new InternalPlatform();
    private static final String[] WS_LIST = new String[]{"cocoa", "gtk", "win32", "wpf"};
    private Path cachedInstanceLocation;
    private ServiceTracker<Location, Location> configurationLocation = null;
    private BundleContext context;
    private FrameworkWiring fwkWiring;
    private Map<IBundleGroupProvider, ServiceRegistration<IBundleGroupProvider>> groupProviders = new HashMap<IBundleGroupProvider, ServiceRegistration<IBundleGroupProvider>>(3);
    private ServiceTracker<Location, Location> installLocation = null;
    private ServiceTracker<Location, Location> instanceLocation = null;
    private ServiceTracker<Location, Location> userLocation = null;
    private Plugin runtimeInstance;
    private ServiceRegistration<ILegacyPreferences> legacyPreferencesService = null;
    private ServiceRegistration<IProductPreferencesService> customPreferencesService = null;
    private ServiceTracker<EnvironmentInfo, EnvironmentInfo> environmentTracker = null;
    private ServiceTracker<FrameworkLog, FrameworkLog> logTracker = null;
    private ServiceTracker<PlatformAdmin, PlatformAdmin> platformTracker = null;
    private ServiceTracker<DebugOptions, DebugOptions> debugTracker = null;
    private ServiceTracker<IContentTypeManager, IContentTypeManager> contentTracker = null;
    private ServiceTracker<IPreferencesService, IPreferencesService> preferencesTracker = null;
    private ServiceTracker<IBundleGroupProvider, IBundleGroupProvider> groupProviderTracker = null;
    private ServiceTracker<ExtendedLogReaderService, ExtendedLogReaderService> logReaderTracker = null;
    private ServiceTracker<ExtendedLogService, ExtendedLogService> extendedLogTracker = null;
    private IProduct product;

    public static InternalPlatform getDefault() {
        return singleton;
    }

    private InternalPlatform() {
    }

    private void assertInitialized() {
        if (!this.initialized) {
            Assert.isTrue(false, Messages.meta_appNotInit);
        }
    }

    public boolean getBooleanOption(String option, boolean defaultValue) {
        String value = this.getOption(option);
        if (value == null) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(value);
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public String getBundleId(Object object) {
        if (object == null) {
            return null;
        }
        Bundle source = FrameworkUtil.getBundle(object.getClass());
        if (source != null && source.getSymbolicName() != null) {
            return source.getSymbolicName();
        }
        return null;
    }

    public Bundle getBundle(String symbolicName) {
        Bundle[] bundles = this.getBundles(symbolicName, null);
        return bundles != null && bundles.length > 0 ? bundles[0] : null;
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        Map<String, String> directives;
        Collection<BundleCapability> matchingBundleCapabilities;
        if ("system.bundle".equals(symbolicName)) {
            symbolicName = this.context.getBundle("System Bundle").getSymbolicName();
        }
        if ((matchingBundleCapabilities = this.fwkWiring.findProviders(ModuleContainer.createRequirement("osgi.identity", directives = Collections.singletonMap("filter", this.getRequirementFilter(symbolicName, versionRange)), Collections.emptyMap()))).isEmpty()) {
            return null;
        }
        Bundle[] results = (Bundle[])matchingBundleCapabilities.stream().map(c -> c.getRevision().getBundle()).filter(bundle -> (bundle.getState() & 3) == 0).sorted((b1, b2) -> b2.getVersion().compareTo(b1.getVersion())).toArray(Bundle[]::new);
        return results.length > 0 ? results : null;
    }

    private String getRequirementFilter(String symbolicName, String versionRange) {
        VersionRange range = versionRange == null ? null : new VersionRange(versionRange);
        StringBuilder filter = new StringBuilder();
        if (range != null) {
            filter.append("(&");
        }
        filter.append('(').append("osgi.identity").append('=').append(symbolicName).append(')');
        if (range != null) {
            filter.append(range.toFilterString("version")).append(')');
        }
        return filter.toString();
    }

    public String[] getCommandLineArgs() {
        return CommandLineArgs.getAllArgs();
    }

    public IContentTypeManager getContentTypeManager() {
        return this.contentTracker == null ? null : this.contentTracker.getService();
    }

    public EnvironmentInfo getEnvironmentInfoService() {
        return this.environmentTracker == null ? null : this.environmentTracker.getService();
    }

    public FrameworkLog getFrameworkLog() {
        return this.logTracker == null ? null : this.logTracker.getService();
    }

    public Location getInstanceLocation() {
        this.assertInitialized();
        return this.instanceLocation.getService();
    }

    public IPath getLocation() throws IllegalStateException {
        if (this.cachedInstanceLocation == null) {
            Location location = this.getInstanceLocation();
            if (location == null) {
                return null;
            }
            File file = new File(location.getURL().getFile());
            this.cachedInstanceLocation = new Path(file.toString());
        }
        return this.cachedInstanceLocation;
    }

    public ILog getLog(Bundle bundle) {
        Log result = this.logs.get(bundle);
        if (result != null) {
            return result;
        }
        ExtendedLogService logService = this.extendedLogTracker.getService();
        Logger logger = logService != null ? logService.getLogger(bundle, "org.eclipse.equinox.logger") : null;
        result = new Log(bundle, logger);
        ExtendedLogReaderService logReader = this.logReaderTracker.getService();
        logReader.addLogListener(result, result);
        this.logs.put(bundle, result);
        return result;
    }

    public String getOption(String option) {
        DebugOptions options = this.getDebugOptions();
        if (options != null) {
            return options.getOption(option);
        }
        return null;
    }

    public String getOS() {
        return this.getBundleContext().getProperty("osgi.os");
    }

    public PlatformAdmin getPlatformAdmin() {
        return this.platformTracker == null ? null : this.platformTracker.getService();
    }

    public IPreferencesService getPreferencesService() {
        return this.preferencesTracker == null ? null : this.preferencesTracker.getService();
    }

    public IProduct getProduct() {
        IBranding branding;
        if (this.product != null) {
            return this.product;
        }
        EclipseAppContainer container = Activator.getContainer();
        IBranding iBranding = branding = container == null ? null : container.getBranding();
        if (branding == null) {
            return null;
        }
        Object brandingProduct = branding.getProduct();
        if (!(brandingProduct instanceof IProduct)) {
            brandingProduct = new Product(branding);
        }
        this.product = (IProduct)brandingProduct;
        return this.product;
    }

    public IPath getStateLocation(Bundle bundle, boolean create) throws IllegalStateException {
        this.assertInitialized();
        IPath result = MetaDataKeeper.getMetaArea().getStateLocation(bundle);
        if (create) {
            result.toFile().mkdirs();
        }
        return result;
    }

    public long getStateTimeStamp() {
        PlatformAdmin admin = this.getPlatformAdmin();
        return admin == null ? -1L : admin.getState(false).getTimeStamp();
    }

    private void initializeAuthorizationHandler() {
        try {
            AuthorizationHandler.setKeyringFile(this.keyringFile);
            AuthorizationHandler.setPassword(this.password);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    void initializeDebugFlags() {
        DEBUG = this.getBooleanOption("org.eclipse.core.runtime/debug", false);
        if (DEBUG) {
            DEBUG_PLUGIN_PREFERENCES = this.getBooleanOption("org.eclipse.core.runtime/preferences/plugin", false);
        }
    }

    public boolean isRunning() {
        try {
            return this.initialized && this.context != null && this.context.getBundle().getState() == 32;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    private void processCommandLine(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase("-keyring")) {
                    this.keyringFile = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-password")) {
                    this.password = arg;
                }
            }
            ++i;
        }
    }

    public void setRuntimeInstance(Plugin runtime) {
        this.runtimeInstance = runtime;
    }

    public void start(BundleContext runtimeContext) {
        this.context = runtimeContext;
        this.fwkWiring = runtimeContext.getBundle("System Bundle").adapt(FrameworkWiring.class);
        this.openOSGiTrackers();
        this.splashEnded = false;
        this.processCommandLine(this.getEnvironmentInfoService().getNonFrameworkArgs());
        this.initializeDebugFlags();
        this.initialized = true;
        this.initializeAuthorizationHandler();
        this.startServices();
    }

    public void stop(BundleContext bundleContext) {
        this.assertInitialized();
        this.stopServices();
        this.initialized = false;
        this.closeOSGITrackers();
        this.context = null;
    }

    private void openOSGiTrackers() {
        Filter filter = null;
        try {
            filter = this.context.createFilter(Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.instanceLocation = new ServiceTracker(this.context, filter, null);
        this.instanceLocation.open();
        try {
            filter = this.context.createFilter(Location.USER_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.userLocation = new ServiceTracker(this.context, filter, null);
        this.userLocation.open();
        try {
            filter = this.context.createFilter(Location.CONFIGURATION_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.configurationLocation = new ServiceTracker(this.context, filter, null);
        this.configurationLocation.open();
        try {
            filter = this.context.createFilter(Location.INSTALL_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.installLocation = new ServiceTracker(this.context, filter, null);
        this.installLocation.open();
        if (this.context != null) {
            this.logTracker = new ServiceTracker(this.context, FrameworkLog.class, null);
            this.logTracker.open();
        }
        if (this.context != null) {
            this.platformTracker = new ServiceTracker(this.context, PlatformAdmin.class, null);
            this.platformTracker.open();
        }
        if (this.context != null) {
            this.contentTracker = new ServiceTracker(this.context, IContentTypeManager.class, null);
            this.contentTracker.open();
        }
        if (this.context != null) {
            this.preferencesTracker = new ServiceTracker(this.context, IPreferencesService.class, null);
            this.preferencesTracker.open();
        }
        try {
            filter = this.context.createFilter("(objectClass=" + IBundleGroupProvider.class.getName() + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.groupProviderTracker = new ServiceTracker(this.context, filter, null);
        this.groupProviderTracker.open();
        this.logReaderTracker = new ServiceTracker(this.context, ExtendedLogReaderService.class, null);
        this.logReaderTracker.open();
        this.extendedLogTracker = new ServiceTracker(this.context, ExtendedLogService.class, null);
        this.extendedLogTracker.open();
        this.environmentTracker = new ServiceTracker(this.context, EnvironmentInfo.class, null);
        this.environmentTracker.open();
        this.debugTracker = new ServiceTracker(this.context, DebugOptions.class, null);
        this.debugTracker.open();
    }

    private void startServices() {
        this.customPreferencesService = this.context.registerService(IProductPreferencesService.class, new ProductPreferencesService(), new Hashtable());
        this.legacyPreferencesService = this.context.registerService(ILegacyPreferences.class, new InitLegacyPreferences(), new Hashtable());
    }

    private void stopServices() {
        if (this.legacyPreferencesService != null) {
            this.legacyPreferencesService.unregister();
            this.legacyPreferencesService = null;
        }
        if (this.customPreferencesService != null) {
            this.customPreferencesService.unregister();
            this.customPreferencesService = null;
        }
    }

    private DebugOptions getDebugOptions() {
        return this.debugTracker == null ? null : this.debugTracker.getService();
    }

    private void closeOSGITrackers() {
        if (this.preferencesTracker != null) {
            this.preferencesTracker.close();
        }
        if (this.contentTracker != null) {
            this.contentTracker.close();
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
        }
        if (this.platformTracker != null) {
            this.platformTracker.close();
        }
        if (this.logTracker != null) {
            this.logTracker.close();
        }
        if (this.groupProviderTracker != null) {
            this.groupProviderTracker.close();
        }
        if (this.environmentTracker != null) {
            this.environmentTracker.close();
        }
        if (this.logReaderTracker != null) {
            this.logReaderTracker.close();
        }
        if (this.extendedLogTracker != null) {
            this.extendedLogTracker.close();
        }
        if (this.installLocation != null) {
            this.installLocation.close();
        }
        if (this.userLocation != null) {
            this.userLocation.close();
        }
        if (this.configurationLocation != null) {
            this.configurationLocation.close();
        }
        if (this.instanceLocation != null) {
            this.instanceLocation.close();
        }
    }

    public static void message(String message) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(new Date(System.currentTimeMillis()));
        buffer.append(" - [");
        buffer.append(Thread.currentThread().getName());
        buffer.append("] ");
        buffer.append(message);
        System.out.println(buffer.toString());
    }
}

